/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef GF_NOTIFICATION_H
#define GF_NOTIFICATION_H

#define GF_NOTIFICATION(obj)	((GfNotification *)obj)

typedef struct _GfNotification		GfNotification;

#include <glib.h>
#include <gdk/gdk.h>

#include "gf_event_info.h"
#include "gf_item.h"
#include "gf_theme.h"

#include "account.h"
#include "blist.h"
#include "conversation.h"
#include "xmlnode.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GfNotification *gf_notification_new(GfTheme *theme);
GfNotification *gf_notification_new_from_xmlnode(GfTheme *theme, xmlnode *node);
GfNotification *gf_notification_copy(GfNotification *notification);
xmlnode *gf_notification_to_xmlnode(GfNotification *notification);
void gf_notification_destroy(GfNotification *notification);

void gf_notification_set_type(GfNotification *notification, const gchar *type);
const gchar *gf_notification_get_type(GfNotification *notification);
void gf_notification_set_background(GfNotification *notification, const gchar *background);
const gchar *gf_notification_get_background(GfNotification *notification);
void gf_notification_add_item(GfNotification *notification, GfItem *item);
void gf_notification_remove_item(GfNotification *notification, GfItem *item);
GList *gf_notification_get_items(GfNotification *notification);

GList *gf_notifications_for_event(const gchar *type);
GfNotification *gf_notification_find_for_event(const gchar *type);
GdkPixbuf *gf_notification_render(GfNotification *notification, GfEventInfo *info);
GfTheme *gf_notification_get_theme(GfNotification *notification);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_NOTIFICATION_H */
