/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <glib.h>
#include <string.h>
#include <stdlib.h>

#include <xmlnode.h>

#include "gf_item.h"

struct _GfItemOffset {
	GfItem *item;
	gint value;
	gboolean percentage;
};

#include "gf_item_offset.h"

void
gf_item_offset_destroy(GfItemOffset *item_offset) {
	g_return_if_fail(item_offset);

	item_offset->item = NULL;
	item_offset->value = 0;
	item_offset->percentage = FALSE;

	g_free(item_offset);
	item_offset = NULL;
}

GfItemOffset *
gf_item_offset_new(GfItem *item) {
	GfItemOffset *offset;

	g_return_val_if_fail(item, NULL);

	offset = g_new0(GfItemOffset, 1);
	offset->item = item;

	return offset;
}

GfItemOffset *
gf_item_offset_new_from_xmlnode(GfItem *item, xmlnode *node) {
	GfItemOffset *offset;
	const gchar *data;

	g_return_val_if_fail(item, NULL);
	g_return_val_if_fail(node, NULL);

	offset = gf_item_offset_new(item);

	data = xmlnode_get_attrib(node, "value");
	if(!data) {
		gf_item_offset_destroy(offset);
		return NULL;
	}

	if(data[strlen(data) - 1] == '%')
		offset->percentage = TRUE;

	offset->value = atoi(data);

	return offset;
}

GfItemOffset *
gf_item_offset_copy(GfItemOffset *offset) {
	GfItemOffset *new_offset;

	g_return_val_if_fail(offset, NULL);

	new_offset = gf_item_offset_new(offset->item);
	new_offset->value = offset->value;
	new_offset->percentage = offset->percentage;

	return new_offset;
}

void
gf_item_offset_set_value(GfItemOffset *offset, gint value) {
	g_return_if_fail(offset);

	offset->value = value;
}

gint
gf_item_offset_get_value(GfItemOffset *offset) {
	g_return_val_if_fail(offset, -1);

	return offset->value;
}

void
gf_item_offset_set_is_percentage(GfItemOffset *offset, gboolean is_percentage) {
	g_return_if_fail(offset);

	offset->percentage = is_percentage;
}

gboolean
gf_item_offset_get_is_percentage(GfItemOffset *offset) {
	g_return_val_if_fail(offset, FALSE);

	return offset->percentage;
}

GfItem *
gf_item_offset_get_item(GfItemOffset *offset) {
	g_return_val_if_fail(offset, NULL);

	return offset->item;
}
