/*
  Guifications - The end all, be all, toaster popup plugin
  Copyright (C) 2003-2004 Gary Kramlich

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef GF_THEME_OPTIONS_H
#define GF_THEME_OPTIONS_H

typedef struct _GfThemeOptions GfThemeOptions;

#define GF_THEME_OPTIONS(obj)	((GfThemeOptions *)(obj))

#include <glib.h>

#include "xmlnode.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

GfThemeOptions *gf_theme_options_new();
GfThemeOptions *gf_theme_options_new_from_xmlnode(xmlnode *node);
xmlnode *gf_theme_options_to_xmlnode(GfThemeOptions *ops);
void gf_theme_options_destroy(GfThemeOptions *ops);

void gf_theme_options_set_time_format(GfThemeOptions *ops, const gchar *format);
const gchar *gf_theme_options_get_time_format(GfThemeOptions *ops);
void gf_theme_options_set_date_format(GfThemeOptions *ops, const gchar *format);
const gchar *gf_theme_options_get_date_format(GfThemeOptions *ops);
void gf_theme_options_set_warning(GfThemeOptions *ops, const gchar *warning);
const gchar *gf_theme_options_get_warning(GfThemeOptions *ops);
void gf_theme_options_set_ellipsis(GfThemeOptions *ops, const gchar *ellipsis);
const gchar *gf_theme_options_get_ellipsis(GfThemeOptions *ops);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_THEME_OPTIONS_H */
