/*****************************************************************************
 * callbacks.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include "gyach.h"
#include "gyach_int.h"

#include <gtk/gtk.h>

#include <sys/utsname.h>

#ifdef USE_PTHREAD_CREATE
#include <pthread.h>
#endif

#include <time.h>

#include "aliases.h"
#include "callbacks.h"
#include "commands.h"
#include "friends.h"
#include "history.h"
#include "ignore.h"
#include "images.h"
#include "interface.h"
#include "main.h"
#include "roomlist.h"
#include "support.h"
#include "users.h"
#include "util.h"
#include "yahoochat.h"


GtkWidget *favorites_window = NULL;
GtkWidget *file_sel;
GtkWidget *edit_win = NULL;
GtkWidget *help_win = NULL;
GtkStyle  *about_style = NULL;

GtkWidget *setup_list = NULL;
int setup_row_selected = -1;
int room_row_selected = -1;
char setup_which[31] = "";

#define FILE_MSG_SAVE	"Save Current Text"
#define FILE_MSG_LOG	"Log To File"

void
on_b_send_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	char *text;

	text = strdup(gtk_entry_get_text(GTK_ENTRY(chat_entry)));
	gtk_entry_set_text(GTK_ENTRY(chat_entry), "");

	if ( ! strlen( text ))
		return;

	history_add( text );

	/* ok, we have something to send */
	chat_command( text );
}


void
on_b_clear_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_entry_set_text(GTK_ENTRY(chat_entry), "");
}


void
on_window1_map                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
	chat_window = widget;
}


void
on_chat_entry_map                      (GtkWidget       *widget,
                                        gpointer         user_data)
{
	chat_entry = widget;
}


void
on_chat_entry_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_b_send_clicked( NULL, NULL );
}


void
on_aliases_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

}


void
on_aliases_map                        (GtkWidget       *widget,
                                        gpointer         user_data)
{
	chat_aliases = widget;

	read_aliases();
}


void
on_users_select_row                    (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gchar *useritem[1];
	gchar tmp_item[128];

	useritem[0] = tmp_item;

	gtk_clist_get_text( GTK_CLIST(chat_users), row, 1, useritem );

	if ( user_selected )
		free( user_selected );

	user_selected = strdup( useritem[0] );
}


void
on_users_map                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
	chat_users = widget;
	gtk_clist_set_sort_column(GTK_CLIST(chat_users), 1 );
	/*
	gtk_clist_set_auto_sort(GTK_CLIST(chat_users), 0 ); 
	*/
}


gboolean
on_aliases_clicked                    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gint row, column;
	gchar *listitem[1];
	gchar *useritem[1];
	gchar tmp_item[128];
	gchar tmp_item2[128];

	listitem[0] = tmp_item;
	useritem[0] = tmp_item2;

	if ( alias_window )
		return FALSE;

	if ((event->button == 1 && event->type == GDK_2BUTTON_PRESS) ||
		(event->button == 3 && event->type == GDK_BUTTON_PRESS))
	{
		if (!gtk_clist_get_selection_info(GTK_CLIST(chat_aliases),
				(gint) event->x, (gint) event->y, &row, &column))
		{
			return FALSE;
		}

		gtk_clist_unselect_all( GTK_CLIST(chat_aliases));
		gtk_clist_select_row( GTK_CLIST(chat_aliases), row, 0 );

		if ( gtk_clist_get_selectable( GTK_CLIST(chat_aliases), row )) {
			if (event->button == 1 && event->type == GDK_2BUTTON_PRESS) {
				/* double clicked send action */
				gtk_clist_get_text( GTK_CLIST(chat_aliases), row, 0,
					listitem );
				if ( user_selected ) {
					check_alias( listitem[0], user_selected );
					gtk_clist_unselect_all( GTK_CLIST(chat_users));
					free( user_selected );
					user_selected = NULL;
				} else {
					check_alias( listitem[0], "" );
				}
			} else {
				/* right clicked popup action window */
				alias_selected = row;
				gtk_menu_popup((GtkMenu *) alias_menu,
					NULL, NULL, NULL, NULL, 1, 0);

				/* old action was to send an alias on right click */
				/* now we do that on a subitem on this menu */
				/*
				gtk_clist_get_text( GTK_CLIST(chat_aliases), row, 0,
					listitem );
				if ( user_selected ) {
					check_alias( listitem[0], user_selected );
				} else {
					check_alias( listitem[0], "" );
				}
				*/
			}
		}
	}

	return FALSE;
}


void
on_users_unselect_row                  (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( user_selected )
		free( user_selected );
	user_selected = NULL;
}


void
on_connect_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( logged_in )
		return;

	gtk_widget_show( login_window );
}


void
on_disconnect_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	time_t current_time;
	int hours;
	int minutes;
	int seconds;
	char buf[128];

	/*
	GList *this_session = pm_list;
	PM_SESSION *pm_sess;
	*/

	if ( ! logged_in )
		return;

	/* if user wants, close any PM windows open */
	/* commented OUT for now because of occasional disconnect problem
	while( this_session ) {
		pm_sess = (PM_SESSION *)this_session->data;

		gtk_widget_destroy( pm_sess->pm_window );

		pm_list = g_list_remove_link( pm_list, this_session );
		gyach_g_list_free( this_session );

		this_session = pm_list;
	}
	*/

	ymsg9_logout( ymsg_sess );

	gtk_clist_clear(GTK_CLIST(chat_users));

	/* remove our registered event callback */
	if ( ymsg_sess->io_callback_tag ) {
		gdk_input_remove( ymsg_sess->io_callback_tag );
		ymsg_sess->io_callback_tag = 0;
	}

	if ( ymsg_sess->ping_callback_tag ) {
		gtk_timeout_remove( ymsg_sess->ping_callback_tag );
		ymsg_sess->ping_callback_tag = 0;
	}

	/* close the socket and mark us as logged out */
	close( ymsg_sess->sock ); 
	ymsg_sess->sock = -1; 
	ymsg_sess->quit = 1; 
	logged_in = 0;

	set_menu_connected( 0 );

	current_time = time(NULL);

	hours = (int)(( current_time - connect_time ) / 3600);
	minutes = (int)(( current_time - connect_time ) % 3600 ) / 60;
	seconds = (int)(( current_time - connect_time ) % 60 );

	/* show user that we aren't logged in anymore */
	snprintf( buf, sizeof(buf), "%s%s%s%s%s  Online for %d:%02d:%02d.\n\n",
		YAHOO_COLOR_BLUE, YAHOO_STYLE_BOLDON, "Disconnected from Chat!",
		YAHOO_STYLE_BOLDOFF, YAHOO_COLOR_BLACK, hours, minutes, seconds );
	append_to_textbox_color( chat_window, NULL, buf );

	gtk_statusbar_pop( GTK_STATUSBAR(chat_status), st_cid );
	gtk_statusbar_push( GTK_STATUSBAR(chat_status), st_cid,
		"Not currently connected to chat..." );
}


void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ymsg_sess->io_callback_tag ) {
		gdk_input_remove( ymsg_sess->io_callback_tag );
		ymsg_sess->io_callback_tag = 0;
	}

	if ( ymsg_sess->ping_callback_tag ) {
		gtk_timeout_remove( ymsg_sess->ping_callback_tag );
		ymsg_sess->ping_callback_tag = 0;
	}

	close( ymsg_sess->sock ); 
	ymsg_sess->sock = -1; 
	ymsg_sess->quit = 1; 

	history_save();

	gdk_threads_leave();

#ifndef OS_WINDOWS
	gtk_main_quit();
#endif
}


void
on_room_list_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	if ( ! room_window ) {
		room_window = create_room_list();
		gtk_widget_show( room_window );

		populate_room_list();
	} else {
		gtk_widget_show( room_window );

		if ( ! cache_room_list ) {
			tmp_widget = lookup_widget( room_window, "room_tree" );
			gtk_clist_clear( GTK_CLIST( tmp_widget ));
			populate_room_list();
		}
	}
}


void
on_favorites_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GList *this_item = NULL;
	GtkWidget *tmp_widget;
	gchar *listitem[1];
	int row;

	if ( favorites_window )
		return;

	room_row_selected = -1;

	favorites_window = create_favorites();
	gtk_widget_show( favorites_window );

	tmp_widget = lookup_widget( favorites_window, "fav_room_list" );

	gtk_clist_freeze(GTK_CLIST(tmp_widget));
	this_item = favroom_list;
	while( this_item ) {
		listitem[0] = this_item->data;
		row = gtk_clist_append(GTK_CLIST(tmp_widget), listitem );
		this_item = g_list_next( this_item );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));
}


void
on_add_to_favorites_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GList *this_item = NULL;

	this_item = favroom_list;
	while( this_item ) {
		if ( ! strcmp( this_item->data, ymsg_sess->room )) {
			return;
		}
		this_item = g_list_next( this_item );
	}

	favroom_list = g_list_append( favroom_list, strdup( ymsg_sess->room ));

	write_config();
}


void
on_help_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef USE_GTK2
	GtkTextIter iter;
	GtkTextBuffer *text_buffer;
#endif
	GtkWidget *tmp_widget;
	char buf[65535];

	if ( ! help_win ) {
#ifndef USE_GTK2
		if ( ! about_style ) {
			about_style = gtk_style_new();
			about_style->font = gdk_font_load("fixed");
		}
#endif

		help_win = create_help_window();

		strcpy( buf, "This is the help window, sometime I'll fill in some "
			"help text.\n" );

		tmp_widget = lookup_widget( help_win, "help_text" );

#ifdef USE_GTK2
		text_buffer = gtk_text_view_get_buffer( GTK_TEXT_VIEW(tmp_widget) );
		gtk_text_buffer_create_tag( text_buffer, "fixed_font", "font",
			"fixed 10", NULL);
		gtk_text_buffer_create_tag( text_buffer, "not_editable", "editable",
			FALSE, NULL );
		gtk_text_buffer_get_end_iter( text_buffer, &iter );
		gtk_text_buffer_insert_with_tags_by_name( GTK_TEXT_BUFFER(text_buffer),
			&iter, buf, -1, "fixed_font", "not_editable", NULL );
#else
		gtk_text_insert( GTK_TEXT(tmp_widget), NULL, NULL,
			NULL, buf, strlen( buf ) );
		gtk_widget_set_style( tmp_widget, about_style );
#endif

		gtk_widget_show( help_win );
	}
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	struct utsname un;
	char buf[1024];
	GtkWidget *tmp_widget;

	if ( ! about_box ) {
		if ( ! about_style ) {
			about_style = gtk_style_new();
#ifdef USE_GTK2
			about_style->font_desc = pango_font_description_from_string(
				"fixed 10" );
#else
			about_style->font = gdk_font_load("fixed");
#endif
		}

		about_box = create_about_box();

		snprintf(buf, sizeof(buf),
			"\nGyach v%s Copyright 2000-2002 Chris Pinkham\n\n"
			"This software comes with No Warranty.\n\n"
			"This is free software and is distributed under the GPL.  You\n"
			"may redistribute it under certain conditions.  For more "
				"information\n"
			"please see the file COPYING for details.\n\n", VERSION );
		tmp_widget = lookup_widget( about_box, "about_copy" );
		gtk_label_set_text( GTK_LABEL(tmp_widget), buf );

		uname(&un);
		snprintf(buf, sizeof(buf), "\n"
			"  Project Started ....... : July 2000\n"
			"  This Binary Compiled .. : " __DATE__ " at " __TIME__ "\n"
			"  GTK+ Version .......... : %d.%d.%d\n"
			"  Currently Running on .. : %s %s [%s]\n"
			"  Author EMail .......... : %s\n"
			"  Web Page .............. : %s\n",
			gtk_major_version, gtk_minor_version, gtk_micro_version,
			un.sysname, un.release, un.machine, GYACH_EMAIL, GYACH_URL );

		tmp_widget = lookup_widget( about_box, "about_info" );
		gtk_label_set_text( GTK_LABEL(tmp_widget), buf );
		gtk_widget_set_style( tmp_widget, about_style );

		gtk_widget_show( about_box );
	}
}


void
on_connection_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_user_menu_map                       (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


void
on_profile_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ! user_selected )
		return;

	gtk_timeout_add( 5, (void *)view_profile, (gpointer)user_selected );
}


void
on_pm_activate                         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	if ( ! user_selected )
		return;

	pm_window = create_pm_window();
	gtk_widget_show( pm_window );

	tmp_widget = lookup_widget( pm_window, "pm_user" );
	gtk_entry_set_text( GTK_ENTRY(tmp_widget), user_selected );
}


void
on_add_to_friends_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ! user_selected )
		return;
}


void
on_ignore_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ! user_selected )
		return;

	ignore_toggle( user_selected );
}


gboolean
on_users_clicked                       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	gint row, column;
	gchar *listitem[1];
	gchar tmp_item[128];
	char *tmp_ptr;

	listitem[0] = tmp_item;

	if ((event->button == 1 && event->type == GDK_2BUTTON_PRESS) ||
		(event->button == 3 && event->type == GDK_BUTTON_PRESS))
	{
		if (!gtk_clist_get_selection_info(GTK_CLIST(chat_users),
				(gint) event->x, (gint) event->y, &row, &column))
		{
			return FALSE;
		}

		gtk_clist_unselect_all( GTK_CLIST(chat_users));
		gtk_clist_select_row( GTK_CLIST(chat_users), row, 0 );

		if ( gtk_clist_get_selectable( GTK_CLIST(chat_users), row )) {
			gtk_clist_get_text( GTK_CLIST(chat_users), row, 1, listitem );
			if (event->button == 1 && event->type == GDK_2BUTTON_PRESS) {
				/* double clicked send PM */
				if ( user_selected )
					free( user_selected );
				user_selected = strdup( listitem[0] );

				pm_window = create_pm_window();
				gtk_widget_show( pm_window );
				tmp_widget = lookup_widget( pm_window, "pm_user" );
				gtk_entry_set_text( GTK_ENTRY(tmp_widget), user_selected );
			} else {
				/* right clicked so show popup user menu */

				/* set user_selected to null to we won't trigger */
				/* callbacks just by setting the active states */
				tmp_ptr = user_selected;
				user_selected = NULL;

				tmp_widget = lookup_widget( chat_user_menu, "ignore" );
				if ( ignore_check( tmp_ptr ))
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), TRUE);
				else
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), FALSE);

				tmp_widget = lookup_widget( chat_user_menu, "mute" );
				if ( mute_check( tmp_ptr ))
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), TRUE);
				else
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), FALSE);

				tmp_widget = lookup_widget( chat_user_menu, "follow" );
				if (( follow_user ) &&
					( ! strcmp( follow_user, tmp_ptr )))
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), TRUE);
				else
					gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
						(tmp_widget), FALSE);

				gtk_menu_popup((GtkMenu *) chat_user_menu,
					NULL, NULL, NULL, NULL, 1, 0);

				/* now set the user so the menu can activate stuff */
				user_selected = tmp_ptr;
			}

		}
	}

	return FALSE;
}


void
on_pm_send_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *pm_user;
	GtkWidget *pm_entry;
	gchar *listitem[1];
	gchar tmp_item[128];
	char buf[1024];

	listitem[0] = tmp_item;

	pm_user = lookup_widget( pm_window, "pm_user" );
	pm_entry = lookup_widget( pm_window, "pm_entry" );

	snprintf( buf, 1023, "/tell %s %s",
		gtk_entry_get_text(GTK_ENTRY(pm_user)),
		gtk_entry_get_text(GTK_ENTRY(pm_entry)));

	chat_command( buf );

	gtk_widget_destroy( pm_window );
}


void
on_pm_cancel_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy( pm_window );
}


void
on_pm_user_map                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
	pm_user = widget;
}


void
on_pm_entry_activate                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_pm_send_clicked( NULL, NULL );
}


void
on_login_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	logged_in = 0;
	valid_user = 1;

	tmp_widget = lookup_widget( login_window, "chat_username" );
	strcpy( ymsg_sess->user,
		gtk_entry_get_text( GTK_ENTRY(GTK_COMBO(tmp_widget)->entry)));

	tmp_widget = lookup_widget( login_window, "chat_password" );
	strcpy( ymsg_sess->password,
		gtk_entry_get_text( GTK_ENTRY(tmp_widget)));

	if ( password ) {
		free( password );
		password = NULL;
	}

	/* remember password, will be saved when we write_config() */
	if ( remember_password ) {
		password = strdup( ymsg_sess->password );
	}

	tmp_widget = lookup_widget( login_window, "chat_room" );
	strcpy( ymsg_sess->room,
		gtk_entry_get_text( GTK_ENTRY(GTK_COMBO(tmp_widget)->entry)));

	tmp_widget = lookup_widget( login_window, "chat_server" );
	strcpy( ymsg_sess->host,
		gtk_entry_get_text( GTK_ENTRY(GTK_COMBO(tmp_widget)->entry)));

	gtk_widget_hide( login_window );

	login_to_yahoo_chat();
}


void
on_cancel_login_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	username[0] = '\0';
	gtk_widget_hide( login_window );

	valid_user = 1;

	logged_in = 0;
}


void
on_cancel_favs_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy( favorites_window );
	favorites_window = NULL;
}


gboolean
on_user_picture_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_close_profile_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( ! profile_window )
		return;

	gtk_widget_destroy( profile_window );
	profile_window = NULL;
}


gboolean
on_homepage_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	/* fixme */
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( profile_window, "homepage" );

	display_url( GTK_LABEL(tmp_widget)->label );

	return FALSE;
}


gboolean
on_coollink1_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	/* fixme */
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( profile_window, "coollink1" );

	display_url( GTK_LABEL(tmp_widget)->label );

	return FALSE;
}


gboolean
on_coollink2_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	/* fixme */
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( profile_window, "coollink2" );

	display_url( GTK_LABEL(tmp_widget)->label );

	return FALSE;
}


gboolean
on_coollink3_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	/* fixme */
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( profile_window, "coollink3" );

	display_url( GTK_LABEL(tmp_widget)->label );

	return FALSE;
}


void
on_alias_edit_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	edit_alias();
}


void
on_alias_delete_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_clist_remove( GTK_CLIST(chat_aliases), alias_selected );
	alias_selected = -1;
	save_aliases();
}


void
on_alias_new_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gtk_clist_unselect_all( GTK_CLIST(chat_aliases));

	alias_selected = -1;
	edit_alias();
}


void
on_alias_send_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar *listitem[3];
	gchar alias_name[128];
	gchar cmd_value1[512];
	gchar cmd_value2[512];

	listitem[0] = alias_name;
	listitem[1] = cmd_value1;
	listitem[2] = cmd_value2;

	gtk_clist_get_text( GTK_CLIST(chat_aliases), alias_selected, 0,
		listitem );
	if ( user_selected ) {
		check_alias( listitem[0], user_selected );
	} else {
		check_alias( listitem[0], "" );
	}
}


void
on_alias_save_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	gchar *listitem[3];
	gchar tmp_item[12] = "tmp";
	gchar tmp_item2[12] = "tmp";
	gchar tmp_item3[12] = "tmp";

	listitem[0] = tmp_item;
	listitem[1] = tmp_item2;
	listitem[2] = tmp_item3;

	if ( alias_window ) {
		/* save the entry */

		if ( alias_selected == -1 ) {
			alias_selected = gtk_clist_append(GTK_CLIST(chat_aliases), 
				listitem );
		}

		tmp_widget = lookup_widget( alias_window, "alias_name" );
		strcpy(	tmp_item, gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
		gtk_clist_set_text(GTK_CLIST(chat_aliases), alias_selected, 0,
			tmp_item );
		tmp_widget = lookup_widget( alias_window, "cmd_value1" );
		gtk_clist_set_text(GTK_CLIST(chat_aliases), alias_selected, 1,
			gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
		tmp_widget = lookup_widget( alias_window, "cmd_value2" );
		gtk_clist_set_text(GTK_CLIST(chat_aliases), alias_selected, 2,
			gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

/*
		gtk_clist_sort(GTK_CLIST(chat_aliases));
*/

		alias_selected = -1;

		gtk_clist_unselect_all(GTK_CLIST(chat_aliases));

		save_aliases();

		/* now get rid of the window */
		on_alias_cancel_clicked( button, user_data );
	}
}


void
on_alias_cancel_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( alias_window ) {
		gtk_widget_hide( alias_window );
		gtk_widget_destroy( alias_window );
		alias_window = NULL;
	}
}



void
on_follow_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	char buf[129];

	if ( user_selected ) {
		snprintf( buf, sizeof(buf), "/follow %s", user_selected );
		try_command( buf );
	}
}


void
on_close_about_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy( about_box );

	about_box = NULL;
}


gboolean
on_chat_entry_key_press_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
#ifdef USE_GTK2
	GtkTextBuffer *text_buffer;
	GtkClipboard *clip;
#endif
	GtkWidget *tmp_widget;

	if ( event->type == GDK_KEY_PRESS ) {
		/*
		printf( "keyval pressed = %d\n", event->key.keyval ); fflush( stdout );
		*/

		switch( event->key.keyval ) {
			case 65289:	/* tab, try to expand */
						tab_complete();
						return( TRUE );
						break;

			case 65362:	/* up arrow, scroll up to previous message */
						gtk_entry_set_text( GTK_ENTRY(widget), history_prev());
						return( TRUE );
						break;

			case 65364:	/* down arrow, scroll down to next message */
						gtk_entry_set_text( GTK_ENTRY(widget), history_next());
						return( TRUE );
						break;

			case    99: /* c, try to copy if CTRL-C */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							tmp_widget = ct_widget();
#ifdef USE_GTK2
							text_buffer = gtk_text_view_get_buffer(
								GTK_TEXT_VIEW(tmp_widget) );
							clip = gtk_clipboard_get( GDK_SELECTION_CLIPBOARD );
							gtk_text_buffer_copy_clipboard( text_buffer, clip );
#else
							gtk_editable_copy_clipboard(
								&(GTK_TEXT(tmp_widget)->editable) );
#endif
							return( TRUE );
						}
						break;

			case   102: /* f, try to find if CTRL-F */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							search_pos = -1;
							if ( search_text ) {
								free( search_text );
								search_text = NULL;
							}

							if ( ! find_window ) {
								find_window = create_find_window();
							} else {
								if ( search_text ) {
									tmp_widget =lookup_widget( find_window,
										"search_text" );
									gtk_entry_set_text(GTK_ENTRY(tmp_widget),
										search_text );

									tmp_widget = lookup_widget( find_window,
										"case_sensitive" );
									gtk_toggle_button_set_active(
										&(GTK_CHECK_BUTTON(
											tmp_widget)->toggle_button),
										search_case_sensitive );
								}
							}
							gtk_widget_show( find_window );
							return( TRUE );
						}
						break;

			case   103: /* g, try to find next if CTRL-G */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							search_chat_text( search_case_sensitive );
							return( TRUE );
						}
						break;

			case   118: /* v, try to past if CTRL-V */
						/* since gtk_entry has a gtk_editable, it already */
						/* implements CTRL-V so we do nothing here */
						if ( event->key.state & GDK_CONTROL_MASK ) {
						}
						break;
/*
			default:	fprintf( stderr, "kv = %d\n", event->key.keyval );
						fflush( stderr );
*/
						break;
		}
	}

	return FALSE;
}


void
on_save_current_text_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gchar def_filename[255];

	if ( file_sel )
		return;

	file_sel = create_fileselection();

	if ( ! file_sel )
		return;

	gtk_widget_show( file_sel );

	snprintf( def_filename, sizeof(def_filename), "%s/capture.txt",
		GYACH_CFG_DIR );

	gtk_file_selection_set_filename(GTK_FILE_SELECTION (file_sel),
	        def_filename );

	gtk_window_set_title( GTK_WINDOW(file_sel), FILE_MSG_SAVE );
}


void
on_log_to_file_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	gchar def_filename[255];

	/* see if we are closing the file */
	if ( capture_fp ) {
		fclose( capture_fp );
		capture_fp = NULL;

		free( capture_filename );
		capture_filename = NULL;

		tmp_widget = lookup_widget( chat_window, "log_to_file" );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0 );
		return;
	}

	if ( file_sel )
		return;

	file_sel = create_fileselection();

	if ( ! file_sel ) {
		tmp_widget = lookup_widget( chat_window, "log_to_file" );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0 );
		return;
	}

	gtk_widget_show( file_sel );

	snprintf( def_filename, sizeof(def_filename), "%s/capture.log",
		GYACH_CFG_DIR );

	gtk_file_selection_set_filename(GTK_FILE_SELECTION (file_sel),
	        def_filename );

	gtk_window_set_title( GTK_WINDOW(file_sel), FILE_MSG_LOG );
}


void
on_status_here_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 0 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "0" );
}


void
on_status_be_right_back_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 1 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "1" );
}


void
on_status_busy_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 2 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "2" );
}


void
on_status_not_at_home_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 3 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "3" );
}


void
on_status_not_at_my_desk_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 4 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "4" );
}


void
on_status_not_in_the_office_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 5 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "5" );
}


void
on_status_on_the_phone_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 6 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "6" );
}


void
on_status_on_vacation_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 7 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "7" );
}


void
on_status_out_to_lunch_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 8 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "8" );
}


void
on_status_stepped_out_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 9 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "9" );
}


void
on_status_invisible_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 12 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "12" );
}


void
on_file_ok_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	time_t time_now;

	if ( ! file_sel )
		return;

	capture_filename = strdup(
		gtk_file_selection_get_filename( GTK_FILE_SELECTION( file_sel )));

	if ( ! strcmp( GTK_WINDOW(file_sel)->title, FILE_MSG_SAVE )) {
		/* fixme, what about error opening */
		capture_text_to_file( capture_filename );
		free( capture_filename );
	} else if ( ! strcmp( GTK_WINDOW(file_sel)->title, FILE_MSG_LOG )) {
		capture_fp = fopen( capture_filename, "ab" );
		if ( capture_fp ) {
			time_now = time(NULL);
			fprintf( capture_fp, "%s", ctime(&time_now) );
			fprintf( capture_fp, "------------------------\n" );
		} else {
			/* fixme, how about an error message?? */
			tmp_widget = lookup_widget( chat_window, "log_to_file" );
			gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0);
		}
	}

	gtk_widget_destroy( file_sel );
	file_sel = NULL;
}


void
on_file_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	if ( ! strcmp( GTK_WINDOW(file_sel)->title, FILE_MSG_LOG )) {
		tmp_widget = lookup_widget( chat_window, "log_to_file" );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0 );
	}

	gtk_widget_hide( file_sel );
	gtk_widget_destroy( file_sel );
	file_sel = NULL;
}


void
on_setup_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ! setup_window ) {
		setup_window = create_setup_window();

		set_setup_options();
	}

	/* finally show the window */
	gtk_widget_show( setup_window );
}


void
on_save_setup_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( ! setup_window )
		return;

	get_setup_options();

	write_config();

	/* destroy the window */
	gtk_widget_destroy( setup_window );
	setup_window = NULL;
}


void
on_cancel_setup_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( ! setup_window )
		return;

	gtk_widget_destroy( setup_window );
	setup_window = NULL;
}


void
on_colorselection_color_changed        (GtkColorSelection *colorselection,
                                        gpointer         user_data)
{

}


void
on_status_custom_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 10 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active )) {
		if ( custom_away_message )
			cmd_away( custom_away_message );
		else
			cmd_away( "Be Right Back" );
	}
}


void
on_setup_apply_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( ! setup_window )
		return;

	get_setup_options();

	/* destroy the window */
	gtk_widget_destroy( setup_window );
	setup_window = NULL;
}


void
on_goto_room_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	char buf[256];

	snprintf( buf, sizeof(buf), "/join %s", room_selected );
	chat_command( buf );
	if ( auto_close_roomlist )
		gtk_widget_hide( room_window );
}


void
on_cancel_room_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( room_window ) {
		gtk_widget_hide( room_window );
	}
}


gboolean
on_room_tree_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkCTreeNode *ctn;
	ROOM_ENTRY *room_item;
	gint row, column;
	char buf[256];

	if (( event->button == 1 ) &&
		(( event->type == GDK_BUTTON_PRESS ) ||
		 ( event->type == GDK_2BUTTON_PRESS ))) {
		if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				(gint) event->x, (gint) event->y, &row, &column)) {
			return FALSE;
		}

		ctn = gtk_ctree_node_nth(GTK_CTREE(widget), row);
		if (!ctn) {
			return FALSE;
		}

		room_item = gtk_ctree_node_get_row_data( GTK_CTREE(widget), ctn );

		if ( event->type == GDK_2BUTTON_PRESS ) {
			if ( room_item ) {
				snprintf( buf, sizeof(buf), "/join %s", room_item->room_name );
				chat_command( buf );

				if ( auto_close_roomlist )
					gtk_widget_hide( room_window );
			}
		} else {
			if ( room_selected )
				free( room_selected );

			if ( room_item )
				room_selected = strdup( room_item->room_name );
		}
	}

	return FALSE;
}


void
on_setup_insert_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	if ( edit_win )
		return;

	edit_win = create_edit_ignore_window();
	gtk_widget_show( edit_win );

	tmp_widget = lookup_widget( edit_win, "edit_ignore_label" );
	if ( ! strcmp( setup_which, "friend_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), "Add Friend" );
	} else if ( ! strcmp( setup_which, "regex_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), "Add Ignore Regex" );
	} else if ( ! strcmp( setup_which, "ignore_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), "Add User To Ignore" );
	} else if ( ! strcmp( setup_which, "login_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), "Add Yahoo Login" );
	} else if ( ! strcmp( setup_which, "favroom_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), "Add Favorite Room" );
	}

	tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );
	gtk_entry_set_text( GTK_ENTRY(tmp_widget), "" );

	setup_row_selected = -1;
	gtk_clist_unselect_all( GTK_CLIST(setup_list));
}


void
on_setup_delete_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	char *listitem[2];

	if ( setup_row_selected >= 0 ) {
		gtk_clist_get_text( GTK_CLIST(setup_list), setup_row_selected, 0,
			listitem );

		if ( ! strcmp( setup_which, "friend_list" )) {
			remove_friend( listitem[0] );
		}

		gtk_clist_remove( GTK_CLIST(setup_list), setup_row_selected );
	}
}


void
on_setup_edit_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	char *listitem[2];

	if ( edit_win )
		return;

	if ( setup_row_selected >= 0 ) {
		gtk_clist_get_text( GTK_CLIST(setup_list), setup_row_selected, 0,
			listitem );

		edit_win = create_edit_ignore_window();
		gtk_widget_show( edit_win );

		tmp_widget = lookup_widget( edit_win, "edit_ignore_label" );
		if ( ! strcmp( setup_which, "friend_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), "Edit Friend" );
		} else if ( ! strcmp( setup_which, "regex_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), "Edit Ignore Regex" );
		} else if ( ! strcmp( setup_which, "ignore_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), "Edit Ignored User" );
		} else if ( ! strcmp( setup_which, "favroom_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), "Edit Favorite Room" );
		} else if ( ! strcmp( setup_which, "login_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), "Edit Yahoo Login" );
		}

		tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );
		gtk_entry_set_text( GTK_ENTRY(tmp_widget), listitem[0] );
	}
}


gboolean
on_setup_list_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	gint row, column;
	gchar *listitem[1];
	gchar tmp_item[128];

	listitem[0] = tmp_item;

	setup_list = NULL;
	setup_row_selected = -1;

	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		tmp_widget = lookup_widget( setup_window, "friend_list" );
		gtk_clist_unselect_all( GTK_CLIST(tmp_widget));
		if ( tmp_widget == widget )
			strcpy( setup_which, "friend_list" );

		tmp_widget = lookup_widget( setup_window, "regex_list" );
		gtk_clist_unselect_all( GTK_CLIST(tmp_widget));
		if ( tmp_widget == widget )
			strcpy( setup_which, "regex_list" );

		tmp_widget = lookup_widget( setup_window, "ignore_list" );
		gtk_clist_unselect_all( GTK_CLIST(tmp_widget));
		if ( tmp_widget == widget )
			strcpy( setup_which, "ignore_list" );

		tmp_widget = lookup_widget( setup_window, "login_list" );
		gtk_clist_unselect_all( GTK_CLIST(tmp_widget));
		if ( tmp_widget == widget )
			strcpy( setup_which, "login_list" );

		tmp_widget = lookup_widget( setup_window, "favroom_list" );
		gtk_clist_unselect_all( GTK_CLIST(tmp_widget));
		if ( tmp_widget == widget )
			strcpy( setup_which, "favroom_list" );

		if ( gtk_clist_get_selection_info(GTK_CLIST(widget),
				(gint) event->x, (gint) event->y, &row, &column)) {
			gtk_clist_select_row( GTK_CLIST(widget), row, 0 );

			if ( gtk_clist_get_selectable( GTK_CLIST(widget), row )) {
				setup_row_selected = row;
			}
		}

		setup_list = widget;

		/* right clicked popup action window */
		gtk_menu_popup((GtkMenu *) setup_menu,
			NULL, NULL, NULL, NULL, 1, 0);
	}

	return FALSE;
}


void
on_edit_ig_save_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	char *listitem[2];
	char first[129];
	char second[129];

	tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );

	gtk_clist_get_text( GTK_CLIST(setup_list), setup_row_selected, 0,
		listitem );

	if ( setup_row_selected ) {
		/* editing a current row, so delete first */
		if ( ! strcmp( setup_which, "friends_list" )) {
			remove_friend( listitem[0] );
		}

		gtk_clist_remove( GTK_CLIST(setup_list), setup_row_selected );
		gtk_clist_unselect_all( GTK_CLIST(setup_list));
	}

	listitem[0] = first;
	listitem[1] = second;

	strcpy( first, gtk_entry_get_text( GTK_ENTRY(tmp_widget)));
	strcpy( second, "" );

	setup_row_selected = gtk_clist_append( GTK_CLIST(setup_list), listitem );
	if ( ! strcmp( setup_which, "regex_list" ))
		gtk_clist_set_text(GTK_CLIST(setup_list), setup_row_selected, 1, "" );
	gtk_clist_select_row( GTK_CLIST(setup_list), setup_row_selected, 0 );

	if ( edit_win )
		gtk_widget_destroy( edit_win );

	edit_win = NULL;

	if ( ! strcmp( setup_which, "friend_list" )) {
		add_friend( first );
	}
}


void
on_edit_ig_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( edit_win )
		gtk_widget_destroy( edit_win );

	edit_win = NULL;
}


void
on_status_autoaway_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (( my_status != 11 ) &&
		(GTK_CHECK_MENU_ITEM(menuitem)->active ))
		cmd_away( "11" );
}


void
on_help_close_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	if ( help_win ) {
		gtk_widget_destroy( help_win );
		help_win = NULL;
	}
}



gboolean
on_pm_window_destroy_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_favorites_destroy_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( favorites_window )
		gtk_widget_destroy( favorites_window );

	favorites_window = NULL;

	return( TRUE );
}


gboolean
on_profile_window_destroy_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( profile_window )
		gtk_widget_destroy( profile_window );

	profile_window = NULL;

	return( TRUE );
}


gboolean
on_alias_window_destroy_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_about_box_destroy_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( about_box )
		gtk_widget_destroy( about_box );

	about_box = NULL;

	return( TRUE );
}


gboolean
on_setup_window_destroy_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( setup_window )
		gtk_widget_destroy( setup_window );

	setup_window = NULL;

	return( TRUE );
}


gboolean
on_edit_ignore_window_destroy_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( edit_win )
		gtk_widget_destroy( edit_win );

	edit_win = NULL;

	return( TRUE );
}


gboolean
on_help_window_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( help_win )
		gtk_widget_destroy( help_win );

	help_win = NULL;

	return( TRUE );
}



gboolean
on_room_list_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( room_window ) {
		gtk_widget_hide( room_window );
	}

	return( TRUE );
}


void
on_exit_clicked                    (GtkButton *button,
                                        gpointer         user_data)
{
	on_quit_activate( NULL, NULL );
}


void
on_tgl_bold_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	use_bold = gtk_toggle_button_get_active( togglebutton );
}


void
on_tgl_italics_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	use_italics = gtk_toggle_button_get_active( togglebutton );
}


void
on_tgl_underline_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	use_underline = gtk_toggle_button_get_active( togglebutton );
}


void
on_pms_entry_activate                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	GtkWidget *pms_entry;
	PM_SESSION *pm_sess;
	char *text;
	char buf[1024] = "/tell ";


	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(editable), "pms_entry" )) != NULL ) {
		pm_sess = pm_lptr->data;
		pm_sess->typing = 0;
		/* don't really need this that I know of
		ymsg9_typing(  ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		*/

		pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );

		text = strdup(gtk_entry_get_text(GTK_ENTRY(pms_entry)));
		gtk_entry_set_text(GTK_ENTRY(pms_entry), "");

		if ( ! strlen( text ))
			return;

		if ( text[0] == '!' ) {
			if ( text[1] == '!' ) {
				cmd_exec( pm_sess->pm_window, pm_sess->pm_text, text+2, 1,
					pm_sess->pm_user, 0 );
			} else {
				cmd_exec( pm_sess->pm_window, pm_sess->pm_text, text+1, 0,
					pm_sess->pm_user, 0 );
			}
		} else {
			strcat( buf, pm_sess->pm_user );
			strcat( buf, " " );
			strcat( buf, text );

			chat_command( buf );

			snprintf( buf, sizeof(buf), "%s%s%s%s%s: %s\n",
				YAHOO_COLOR_BLUE, YAHOO_STYLE_BOLDON, ymsg_sess->user,
				YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF, text );
			append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf);
		}

		snprintf( buf, sizeof(buf), "%s - Gyach", pm_sess->pm_user );
		gtk_window_set_title( GTK_WINDOW(pm_sess->pm_window), buf );

		free( text );

		if (( my_status ) &&
			( my_status != 12 ) &&
			( pm_brings_back )) {
			cmd_away( "0" );
		}
	}
}


void
on_pms_close_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;

	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(button), "pms_close" )) != NULL ) {
		pm_sess = pm_lptr->data;
		gtk_widget_destroy( pm_sess->pm_window );
		pm_list = g_list_remove( pm_list, pm_sess );
		free( pm_sess );
	}
}


void
on_pms_send_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	GtkWidget *pms_entry;
	PM_SESSION *pm_sess;
	char *text;
	char buf[1024] = "/tell ";


	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(button), "pms_send" )) != NULL ) {
		pm_sess = pm_lptr->data;

		pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );

		text = strdup(gtk_entry_get_text(GTK_ENTRY(pms_entry)));
		gtk_entry_set_text(GTK_ENTRY(pms_entry), "");

		if ( ! strlen( text ))
			return;

		strcat( buf, pm_sess->pm_user );
		strcat( buf, " " );
		strcat( buf, text );

		chat_command( buf );

		snprintf( buf, sizeof(buf), "%s%s%s%s%s: %s\n",
			YAHOO_COLOR_BLUE, YAHOO_STYLE_BOLDON, ymsg_sess->user,
			YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF, text );
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf );

		free( text );
	}
}


void
on_pms_clear_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	GtkWidget *pms_entry;
	PM_SESSION *pm_sess;


	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(button), "pms_clear" )) != NULL ) {
		pm_sess = pm_lptr->data;

		pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );

		gtk_entry_set_text(GTK_ENTRY(pms_entry), "");
	}
}


gboolean
on_pm_session_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;


	if (( pm_lptr = find_pm_session_from_widget( widget, "" )) != NULL ) {
		pm_sess = pm_lptr->data;
		gtk_widget_destroy( pm_sess->pm_window );
		pm_list = g_list_remove( pm_list, pm_sess );
		free( pm_sess );
	}

	return( TRUE );
}


void
on_pms_ignore_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;


	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(button), "pms_ignore" )) != NULL ) {
		pm_sess = pm_lptr->data;

		gtk_widget_destroy( pm_sess->pm_window );
		pm_list = g_list_remove( pm_list, pm_sess );

		if ( ! ignore_check( pm_sess->pm_user ))
			ignore_toggle( pm_sess->pm_user );

		free( pm_sess );
	}
}


void
on_chat_status_map                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
	chat_status = widget;
}


void
on_pms_profile_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;
	char *ptr;
#ifdef USE_PTHREAD_CREATE
	pthread_t prof_thread;
#endif


	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(button), "pms_profile" )) != NULL ) {
		pm_sess = pm_lptr->data;

		ptr = strdup( pm_sess->pm_user );
#ifdef USE_PTHREAD_CREATE
		pthread_create( &prof_thread, NULL, fetch_profile, (void *)ptr );
#else
		fetch_profile((void *)ptr );
#endif
	}

	return;
}


void
on_room_tree_tree_expand               (GtkCTree        *ctree,
                                        GList           *node,
                                        gpointer         user_data)
{
	GtkCTreeNode *ctn;
	GtkCTreeRow *ctr;
	ROOM_ENTRY *room_item;

	ctr = GTK_CTREE_ROW( node );

	ctn = gtk_ctree_find_node_ptr( ctree, ctr );

	room_item = gtk_ctree_node_get_row_data( ctree, ctn );

	if ( ! room_item->populated ) {
		populate_child_room_list( room_item->room_id, ctree, ctn );
		room_item->populated = 1;

		if ( room_item->temp_child ) {
			gtk_ctree_remove_node( ctree, room_item->temp_child );
			room_item->temp_child = NULL;
		}
	}
}


gboolean
on_favroom_list_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gint row, column;
	gchar *listitem[1];
	gchar tmp_item[128];
	char buf[256];

	listitem[0] = tmp_item;

	setup_list = widget;
	setup_row_selected = -1;

	if (( event->button == 1 ) &&
		(( event->type == GDK_BUTTON_PRESS ) ||
		 ( event->type == GDK_2BUTTON_PRESS ))) {
		if (!gtk_clist_get_selection_info(GTK_CLIST(widget),
				(gint) event->x, (gint) event->y, &row, &column)) {
			return FALSE;
		}

		if ( event->type == GDK_BUTTON_PRESS ) {
			room_row_selected = row;
		}else {
			gtk_clist_select_row( GTK_CLIST(widget), row, 0 );

			if ( gtk_clist_get_selectable( GTK_CLIST(widget), row )) {
				gtk_clist_get_text( GTK_CLIST(widget), row, 0, listitem );

				if ( ! strcmp( listitem[0], ymsg_sess->room )) {
					return FALSE;
				}

				/* join room */
				snprintf( buf, sizeof(buf), "/join %s", listitem[0] );
				chat_command( buf );
				gtk_widget_destroy( favorites_window );
				favorites_window = NULL;
			}
		}

	}

  return FALSE;
}


void
on_goto_fav_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	gchar *listitem[1];
	gchar tmp_item[128];
	char buf[256];

	listitem[0] = tmp_item;

	if ( room_row_selected == -1 ) {
		return;
	}

	tmp_widget = lookup_widget( favorites_window, "fav_room_list" );

	if ( !gtk_clist_get_text(GTK_CLIST(tmp_widget), room_row_selected, 0,
			listitem )) {
		return;
	}

	if ( ! strcmp( listitem[0], ymsg_sess->room )) {
		return;
	}

	/* join room */
	snprintf( buf, sizeof(buf), "/join %s", listitem[0] );
	chat_command( buf );
	gtk_widget_destroy( favorites_window );
	favorites_window = NULL;

	return;
}


gboolean
on_chat_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( ymsg_sess->io_callback_tag ) {
		gdk_input_remove( ymsg_sess->io_callback_tag );
		ymsg_sess->io_callback_tag = 0;
	}

	if ( ymsg_sess->ping_callback_tag ) {
		gtk_timeout_remove( ymsg_sess->ping_callback_tag );
		ymsg_sess->ping_callback_tag = 0;
	}

	close( ymsg_sess->sock ); 
	ymsg_sess->sock = -1; 
	ymsg_sess->quit = 1; 

	history_save();

	gdk_threads_leave();

	gtk_main_quit();

	return FALSE;
}


void
on_packet_debugging_activate           (GtkCheckMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *checkitem;
	int value;

	checkitem = lookup_widget( chat_window, "packet_debugging" );
	value = GTK_CHECK_MENU_ITEM(checkitem)->active;
	tmp_widget = lookup_widget( chat_window, "tgl_debug" );

	if ( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(tmp_widget)) != value ) {
		if ( value ) {
			ymsg_sess->debug_packets = 1;
		} else {
			ymsg_sess->debug_packets = 0;
		}

		gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(tmp_widget),
			ymsg_sess->debug_packets );
	}
}

void
on_packet_debugging_toggled           (GtkToggleButton   *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	int value;

	tmp_widget = lookup_widget( chat_window, "packet_debugging" );
	value = gtk_toggle_button_get_active( button );

	if ( GTK_CHECK_MENU_ITEM(tmp_widget)->active != value ) {
		if ( value ) {
			ymsg_sess->debug_packets = 1;
		} else {
			ymsg_sess->debug_packets = 0;
		}

		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget),
			ymsg_sess->debug_packets );
	}
}


gboolean
on_pms_text_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
#ifdef USE_GTK2
	int x, y;
	gint buf_x, buf_y;
#endif
	gchar *ptr;

	if (event->button == 1 && event->type == GDK_BUTTON_PRESS) {
#ifdef USE_GTK2
		x = event->x;
		y = event->y;

		gtk_text_view_window_to_buffer_coords( GTK_TEXT_VIEW(widget),
			GTK_TEXT_WINDOW_TEXT, x, y, &buf_x, &buf_y );
		ptr = get_word_at_pos( GTK_TEXT_VIEW(widget), buf_x, buf_y );
#else
		ptr = get_word_at_cursor( GTK_TEXT(widget));
#endif
		if ( check_clicked_text( ptr )) {
			return( TRUE );
		}
	}

	return FALSE;
}


void
on_color_custom_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	int set;

	tmp_widget = lookup_widget( setup_window, "color_custom" );
	set = GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active;

	tmp_widget = lookup_widget( setup_window, "colorselection" );
	if ( set ) {
		gtk_widget_set_sensitive( tmp_widget, 1 );
	} else {
		gtk_widget_set_sensitive( tmp_widget, 0 );
	}
}


void
on_reload_room_list_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( room_window, "room_tree" );
	gtk_clist_clear( GTK_CLIST( tmp_widget ));
	populate_room_list();
}


gboolean
on_pms_entry_key_press_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;

	if (( pm_lptr = find_pm_session_from_widget( GTK_WIDGET(widget), "pms_entry" )) != NULL ) {
		pm_sess = pm_lptr->data;

		if ( ! pm_sess->typing ) {
			pm_sess->typing = 1;
			ymsg9_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		}
	}

	return FALSE;
}


void
on_find_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;
	int case_sensitive;

	tmp_widget = lookup_widget( find_window, "search_text" );

	search_pos = -1;
	search_text = strdup( gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

	tmp_widget = lookup_widget( find_window, "case_sensitive" );
	case_sensitive = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	search_chat_text( case_sensitive );
}


void
on_clear_find_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( find_window, "search_text" );
	gtk_entry_set_text(GTK_ENTRY(tmp_widget), "");

	search_pos = -1;
	if ( search_text ) {
		free( search_text );
		search_text = NULL;
	}
}


void
on_cancel_find_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( find_window, "search_text" );
	gtk_entry_set_text(GTK_ENTRY(tmp_widget), "");

	gtk_widget_hide( find_window );
}


void
on_find_next_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	search_chat_text( search_case_sensitive );
}


gboolean
on_find_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( find_window )
		gtk_widget_destroy( find_window );

	find_window = NULL;

	return( TRUE );
}


void
on_search_text_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_find_button_clicked( NULL, NULL );
}


void
on_browser_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
	char *browser = (char *)user_data;
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( setup_window, "browser_command" );

	if ( ! strcmp( browser, "netscape" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"netscape -noraise -remote 'openURL(%s,Gyach)'");
	} else if ( ! strcmp( browser, "mozilla" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"mozilla -remote 'openURL(%s,new-window)'");
	} else if ( ! strcmp( browser, "phoenix" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"phoenix '%s'");
	} else if ( ! strcmp( browser, "opera" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"opera -remote 'openURL(%s,new-window)'");
	} else if ( ! strcmp( browser, "konquerer" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"kfmclient openURL '%s'");
	} else {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"netscape -noraise -remote 'openURL(%s)'");
	}
}


gboolean
on_colors_window_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	if ( color_window )
		gtk_widget_destroy( color_window );

	color_window = NULL;

	return( TRUE );
}


void
on_mute_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( ! user_selected )
		return;

	mute_toggle( user_selected );
}

