/*****************************************************************************
 * friends.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/

#include "config.h"

#include "gyach.h"
#include "friends.h"
#include "main.h"
#include "users.h"
#include "util.h"
#include "yahoochat.h"

GList *friend_list = NULL;
GList *ofriend_list = NULL;

void populate_friend_list( char *friends ) {
	char *ptr;
	char *ptr2;
	char *end;
	char *end2;
	int last = 0;
	int last2 = 0;

	if (( strchr( friends, ':' )) &&
		( friend_list )) {
		friend_list = gyach_g_list_free( friend_list );
	}

	/* search groups */
	ptr = strchr( friends, ':' );
	do {
		if ( ptr ) {
			end = strchr( ptr + 1, '\xa' );
			ptr++;
		} else {
			end = strchr( friends, '\xa' );
			ptr = friends;
		}
		if ( end ) {
			*end = '\0';
		} else {
			last = 1;
		}

		/* now search for people within group */
		last2 = 0;
		ptr2 = ptr;
		while( ptr2 ) {
			end2 = strchr( ptr2, ',' );
			if ( end2 ) {
				*end2 = '\0';
			} else {
				last2 = 1;
			}

			friend_list = g_list_append( friend_list, strdup( ptr2 ));

			if ( last2 ) {
				ptr2 = NULL;
			} else {
				ptr2 = end2 + 1;
			}
		}

		if ( last ) {
			ptr = NULL;
		} else {
			ptr = strchr( end + 1, ':' );
		}
	} while( ptr );

	return;
}

int remove_friend( char *friend ) {
	GList *this_friend;

	ymsg9_remove_buddy( ymsg_sess, friend );

	this_friend = friend_list;
	while( this_friend ) {
		if ( ! strcasecmp( this_friend->data, friend )) {
			friend_list = g_list_remove_link( friend_list, this_friend );
			gyach_g_list_free( this_friend );
			return( 0 );
		}
		this_friend = g_list_next( this_friend );
	}

	build_tab_complete_list();

	return( 0 );
}

int add_friend( char *friend ) {
	ymsg9_add_buddy( ymsg_sess, friend );

	friend_list = g_list_append( friend_list, strdup( friend ));

	build_tab_complete_list();

	return( 0 );
}

int find_friend( char *friend ) {
	GList *this_friend;

	this_friend = friend_list;
	while( this_friend ) {
		if ( ! strcasecmp( this_friend->data, friend )) {
			return( 1 );
		}
		this_friend = g_list_next( this_friend );
	}

	return( 0 );
}

int remove_online_friend( char *friend ) {
	GList *this_friend;

	this_friend = ofriend_list;
	while( this_friend ) {
		if ( ! strcasecmp( this_friend->data, friend )) {
			ofriend_list = g_list_remove_link( ofriend_list, this_friend );
			gyach_g_list_free( this_friend );
			return( 0 );
		}
		this_friend = g_list_next( this_friend );
	}

	return( 0 );
}

int add_online_friend( char *friend ) {
	if ( ! find_online_friend( friend )) {
		ofriend_list = g_list_append( ofriend_list, strdup( friend ));
	}

	return( 0 );
}

int find_online_friend( char *friend ) {
	GList *this_friend;

	this_friend = ofriend_list;
	while( this_friend ) {
		if ( ! strcasecmp( this_friend->data, friend )) {
			return( 1 );
		}
		this_friend = g_list_next( this_friend );
	}

	return( 0 );
}

int show_friends( void ) {
	GList *this_friend;
	char msg[4096];
	int any_online = 0;


	sprintf( msg, "%s%sCurrent Buddylist:%s%s ", YAHOO_COLOR_BLUE,
		YAHOO_STYLE_BOLDON, YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF );

	this_friend = friend_list;
	while( this_friend ) {
		if ( this_friend != friend_list )
			strcat( msg, ", " );

		if ( find_online_friend( this_friend->data )) {
			strcat( msg, YAHOO_COLOR_RED );
			strcat( msg, this_friend->data );
			strcat( msg, YAHOO_COLOR_BLACK );
			any_online = 1;
		} else {
			strcat( msg, this_friend->data );
		}

		this_friend = g_list_next( this_friend );
	}

	if ( ! friend_list ) {
		strcat( msg, "No known friends." );
	} else {
		if ( any_online ) {
			strcat( msg, "   (friends online in " );
				strcat( msg, YAHOO_COLOR_RED );
				strcat( msg, "RED" );
				strcat( msg, YAHOO_COLOR_BLACK );
				strcat( msg, ")" );
		}
	}

	strcat( msg, "\n" );

	append_to_textbox_color( chat_window, NULL, msg );

	return( 0 );
}

int build_online_friends_list( void ) {
	GList *tmp_list = NULL;
	char *ptr;
	char *end;

	if ( ofriend_list ) {
		while( ofriend_list ) {
			tmp_list = ofriend_list;
			ofriend_list = g_list_remove_link( ofriend_list, ofriend_list );
			gyach_g_list_free( tmp_list );
		}
	}

	ymsg_sess->pkt.data[ymsg_sess->pkt.size] = '\0';
	ptr = ymsg_sess->pkt.data;

	/* find first field separator */
	while(( ptr < ( ymsg_sess->pkt.data + ymsg_sess->pkt.size )) &&
		( *ptr != '\0' ) &&
		( *ptr != '\300' )) {
		ptr++;
	}
	ptr += 2;

	/* now find the names */
	while( ptr < ( ymsg_sess->pkt.data + ymsg_sess->pkt.size )) {
		end = ptr;
		while( end < ( ymsg_sess->pkt.data + ymsg_sess->pkt.size )) {
			if (( *end == '\300' ) ||
				( *end == '\0' )) {
				*end = '\0';
				break;
			}
			end++;
		}

		ofriend_list = g_list_append( ofriend_list, strdup( ptr ));

		end += 2;
		while( end < ( ymsg_sess->pkt.data + ymsg_sess->pkt.size )) {
			if (( *end == '\300' ) ||
				( *end == '\0' )) {
				*end = '\0';
				break;
			}
			end++;
		}
		ptr = end + 2;
	}

	return( 0 );
}

