/*****************************************************************************
 * gyach_int.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/

#include "config.h"

#ifdef USE_GTK2
#include <sys/stat.h>
#include <unistd.h>
#endif

#include "gyach.h"
#include "callbacks.h"
#include "friends.h"
#include "gyach_int.h"
#include "ignore.h"
#include "images.h"
#include "interface.h"
#include "history.h"
#include "main.h"
#include "roomlist.h"
#include "support.h"
#include "users.h"
#include "util.h"

GtkWidget *color_window = NULL;

int highlight_friends = 0;
int	indent_wrapped;
#define INDENT_DEFAULT 60

#ifdef USE_GTK2
GtkWidget *top_text;
GtkWidget *vpaned;
int transparent_bg = 0;
int shading_r = 0;
int shading_g = 0;
int shading_b = 0;
#endif

/* items on menu to activate when connected */
static char *conn_menu_items[] = {
		"disconnect",	"save_current_text",	"log_to_file",
		"favorites",	"add_to_favorites", 	"rooms",
		"status",
		NULL
	};

/* items on menu to activate when DISconnected */
static char *disconn_menu_items[] = {
		"connect",
		NULL
	};

int build_toolbar( GtkWidget *chat_window ) {
	GtkWidget *tgl_exit;
	GtkWidget *tgl_debug;
	GtkWidget *tgl_bold;
	GtkWidget *tgl_italics;
	GtkWidget *tgl_underline;
	GtkWidget *bt_colors;
	GtkWidget *chat_toolbar;
	GdkPixmap *st_pixmap = NULL;
	GdkBitmap *st_mask = NULL;
	GtkWidget *tmp_pixmap;
	GtkStyle *user_style = NULL;
	int tsize = 20;        /* size of toolbar buttons in pixels wide & high */

	chat_toolbar = lookup_widget( chat_window, "chat_toolbar" );

	user_style = gtk_widget_get_style( chat_toolbar );

	/* exit button */
	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_exit );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	tgl_exit = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_BUTTON, NULL, " Exit ", "Exit Gyach",
		NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (tgl_exit);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "tgl_exit", tgl_exit,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tgl_exit);
	gtk_widget_set_usize (tgl_exit, tsize, tsize);

	/* give us a blank */
	gtk_toolbar_append_space( GTK_TOOLBAR (chat_toolbar));

	/* packet debugging button */
	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_debug );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	tgl_debug = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, " Debug ", "Packet Debugging",
		NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (tgl_debug);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "tgl_debug", tgl_debug,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tgl_debug);
	gtk_widget_set_usize (tgl_debug, tsize, tsize);

	/* give us a blank */
	gtk_toolbar_append_space( GTK_TOOLBAR (chat_toolbar));

	/* now the bold button */
	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_bold );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	tgl_bold = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, " B ", "Send your text in Bold",
		NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (tgl_bold);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "tgl_bold", tgl_bold,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tgl_bold);
	gtk_widget_set_usize (tgl_bold, tsize, tsize);

	/* now the italic button */
	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_italic );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	tgl_italics = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, " I ", "Send your text in italic",
		NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (tgl_italics);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "tgl_italics",
		tgl_italics, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tgl_italics);
	gtk_widget_set_usize (tgl_italics, tsize, tsize);

	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_underline );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	tgl_underline = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_TOGGLEBUTTON, NULL, " U ",
		"Send your text in underline", NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (tgl_underline);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "tgl_underline",
		tgl_underline, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tgl_underline);
	gtk_widget_set_usize (tgl_underline, tsize, tsize);

	/* give us a blank */
	gtk_toolbar_append_space( GTK_TOOLBAR (chat_toolbar));

	/* colors button */
	st_pixmap = gdk_pixmap_create_from_xpm_d(
		chat_toolbar->window, &st_mask,
		&user_style->bg[GTK_STATE_NORMAL],
		(gchar **)pixmap_colors );
	tmp_pixmap = gtk_pixmap_new( st_pixmap, st_mask );
	bt_colors = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
		GTK_TOOLBAR_CHILD_BUTTON, NULL, " Colors ", "Send Color Dialog",
		NULL, tmp_pixmap, NULL, NULL);
	gtk_widget_ref (bt_colors);
	gtk_object_set_data_full (GTK_OBJECT (chat_window), "bt_colors", bt_colors,
		(GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bt_colors);
	gtk_widget_set_usize (bt_colors, tsize, tsize);

	/* setup some signals */
	gtk_signal_connect (GTK_OBJECT (tgl_exit), "clicked",
		GTK_SIGNAL_FUNC (on_exit_clicked), NULL);
	gtk_signal_connect (GTK_OBJECT (tgl_debug), "toggled",
		GTK_SIGNAL_FUNC (on_packet_debugging_toggled), NULL);
	gtk_signal_connect (GTK_OBJECT (tgl_bold), "toggled",
		GTK_SIGNAL_FUNC (on_tgl_bold_toggled), NULL);
	gtk_signal_connect (GTK_OBJECT (tgl_italics), "toggled",
		GTK_SIGNAL_FUNC (on_tgl_italics_toggled), NULL);
	gtk_signal_connect (GTK_OBJECT (tgl_underline), "toggled",
		GTK_SIGNAL_FUNC (on_tgl_underline_toggled), NULL);
	gtk_signal_connect (GTK_OBJECT (bt_colors), "clicked",
		GTK_SIGNAL_FUNC (do_color_window), NULL);

	return( 0 );
}

#ifdef TRANS_BG
gboolean configure_event_notify (GtkWidget *widget, GdkEvent *event,
		gpointer user_data) {
	if ( transparent_bg )
		ct_update_bg();

	return( FALSE );
}
#endif

GtkWidget *build_chat_window( void ) {
	GtkWidget *tmp_widget;
	GtkStyle *windowstyle;
	GdkPixmap *pm_icon;
	GdkBitmap *mask_icon;
/*
	GtkStyle *entry_style;
#ifndef USE_GTK2
	char font_size_str[10];
#endif
*/

	chat_window = create_window1();
	gtk_window_set_title( GTK_WINDOW(chat_window), "Gyach v" VERSION );

	/* set default window sizes from saved values */
	if ( remember_position )
		gtk_widget_set_uposition( chat_window, chat_window_x, chat_window_y );
	gtk_widget_set_usize( chat_window, chat_window_width, chat_window_height );
	gtk_window_set_default_size( GTK_WINDOW(chat_window), chat_window_width,
		chat_window_height );

	ct_build();
	ct_set_max_lines( buffer_size );

	tmp_widget = lookup_widget( chat_window, "hbox2" );
	gtk_widget_set_usize( tmp_widget, chat_text_width, -2 );
	tmp_widget = lookup_widget( chat_window, "scrolledwindow3" );
	gtk_widget_set_usize( tmp_widget, -2, chat_user_height );

	/* set the chat entry box font */
/*
	tmp_widget = lookup_widget( chat_window, "chat_entry" );
	entry_style = gtk_style_new();
#ifdef USE_GTK2
	entry_style->font_desc = pango_font_description_from_string( font_name );
	if ( entry_style->font_desc )
		gtk_widget_set_style( tmp_widget, entry_style );
#else
	sprintf( font_size_str, "%d", font_size );
	entry_style->font = getFont( 0, 0, 0, font_family, font_size_str );
	if ( entry_style->font )
		gtk_widget_set_style( tmp_widget, entry_style );
#endif
*/


	gtk_widget_show( chat_window );

#ifdef TRANS_BG
	gtk_signal_connect (GTK_OBJECT (chat_window), "configure_event",
	        GTK_SIGNAL_FUNC(configure_event_notify), NULL);

	if ( transparent_bg ) {
		ct_set_transparent_shade( shading_r, shading_g, shading_b );
		ct_set_transparent( 1 );
	}
#endif

	gtk_clist_set_compare_func( GTK_CLIST(chat_users), clist_strcasecompare );

	/* attach our icon */
	windowstyle = gtk_widget_get_style( chat_window );
	pm_icon = gdk_pixmap_create_from_xpm_d( chat_window->window,
		&mask_icon, &(windowstyle->bg[GTK_STATE_NORMAL]),
		(gchar **)pixmap_gyach_icon );
	gdk_window_set_icon( chat_window->window, NULL, pm_icon, mask_icon );

	build_toolbar( chat_window );

	st_cid = gtk_statusbar_get_context_id( GTK_STATUSBAR(chat_status),
		"Gyach" );

	set_menu_connected( 0 );

	/* set any options that need the window created */
	set_config();

	chat_user_menu = create_user_menu();
	alias_menu = create_alias_menu();
	setup_menu = create_setup_menu();

	return( chat_window );
}


GtkWidget *build_login_window( void ) {
	GtkWidget *tmp_widget;
	GList *serverlist = NULL;

	login_window = create_login_window();

	if ( ! password )
		password = strdup( "" );

	tmp_widget = lookup_widget( login_window, "chat_username" );

	if ( login_list )
		gtk_combo_set_popdown_strings( GTK_COMBO(tmp_widget), login_list );

	tmp_widget = lookup_widget( login_window, "chat_password" );
	gtk_entry_set_text( GTK_ENTRY(tmp_widget), password );

	if ( ! favroom_list ) {
		favroom_list = g_list_append( favroom_list,
			strdup( "Linux, FreeBSD, Solaris:1" ));
		favroom_list = g_list_append( favroom_list, strdup( "Programming:1" ));
	}

	tmp_widget = lookup_widget( login_window, "chat_room" );

	gtk_combo_set_popdown_strings( GTK_COMBO(tmp_widget), favroom_list );

	/* fixme, save this setting in the gyachrc file */
	/* fixme, make it auto-detect these and try going through the list */
	serverlist = g_list_append( serverlist, "scs.msg.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs52.msg.dcn.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs53.msg.dcn.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs54.msg.dcn.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs51.msg.dcn.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs50.msg.dcn.yahoo.com" );
	serverlist = g_list_append( serverlist, "cs45.msg.dcn.yahoo.com" );

	tmp_widget = lookup_widget( login_window, "chat_server" );
	gtk_combo_set_popdown_strings( GTK_COMBO(tmp_widget), serverlist );

	if ( login_list ) {
		my_strncpy( ymsg_sess->user, (char*)login_list->data,
			YMSG9_USER_SIZE);
	} else {
		strcpy( ymsg_sess->user, "" );
	}
	my_strncpy( ymsg_sess->password, password, YMSG9_PASSWORD_SIZE );
	my_strncpy( ymsg_sess->room, (char*)favroom_list->data,
		YMSG9_ROOM_SIZE );
	my_strncpy( ymsg_sess->host, (char*)serverlist->data,
		YMSG9_HOST_SIZE );

	return( login_window );
}

void set_config() {
	GtkWidget *tmp_widget;

	DBG( 1, "set_config()\n" );

	tmp_widget = lookup_widget( chat_window, "tgl_bold" );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(tmp_widget), use_bold );

	tmp_widget = lookup_widget( chat_window, "tgl_italics" );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(tmp_widget), use_italics );

	tmp_widget = lookup_widget( chat_window, "tgl_underline" );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(tmp_widget),
		use_underline );

	tmp_widget = lookup_widget( chat_window, "packet_debugging" );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget),
		ymsg_sess->debug_packets );

	ct_set_max_lines( buffer_size );

	if ( indent_wrapped ) {
		ct_set_indent( INDENT_DEFAULT );
	} else {
		ct_set_indent( 0 );
	}

#ifdef USE_GTK2
	ct_set_transparent( transparent_bg );
	ct_set_transparent_shade( shading_r, shading_g, shading_b );
#endif
}


int set_menu_connected( int connected ) {
	GtkWidget *tmp_widget;
	char **on_items;
	char **off_items;
	int i;

	if ( connected ) {
		on_items = conn_menu_items;
		off_items = disconn_menu_items;
	} else {
		off_items = conn_menu_items;
		on_items = disconn_menu_items;
	}

	i = 0;
	while( on_items[i] ) {
		tmp_widget = lookup_widget( chat_window, on_items[i] );
		gtk_widget_set_sensitive( tmp_widget, 1 );
		i++;
	}

	i = 0;
	while( off_items[i] ) {
		tmp_widget = lookup_widget( chat_window, off_items[i] );
		gtk_widget_set_sensitive( tmp_widget, 0 );
		i++;
	}

	return( 0 );
}

static void fill_in_ignore_list(gpointer key, gpointer value,
        gpointer user_data) {
	GtkWidget *tmp_widget = GTK_WIDGET(user_data);
	gchar *listitem[2];

	listitem[0] = key;
	gtk_clist_insert(GTK_CLIST(tmp_widget), 0, listitem );
}

void set_setup_options() {
	GtkWidget *tmp_widget;
	GList *this_regex;
	GList *this_login;
	GList *this_favroom;
	GList *this_friend;
	gchar *listitem[2];
	int row;
	gdouble cur_color[4];

	DBG( 11, "set_setup_options()\n" );

	/* show the correct settings */
	tmp_widget = lookup_widget( setup_window, "auto_login" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), auto_login );

	tmp_widget = lookup_widget( setup_window, "blended_colors" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_blended_colors );

	tmp_widget = lookup_widget( setup_window, "packet_debugging" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), ymsg_sess->debug_packets );

	if ( auto_away ) {
		tmp_widget = lookup_widget( setup_window, "auto_away" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "auto_away_time" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)auto_away );
	}

	tmp_widget = lookup_widget( setup_window, "custom_away_message" );
	if ( custom_away_message )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), custom_away_message );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );

	tmp_widget = lookup_widget( setup_window, "browser_command" );
	if ( browser_command )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), browser_command );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );

	tmp_widget = lookup_widget( setup_window, "filter_command" );
	if ( filter_command )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), filter_command );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );
	

	tmp_widget = lookup_widget( setup_window, "pm_brings_back" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), pm_brings_back );

	tmp_widget = lookup_widget( setup_window, "disp_auto_ignored" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), disp_auto_ignored );

	tmp_widget = lookup_widget( setup_window, "remember_position" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), remember_position );

	tmp_widget = lookup_widget( setup_window, "remember_password" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), remember_password );

	tmp_widget = lookup_widget( setup_window, "auto_raise_pm" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), auto_raise_pm );

	tmp_widget = lookup_widget( setup_window, "highlight_friends" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), highlight_friends );

	tmp_widget = lookup_widget( setup_window, "auto_close_roomlist" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), auto_close_roomlist );

	tmp_widget = lookup_widget( setup_window, "cache_room_list" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), cache_room_list );

	tmp_widget = lookup_widget( setup_window, "chat_timestamp" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), chat_timestamp );

	tmp_widget = lookup_widget( setup_window, "indent_wrapped" );
#ifdef USE_GTK2
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), indent_wrapped );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

	tmp_widget = lookup_widget( setup_window, "chat_timestamp_pm" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), chat_timestamp_pm );

	tmp_widget = lookup_widget( setup_window, "auto_reply_when_away" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), auto_reply_when_away );

	tmp_widget = lookup_widget( setup_window, "auto_reply_msg" );
	if ( auto_reply_msg )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), auto_reply_msg );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );

	if ( limit_lfs ) {
		tmp_widget = lookup_widget( setup_window, "limit_lfs" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "limit_lfs_count" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)limit_lfs );
	}

	tmp_widget = lookup_widget( setup_window, "transparent_bg" );
#ifdef USE_GTK2
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), transparent_bg );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

#ifdef TRANS_BG
	if ( ! transparent_bg ) {
		shading_r = shading_g = shading_b = 0;
	}
#endif

	tmp_widget = lookup_widget( setup_window, "shading_r" );
#ifdef USE_GTK2
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
	            (float)shading_r );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

	tmp_widget = lookup_widget( setup_window, "shading_g" );
#ifdef USE_GTK2
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
	            (float)shading_g );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

	tmp_widget = lookup_widget( setup_window, "shading_b" );
#ifdef USE_GTK2
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
	            (float)shading_b );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

	tmp_widget = lookup_widget( setup_window, "style_bold" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), use_bold );

	tmp_widget = lookup_widget( setup_window, "style_underline" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), use_underline );

	tmp_widget = lookup_widget( setup_window, "style_italic" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), use_italics );

	if ( buffer_size ) {
		tmp_widget = lookup_widget( setup_window, "limit_buffer_size" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "buffer_size" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)buffer_size );
	}

	if ( ping_minutes ) {
		tmp_widget = lookup_widget( setup_window, "use_ping_time" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "ping_minutes" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)ping_minutes );
	}

	if ( history_limit ) {
		tmp_widget = lookup_widget( setup_window, "use_history_limit" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "history_limit" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)history_limit );
	} else {
		tmp_widget = lookup_widget( setup_window, "history_limit" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)20 );
	}

	tmp_widget = lookup_widget( setup_window, "force_lowercase" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), force_lowercase );

	tmp_widget = lookup_widget( setup_window, "suppress_mult" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), suppress_mult );

	tmp_widget = lookup_widget( setup_window, "ignore_guests" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), ignore_guests );

	tmp_widget = lookup_widget( setup_window, "auto_reconnect" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), auto_reconnect );

	tmp_widget = lookup_widget( setup_window, "show_colors" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_colors );

	tmp_widget = lookup_widget( setup_window, "show_fonts" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_fonts );

	tmp_widget = lookup_widget( setup_window, "show_html" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_html );

	tmp_widget = lookup_widget( setup_window, "show_statuses" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_statuses );

	tmp_widget = lookup_widget( setup_window, "show_enters" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_enters );

	tmp_widget = lookup_widget( setup_window, "profile_viewer" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), profile_viewer );

	if ( ignore_on_mults ) {
		tmp_widget = lookup_widget( setup_window, "ignore_on_mults" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "ignore_on_mults_count" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)ignore_on_mults );
	} else {
		tmp_widget = lookup_widget( setup_window, "ignore_on_mults" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 0 );

		tmp_widget = lookup_widget( setup_window, "ignore_on_mults_count" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			0.0 );
	}

	if ( mute_on_mults ) {
		tmp_widget = lookup_widget( setup_window, "mute_on_mults" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 1 );

		tmp_widget = lookup_widget( setup_window, "mute_on_mults_count" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			(float)mute_on_mults );
	} else {
		tmp_widget = lookup_widget( setup_window, "mute_on_mults" );
		gtk_toggle_button_set_active(
			&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), 0 );

		tmp_widget = lookup_widget( setup_window, "mute_on_mults_count" );
		gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
			0.0 );
	}

	tmp_widget = lookup_widget( setup_window, "first_post_is_url" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), first_post_is_url );

	tmp_widget = lookup_widget( setup_window, "first_post_is_pm" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), first_post_is_pm );

	tmp_widget = lookup_widget( setup_window, "url_from_nonroom_user" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), url_from_nonroom_user );

	tmp_widget = lookup_widget( setup_window, "pm_in_sep_windows" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), pm_in_sep_windows );

	tmp_widget = lookup_widget( setup_window, "pm_from_friends" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), pm_from_friends );

	tmp_widget = lookup_widget( setup_window, "pm_from_users" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), pm_from_users );

	tmp_widget = lookup_widget( setup_window, "pm_from_all" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), pm_from_all );

	tmp_widget = lookup_widget( setup_window, "show_adult" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_adult );

	tmp_widget = lookup_widget( setup_window, "show_avatars" );
#ifdef OS_WINDOWS
#	ifdef USE_GTK2
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_avatars );
#	else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#	endif
#else
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_avatars );
#endif

	tmp_widget = lookup_widget( setup_window, "send_avatar" );
	if ( send_avatar )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), send_avatar );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );

	tmp_widget = lookup_widget( setup_window, "show_emoticons" );
#ifdef USE_GTK2
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), show_emoticons );
#else
	gtk_widget_set_sensitive( tmp_widget, 0 );
#endif

	tmp_widget = lookup_widget( setup_window, "use_proxy" );
	gtk_toggle_button_set_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button), use_proxy );

	tmp_widget = lookup_widget( setup_window, "proxy_host" );
	if ( proxy_host )
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), proxy_host );
	else
		gtk_entry_set_text(GTK_ENTRY(tmp_widget), "" );

	tmp_widget = lookup_widget( setup_window, "proxy_port" );
	gtk_spin_button_set_value( GTK_SPIN_BUTTON( tmp_widget ),
		(float)proxy_port );

	cur_color[0] = custom_color_red / 255.0;
	cur_color[1] = custom_color_green / 255.0;
	cur_color[2] = custom_color_blue / 255.0;
	cur_color[3] = 0;
	tmp_widget = lookup_widget( setup_window, "colorselection" );
	gtk_color_selection_set_color( GTK_COLOR_SELECTION(tmp_widget),
		cur_color );

	tmp_widget = lookup_widget( setup_window, "fontselection1" );
#ifdef OS_WINDOWS
	gtk_widget_set_sensitive( tmp_widget, 0 );
#else
	gtk_font_selection_set_font_name(
		GTK_FONT_SELECTION(tmp_widget), font_name );
#endif

	/* setup current color */
	if ( ! use_color )
		use_color = strdup( "black" );

	tmp_widget = lookup_widget( setup_window, "color_black" );
	GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active = 0;

	tmp_widget = lookup_widget( setup_window, "colorselection" );

	gtk_widget_set_sensitive( tmp_widget, 0 );

	tmp_widget = NULL;
	if ( ! strcmp( use_color, "black" )) {
		tmp_widget = lookup_widget( setup_window, "color_black" );
	} else if ( ! strcmp( use_color, "red" )) {
		tmp_widget = lookup_widget( setup_window, "color_red" );
	} else if ( ! strcmp( use_color, "blue" )) {
		tmp_widget = lookup_widget( setup_window, "color_blue" );
	} else if ( ! strcmp( use_color, "green" )) {
		tmp_widget = lookup_widget( setup_window, "color_green" );
	} else if ( ! strcmp( use_color, "yellow" )) {
		tmp_widget = lookup_widget( setup_window, "color_yellow" );
	} else if ( ! strcmp( use_color, "purple" )) {
		tmp_widget = lookup_widget( setup_window, "color_purple" );
	} else if ( ! strcmp( use_color, "cyan" )) {
		tmp_widget = lookup_widget( setup_window, "color_cyan" );
	} else if ( ! strcmp( use_color, "orange" )) {
		tmp_widget = lookup_widget( setup_window, "color_orange" );
	} else if ( ! strcmp( use_color, "gray" )) {
		tmp_widget = lookup_widget( setup_window, "color_gray" );
	} else if ( ! strcmp( use_color, "custom" )) {
		tmp_widget = lookup_widget( setup_window, "colorselection" );
		gtk_widget_set_sensitive( tmp_widget, 1 );
		tmp_widget = lookup_widget( setup_window, "color_custom" );
	} else {
		tmp_widget = lookup_widget( setup_window, "color_black" );
	}
	GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active = 1;

	/* loop through and set lists */
	/* Yahoo! login list */
	tmp_widget = lookup_widget( setup_window, "login_list" );
	gtk_clist_freeze(GTK_CLIST(tmp_widget));
	this_login = login_list;
	while( this_login ) {
		listitem[0] = this_login->data;
		listitem[1] = NULL;
		row = gtk_clist_append(GTK_CLIST(tmp_widget), listitem );
		gtk_clist_set_text(GTK_CLIST(tmp_widget), row, 1, "" );

		this_login = g_list_next( this_login );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));

	/* then the favroom list */
	tmp_widget = lookup_widget( setup_window, "favroom_list" );
	gtk_clist_freeze(GTK_CLIST(tmp_widget));
	this_favroom = favroom_list;
	while( this_favroom ) {
		listitem[0] = this_favroom->data;
		listitem[1] = NULL;
		row = gtk_clist_append(GTK_CLIST(tmp_widget), listitem );
		gtk_clist_set_text(GTK_CLIST(tmp_widget), row, 1, "" );

		this_favroom = g_list_next( this_favroom );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));

	/* then the regex list */
	tmp_widget = lookup_widget( setup_window, "regex_list" );
	gtk_clist_set_sort_column(GTK_CLIST(tmp_widget), 0 );
	gtk_clist_set_auto_sort(GTK_CLIST(tmp_widget), 1 );
	gtk_clist_freeze(GTK_CLIST(tmp_widget));

	this_regex = regex_list;
	while( this_regex ) {
		listitem[0] = this_regex->data;
		listitem[1] = NULL;
		row = gtk_clist_insert(GTK_CLIST(tmp_widget), 0, listitem );
		gtk_clist_set_text(GTK_CLIST(tmp_widget), row, 1, "" );

		this_regex = g_list_next( this_regex );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));

	/* then the ignore list */
	tmp_widget = lookup_widget( setup_window, "ignore_list" );
	gtk_clist_set_sort_column(GTK_CLIST(tmp_widget), 0 );
	gtk_clist_set_auto_sort(GTK_CLIST(tmp_widget), 1 );
	gtk_clist_freeze(GTK_CLIST(tmp_widget));
	if ( ignore_hash ) {
		g_hash_table_foreach( ignore_hash, fill_in_ignore_list, tmp_widget );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));

	/* now the friend list */
	tmp_widget = lookup_widget( setup_window, "friend_list" );
	gtk_clist_set_sort_column(GTK_CLIST(tmp_widget), 0 );
	gtk_clist_set_auto_sort(GTK_CLIST(tmp_widget), 1 );
	gtk_clist_freeze(GTK_CLIST(tmp_widget));

	this_friend = friend_list;
	while( this_friend ) {
		listitem[0] = this_friend->data;
		row = gtk_clist_insert(GTK_CLIST(tmp_widget), 0, listitem );
		this_friend = g_list_next( this_friend );
	}
	gtk_clist_thaw(GTK_CLIST(tmp_widget));
}

void get_setup_options() {
	GtkWidget *tmp_widget;
	char tmp_filename[257];
#ifndef OS_WINDOWS
	char *ptr;
#endif
	gchar *tmp_str;
	int i;
	FILE *fp;
	gdouble cur_color[4];

	DBG( 11, "get_setup_options()\n" );

	/* gather & save the settings */
	tmp_widget = lookup_widget( setup_window, "auto_login" );
	auto_login = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "blended_colors" );
	show_blended_colors = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "packet_debugging" );
	ymsg_sess->debug_packets = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "auto_away" );
	auto_away = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( auto_away ) {
		tmp_widget = lookup_widget( setup_window, "auto_away_time" );
		auto_away = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "custom_away_message" );
	if ( custom_away_message ) {
		free( custom_away_message );
		custom_away_message = NULL;
	}
	custom_away_message = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

	tmp_widget = lookup_widget( setup_window, "browser_command" );
	if ( browser_command ) {
		free( browser_command );
		browser_command = NULL;
	}
	browser_command = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

	if ( filter_command ) {
		free( filter_command );
		filter_command = NULL;
	}

	tmp_widget = lookup_widget( setup_window, "filter_command" );
	filter_command = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
	if ( ! strcmp( filter_command, "" )) {
		free( filter_command );
		filter_command = NULL;
	}
	
	tmp_widget = lookup_widget( setup_window, "pm_brings_back" );
	pm_brings_back = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "disp_auto_ignored" );
	disp_auto_ignored = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "remember_position" );
	remember_position = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "remember_password" );
	remember_password = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "limit_lfs" );
	limit_lfs = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( limit_lfs ) {
		tmp_widget = lookup_widget( setup_window, "limit_lfs_count" );
		limit_lfs = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "transparent_bg" );
#ifdef TRANS_BG
	transparent_bg = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( transparent_bg ) {
		tmp_widget = lookup_widget( setup_window, "shading_r" );
		shading_r = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));

		tmp_widget = lookup_widget( setup_window, "shading_g" );
		shading_g = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));

		tmp_widget = lookup_widget( setup_window, "shading_b" );
		shading_b = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	} else {
		shading_r = shading_g = shading_b = 0;
	}
#endif

	tmp_widget = lookup_widget( setup_window, "auto_raise_pm" );
	auto_raise_pm = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "highlight_friends" );
	highlight_friends = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "auto_close_roomlist" );
	auto_close_roomlist = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "cache_room_list" );
	cache_room_list = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "chat_timestamp" );
	chat_timestamp = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "indent_wrapped" );
	indent_wrapped = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "chat_timestamp_pm" );
	chat_timestamp_pm = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "auto_reply_when_away" );
	auto_reply_when_away = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( auto_reply_msg ) {
		free( auto_reply_msg );
		auto_reply_msg = NULL;
	}

	if ( auto_reply_when_away ) {
		tmp_widget = lookup_widget( setup_window, "auto_reply_msg" );
		auto_reply_msg = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
	}

	tmp_widget = lookup_widget( setup_window, "style_bold" );
	use_bold = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "style_underline" );
	use_underline = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "style_italic" );
	use_italics = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "limit_buffer_size" );
	buffer_size = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( buffer_size ) {
		tmp_widget = lookup_widget( setup_window, "buffer_size" );
		buffer_size = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "use_history_limit" );
	history_limit = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( history_limit ) {
		tmp_widget = lookup_widget( setup_window, "history_limit" );
		history_limit = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "use_ping_time" );
	ping_minutes = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( ping_minutes ) {
		tmp_widget = lookup_widget( setup_window, "ping_minutes" );
		ping_minutes = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "force_lowercase" );
	force_lowercase = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "suppress_mult" );
	suppress_mult = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "ignore_guests" );
	ignore_guests = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "auto_reconnect" );
	auto_reconnect = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_colors" );
	show_colors = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_fonts" );
	show_fonts = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_html" );
	show_html = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_statuses" );
	show_statuses = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_enters" );
	show_enters = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "profile_viewer" );
	profile_viewer = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "ignore_on_mults" );
	ignore_on_mults = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( ignore_on_mults ) {
		tmp_widget = lookup_widget( setup_window, "ignore_on_mults_count" );
		ignore_on_mults = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "mute_on_mults" );
	mute_on_mults = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	if ( mute_on_mults ) {
		tmp_widget = lookup_widget( setup_window, "mute_on_mults_count" );
		mute_on_mults = gtk_spin_button_get_value_as_int(
			GTK_SPIN_BUTTON( tmp_widget ));
	}

	tmp_widget = lookup_widget( setup_window, "first_post_is_url" );
	first_post_is_url = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "first_post_is_pm" );
	first_post_is_pm = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "url_from_nonroom_user" );
	url_from_nonroom_user = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "pm_in_sep_windows" );
	pm_in_sep_windows = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "pm_from_friends" );
	pm_from_friends = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "pm_from_users" );
	pm_from_users = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "pm_from_all" );
	pm_from_all = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_adult" );
	show_adult = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "show_avatars" );
	show_avatars = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "send_avatar" );
	if ( send_avatar ) {
		free( send_avatar );
		send_avatar = NULL;
	}
	send_avatar = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
	if ( ! strlen( send_avatar )) {
		free( send_avatar );
		send_avatar = NULL;
	}

	tmp_widget = lookup_widget( setup_window, "show_emoticons" );
#ifdef USE_GTK2
	show_emoticons = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));
#else
	show_emoticons = 0;
#endif

	tmp_widget = lookup_widget( setup_window, "use_proxy" );
	use_proxy = gtk_toggle_button_get_active(
		&(GTK_CHECK_BUTTON(tmp_widget)->toggle_button));

	tmp_widget = lookup_widget( setup_window, "proxy_host" );
	if ( proxy_host ) {
		free( proxy_host );
		proxy_host = NULL;
	}
	proxy_host = strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

	tmp_widget = lookup_widget( setup_window, "proxy_port" );
	proxy_port = gtk_spin_button_get_value_as_int(
		GTK_SPIN_BUTTON( tmp_widget ));

	tmp_widget = lookup_widget( setup_window, "colorselection" );
	gtk_color_selection_get_color( GTK_COLOR_SELECTION(tmp_widget),
		cur_color );
	custom_color_red = cur_color[0] * 255;
	custom_color_green = cur_color[1] * 255;
	custom_color_blue = cur_color[2] * 255;

#ifndef OS_WINDOWS
	tmp_widget = lookup_widget( setup_window, "fontselection1" );
	free( font_name );
	if ( font_family )
		free( font_family );
	font_family = NULL;
	font_name = strdup( gtk_font_selection_get_font_name(
		GTK_FONT_SELECTION(tmp_widget)));
#ifdef USE_GTK2
	font_family = strdup( font_name );
	ptr = font_family + strlen( font_family ) - 1;
	while( *ptr != ' ' ) {
		ptr--;
	}
	ptr++;
	font_size = atoi( ptr );
	ptr = font_family;
	while(( *ptr ) && ( *ptr != ' ' )) {
		ptr++;
	}
	*ptr = '\0';
	if ( strstr( font_name, "Bold" )) {
		use_bold = 1;
	} else {
		use_bold = 0;
	}

	if ( strstr( font_name, "Italic" )) {
		use_italics = 1;
	} else {
		use_italics = 0;
	}
#else
	/* this code is pitiful.  I'd rewrite it but since Gyach is going to */
	/* Gtk+ v2 then there's no reason unless this stuff breaks. */
	/* example "-*-times-medium-r-normal-*-14-*-*-*-*-*-iso8859-1" */
	font_size = 12;
	ptr = font_name;
	ptr = strchr( ptr, '-' );
	if ( ptr ) {
		ptr++;
		ptr = strchr( ptr, '-' );
		if ( ptr ) {
			ptr++;

			if ( font_family ) {
				free( font_family );
			}
			font_family = strdup( ptr );
			ptr = strchr( font_family, '-' );
			*ptr = '\0';
			ptr++;

			ptr = strchr( ptr, '-' );
			if ( ptr ) {
				ptr++;
				ptr = strchr( ptr, '-' );
				if ( ptr ) {
					ptr++;
					ptr = strchr( ptr, '-' );
					if ( ptr ) {
						ptr++;
						ptr = strchr( ptr, '-' );
						if ( ptr ) {
							ptr++;
							font_size = atoi( ptr );
						}
					}
				}
			}
		}
	}
#endif
#endif

	/* get the user's color */
	free( use_color );
	use_color = NULL;
	if (( tmp_widget = lookup_widget( setup_window, "color_black" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "black" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_red" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "red" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_blue" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "blue" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_green" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "green" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_yellow" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "yellow" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_purple" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "purple" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_cyan" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "cyan" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_orange" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "orange" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_gray" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "gray" );
	} else if (( tmp_widget = lookup_widget( setup_window, "color_custom" )) &&
		( GTK_RADIO_BUTTON(tmp_widget)->check_button.toggle_button.active )) {
		use_color = strdup( "custom" );
	}

	if ( ! use_color )
		use_color = strdup( "black" );

	auto_away_time = time(NULL) + ( auto_away * 60 );

	/* now get and save the friends, regex, and ignore lists */
	tmp_widget = lookup_widget( setup_window, "login_list" );
	/* empty current login list */
	login_list = gyach_g_list_free( login_list );

	/* fetch new login list */
	i = 0;
	while(1) {
		if ( !gtk_clist_get_text(GTK_CLIST(tmp_widget), i, 0, &tmp_str )) {
			break;
		}

		login_list = g_list_append( login_list, strdup( tmp_str ));

		i++;
	}

	tmp_widget = lookup_widget( setup_window, "favroom_list" );
	favroom_list = gyach_g_list_free( favroom_list );

	/* fetch new favroom list */
	i = 0;
	while(1) {
		if ( !gtk_clist_get_text(GTK_CLIST(tmp_widget), i, 0, &tmp_str )) {
			break;
		}

		favroom_list = g_list_append( favroom_list, strdup( tmp_str ));

		i++;
	}


	tmp_widget = lookup_widget( setup_window, "regex_list" );

	snprintf( tmp_filename, sizeof(tmp_filename), "%s/ignore.regex",
		GYACH_CFG_DIR );

	fp = fopen( tmp_filename, "wb" );

	if ( fp ) {
		i = 0;
		while(1) {
			if ( !gtk_clist_get_text(GTK_CLIST(tmp_widget), i, 0, &tmp_str )) {
				break;
			}

			fprintf( fp, "%s\n", tmp_str );

			i++;
		}
		fclose( fp );
	}

	tmp_widget = lookup_widget( setup_window, "ignore_list" );

	snprintf( tmp_filename, sizeof(tmp_filename), "%s/ignore",
		GYACH_CFG_COMMON_DIR );

	fp = fopen( tmp_filename, "wb" );

	if ( fp ) {
		i = 0;
		while(1) {
			if ( !gtk_clist_get_text(GTK_CLIST(tmp_widget), i, 0, &tmp_str )) {
				break;
			}

			fprintf( fp, "%s\n", tmp_str );

			i++;
		}
		fclose( fp );
	}

	/* now load the files we just saved */
	ignore_load();

	/* set the options we just saved */
	set_config();
}

void entry_color( GtkButton *button, gpointer user_data) {
	char *color = user_data;
	const char *text;
	char new_text[2048];

	text = gtk_entry_get_text(GTK_ENTRY(chat_entry));
	snprintf( new_text, sizeof(new_text), "%s<%s>", text, color );
	gtk_entry_set_text(GTK_ENTRY(chat_entry), new_text );
	gtk_entry_set_position( GTK_ENTRY(chat_entry), strlen(new_text));
}

void entry_bold( GtkButton *button, gpointer user_data) {
	const char *text;
	char new_text[2048];

	text = gtk_entry_get_text(GTK_ENTRY(chat_entry));
	my_strncpy( new_text, (char *)text, sizeof(new_text));
	if (( text[0] ) &&
		( text[strlen(text) -1] != ' ' )) {
		my_strncat( new_text, " ", sizeof(new_text));
	}
	my_strncat( new_text, "<b></b>", sizeof(new_text));
	gtk_entry_set_text(GTK_ENTRY(chat_entry), new_text );
	gtk_entry_set_position( GTK_ENTRY(chat_entry), strlen(new_text) - 4 );
}

void entry_italic( GtkButton *button, gpointer user_data) {
	const char *text;
	char new_text[2048];

	text = gtk_entry_get_text(GTK_ENTRY(chat_entry));
	my_strncpy( new_text, (char *)text, sizeof(new_text));
	if (( text[0] ) &&
		( text[strlen(text) -1] != ' ' )) {
		my_strncat( new_text, " ", sizeof(new_text));
	}
	my_strncat( new_text, "<i></i>", sizeof(new_text));
	gtk_entry_set_text(GTK_ENTRY(chat_entry), new_text );
	gtk_entry_set_position( GTK_ENTRY(chat_entry), strlen(new_text) - 4 );
}

#ifdef USE_GTK2
void entry_smiley( GtkButton *button, gpointer user_data) {
	char *smiley = user_data;
	const char *text;
	char new_text[2048];

	text = gtk_entry_get_text(GTK_ENTRY(chat_entry));
	snprintf( new_text, sizeof(new_text), "%s %s ", text, smiley );
	gtk_entry_set_text(GTK_ENTRY(chat_entry), new_text );
	gtk_entry_set_position( GTK_ENTRY(chat_entry), strlen(new_text));
}
#endif

char *colors[] = {
	"black",
	"red",
	"blue",
	"green",
	"purple",
	"pink",
	"cyan",
	"orange",
	"gray",
	NULL
};

GtkWidget *cwin_append_pm_button( GtkWidget *layout, int x, int y, char **pm ) {
	GtkWidget *nbutton;
	GtkWidget *pixmap;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	GtkStyle *style;

	nbutton = gtk_button_new();
	gtk_layout_put( GTK_LAYOUT(layout), nbutton, x, y );
	gtk_widget_realize( nbutton );
	style = gtk_widget_get_style( color_window );
	gdkpixmap = gdk_pixmap_create_from_xpm_d( nbutton->window, &mask,
		&style->bg[GTK_STATE_NORMAL], pm );
	pixmap = gtk_pixmap_new( gdkpixmap, mask );
	gtk_container_add( GTK_CONTAINER( nbutton ), pixmap );
	gtk_widget_show( pixmap );
	gtk_button_set_relief(GTK_BUTTON(nbutton), GTK_RELIEF_NONE);
	gtk_widget_set_usize( nbutton, 25, 25 );
	gtk_widget_show( nbutton );

	return( nbutton );
}

void do_color_window( GtkButton *button, gpointer user_data) {
	static int showing = 0;
	GtkWidget *nbutton;
	GtkWidget *layout;
	char color[20];
	char *color_xpm[25];
	char **pm_color = color_xpm;
	char **cptr = colors;
	int x = 10;
	int y = 10;
	int i;
	int new = 0;
	GdkColormap *colormap;
#ifdef USE_GTK2
	char filename[1024];
	int found;
	GtkWidget *pixmap;
	struct stat sbuf;
	GdkPixbuf *pixbuf;
	GdkPixbuf *spixbuf;
	int height;
	int width;
	GdkPixmap *st_pixmap;
	GdkBitmap *st_mask;
	SMILEY *sm_ptr;
	char sm_file[128] = "";
	char sm_text[10] = ":)";
#endif

	colormap = gdk_colormap_get_system();

	if ( ! color_window ) {
		color_window = create_colors_window();
		showing = 0;
		new = 1;

		gtk_widget_set_colormap( color_window, colormap );
	}
		
	if ( showing ) {
		gtk_widget_hide( color_window );
		showing = 0;
	} else {
		gtk_widget_show( color_window );
		showing = 1;
	}

	if ( new ) {
		layout = lookup_widget( color_window, "button_layout" );

		/* create the buttons here */
		color_xpm[0] = strdup( "21 21 1 1" );
		color_xpm[1] = color;
		for( i = 0; i < 21 ; i++ ) {
			color_xpm[i+2] = strdup( "xxxxxxxxxxxxxxxxxxxxx" );
		}

		while( *cptr ) {
			snprintf( color, sizeof(color), "x	c %s", *cptr );
			nbutton = cwin_append_pm_button( layout, x, y, pm_color );

			gtk_signal_connect (GTK_OBJECT (nbutton), "clicked",
				GTK_SIGNAL_FUNC (entry_color), *cptr );

			x += 25;
			cptr++;
		}

		/* do bold, italic, etc. buttons */
		nbutton = cwin_append_pm_button( layout, x, y, pixmap_bold );
		gtk_signal_connect (GTK_OBJECT (nbutton), "clicked",
			GTK_SIGNAL_FUNC (entry_bold), NULL );
		x += 25;
		nbutton = cwin_append_pm_button( layout, x, y, pixmap_italic );
		gtk_signal_connect (GTK_OBJECT (nbutton), "clicked",
			GTK_SIGNAL_FUNC (entry_italic), NULL );
		x += 25;


#ifdef USE_GTK2
		gtk_window_set_title( GTK_WINDOW(color_window), "Colors & Emoticons" );

		/* loop through smiley dir */
		x = 10;
		y = 35;

		for( i = 1; i < 100; i++ ) {
			snprintf( filename, sizeof(filename), "%s/smileys/%02d.png",
				GYACH_CFG_DIR, i );
			found = 0;
			if ( ! stat( filename, &sbuf )) {
				found = 1;
			} else {
				snprintf( filename, sizeof(filename),
					PACKAGE_DATA_DIR "/smileys/%02d.png", i );
				if ( ! stat( filename, &sbuf )) {
					found = 1;
				}
			}

			if ( found ) {
				found = 0;
				sm_ptr = &smileys[0];
				while( sm_ptr->sm_text ) {
					snprintf( sm_file, sizeof(sm_file), "%02d.png", i );
					if ( ! strcmp( sm_file, sm_ptr->sm_file )) {
						found = 1;
						my_strncpy( sm_text, sm_ptr->sm_text, sizeof(sm_text));
						break;
					}
					sm_ptr++;
				}
			}

			if ( found ) {
				nbutton = gtk_button_new();
				gtk_layout_put( GTK_LAYOUT(layout), nbutton, x, y );
				gtk_widget_realize( nbutton );

				colormap = gtk_widget_get_colormap( nbutton );

				pixbuf = gdk_pixbuf_new_from_file( filename, NULL );

				width = gdk_pixbuf_get_width( pixbuf );
				height = gdk_pixbuf_get_height( pixbuf );

				if (( width > 25 ) || ( height > 25 )) {
					if ( width < height ) {
						width = ( 1.0 * width / height ) * 25;
						height = 25;
					} else {
						height = ( 1.0 * height / width ) * 25;
						width = 25;
					}
				}
				spixbuf = gdk_pixbuf_scale_simple( pixbuf, width, height,
					GDK_INTERP_BILINEAR );

				gdk_pixbuf_render_pixmap_and_mask_for_colormap( spixbuf,
					colormap, &st_pixmap, &st_mask, gdk_pixbuf_get_has_alpha( pixbuf ) );
				pixmap = gtk_pixmap_new( st_pixmap, st_mask );

				gtk_container_add( GTK_CONTAINER( nbutton ), pixmap );
				gtk_widget_set_usize( nbutton, 25, 25 );
				gtk_button_set_relief(GTK_BUTTON(nbutton), GTK_RELIEF_NONE);
				gtk_signal_connect (GTK_OBJECT (nbutton), "clicked",
					GTK_SIGNAL_FUNC (entry_smiley), strdup( sm_text ));
				gtk_widget_show( pixmap );
				gtk_widget_show( nbutton );

				x += 25;

				if ( x > 260 ) {
					x = 10;
					y += 25;
				}

				gdk_pixbuf_unref( pixbuf );
				gdk_pixmap_unref( st_pixmap );
				if ( st_mask )
					gdk_bitmap_unref( st_mask );
			}
		}

		gtk_layout_set_size(GTK_LAYOUT(layout), 250, y + 30 );
#endif
	}
}

