/*****************************************************************************
 * gyach_int_text.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#ifdef GYACH_INT_TEXT

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#ifdef USE_GDK_PIXBUF
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#ifdef USE_PTHREAD_CREATE
#include <pthread.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "gyach.h"
#include "gyach_int.h"

#ifdef USE_GTK2
GtkTextView *chat_text;
GtkTextBuffer *text_buffer;
GtkTextMark *end_mark;
char chat_font[128] = "fixed 10";
GtkWidget *top_text;
GtkWidget *vpaned;
char *underlined = NULL;
int trans_bg = 0;
int trans_shade_r = 128;
int trans_shade_g = 128;
int trans_shade_b = 128;
#else
GtkText *chat_text;
GdkFont *chat_font = NULL;
#endif
GdkColor chat_color;
int max_lines = 0;

/* support functiond decls */
gboolean on_chat_text_clicked (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
#ifdef TRANS_BG
gboolean update_transparent_background (GtkWidget *widget, GdkEventExpose *event, gpointer user_data);
gboolean redraw_notify_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
#endif

/* standard gyach interface function decls */
int ct_build() {
	GtkWidget *hbox;
#ifdef USE_GTK2
	GtkTextIter end;
	GtkWidget *sw;
	GtkWidget *frame;
#else
	GtkWidget *vscrollbar;
#endif

	hbox = lookup_widget( chat_window, "hbox2" );

#ifdef USE_GTK2
	chat_text = GTK_TEXT_VIEW(gtk_text_view_new());
	text_buffer = gtk_text_view_get_buffer( chat_text );
#else
	chat_text = GTK_TEXT(gtk_text_new( NULL, NULL ));
#endif
	gtk_widget_ref( GTK_WIDGET(chat_text) );
	gtk_object_set_data_full( GTK_OBJECT(hbox), "chat_text",
		chat_text, (GtkDestroyNotify)gtk_widget_unref );

#ifdef USE_GTK2
	vpaned = gtk_vpaned_new();
	gtk_container_set_border_width( GTK_CONTAINER(vpaned), 0 );
	gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET(vpaned), TRUE, TRUE, 0);
	top_text = gtk_text_view_new_with_buffer( text_buffer );

	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN );
	gtk_paned_add1( GTK_PANED (vpaned), frame );
	gtk_container_add (GTK_CONTAINER (frame), sw );
	gtk_container_add( GTK_CONTAINER (sw), top_text );

	gtk_paned_set_position( GTK_PANED( vpaned ), 0 );

	sw = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN );
	gtk_paned_add2( GTK_PANED (vpaned), frame );
	gtk_container_add (GTK_CONTAINER (frame), sw );
	gtk_container_add( GTK_CONTAINER (sw), GTK_WIDGET( chat_text ));

	gtk_text_view_set_wrap_mode( GTK_TEXT_VIEW( top_text ), GTK_WRAP_WORD );

	gtk_widget_show_all( vpaned );

	gtk_signal_connect (GTK_OBJECT (top_text), "button_press_event",
		GTK_SIGNAL_FUNC (on_chat_text_clicked), NULL);

	gtk_signal_connect_after (GTK_OBJECT (top_text), "motion_notify_event",
		GTK_SIGNAL_FUNC (chat_motion_notify), NULL);

	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(top_text), GTK_CAN_FOCUS);

	gtk_widget_set_events( GTK_WIDGET(top_text),
		GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK );
#else
	gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET(chat_text), TRUE, TRUE, 0);
#endif

	gtk_widget_set_usize( GTK_WIDGET(chat_text), 480, -2);
	gtk_widget_show( GTK_WIDGET(chat_text) );

	gtk_signal_connect (GTK_OBJECT (chat_text), "button_press_event",
		GTK_SIGNAL_FUNC (on_chat_text_clicked), NULL);

	gtk_signal_connect_after (GTK_OBJECT (chat_text), "motion_notify_event",
		GTK_SIGNAL_FUNC (chat_motion_notify), NULL);

	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(chat_text), GTK_CAN_FOCUS);

	gtk_widget_set_events( GTK_WIDGET(chat_text),
		GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK 
#ifdef TRANS_BG
		| GDK_EXPOSURE_MASK
#endif
		);

#ifdef USE_GTK2
#	ifdef TRANS_BG
	gtk_signal_connect_after (GTK_OBJECT (chat_text), "expose_event",
		GTK_SIGNAL_FUNC (update_transparent_background), NULL );
	gtk_signal_connect_after (GTK_OBJECT (chat_text), "configure_event",
		GTK_SIGNAL_FUNC (redraw_notify_event), NULL );
	gtk_signal_connect(GTK_OBJECT(chat_text->vadjustment), "value_changed",
		GTK_SIGNAL_FUNC (redraw_notify_event), NULL);
#	endif
#else
	vscrollbar = gtk_vscrollbar_new( chat_text->vadj );

	gtk_box_pack_start (GTK_BOX (hbox), vscrollbar, FALSE, FALSE, 1);
	gtk_widget_show( vscrollbar );
#endif

#ifdef USE_GTK2
	gtk_text_view_set_wrap_mode( chat_text, GTK_WRAP_WORD );

	ct_set_font( "fixed 10" );

	gtk_text_buffer_create_tag( text_buffer, "underlined", "underline",
		PANGO_UNDERLINE_SINGLE, NULL);

	gtk_text_buffer_create_tag( text_buffer, "not_editable",
		"editable", FALSE, NULL);
#else
	chat_font = gdk_font_load( "fixed" );

	gtk_text_set_word_wrap( chat_text, 1 );
	gtk_text_set_line_wrap( chat_text, 1 );
#endif

	ct_set_color( 0, 0, 0 );

#ifdef USE_GTK2
	gtk_text_buffer_get_end_iter( text_buffer, &end );
	end_mark = gtk_text_buffer_create_mark( text_buffer, "end_mark", &end, 0 );
#endif

	return( 0 );
}

GtkWidget *ct_widget() {
	return( GTK_WIDGET(chat_text));
}

int ct_scroll_at_bottom() {
	GtkAdjustment *adj;

#ifdef USE_GTK2
	/* if we are split and they have adjusted the split then always scroll */
	/* the bottom window to the bottom */
	if ( gtk_paned_get_position( GTK_PANED( vpaned ))) {
		return( 1 );
	}

	adj = chat_text->vadjustment;
#else
	adj = chat_text->vadj;
#endif

	if ( adj->value == ( adj->upper - adj->lower - adj->page_size ))
		return( 1 );
	else
		return( 0 );
}

int ct_scroll_to_bottom() {
#ifdef USE_GTK2
	GtkTextIter iter;

	gtk_text_view_scroll_to_mark( chat_text, end_mark, 0, FALSE, 0, 0 );
	gtk_text_buffer_get_iter_at_mark( text_buffer, &iter, end_mark );
	gtk_text_buffer_place_cursor( text_buffer, &iter );
#else
	GtkAdjustment *adj;

	adj = chat_text->vadj;
	gtk_adjustment_set_value( adj,
		adj->upper - adj->lower - adj->page_size );
#endif

	return( 0 );
}

int remove_extra_lines() {
	int text_length;
#ifdef USE_GTK2
	GtkTextIter start;
	GtkTextIter end;

	text_length = gtk_text_buffer_get_char_count( text_buffer );
#else
	text_length = gtk_text_get_length( chat_text );
#endif

	if ( max_lines ) {
		ct_freeze();
		if ( text_length > ( max_lines * 1024 )) {
#ifdef USE_GTK2
			gtk_text_buffer_get_iter_at_offset( text_buffer, &start, 0 );
			gtk_text_buffer_get_iter_at_offset( text_buffer, &end, 511 );
			gtk_text_buffer_delete( text_buffer, &start, &end );
#else
			gtk_text_set_point( chat_text, 0 );
			gtk_text_forward_delete( chat_text, 512 );

			text_length = gtk_text_get_length( chat_text );
			gtk_text_set_point( chat_text, text_length );
#endif
		}
		ct_thaw();
	}

	return( 0 );
}

#ifdef TRANS_BG
/**************************************************************************/
/* from xchat */

#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

static GdkPixmap *
shade_pixmap_gdk (GtkTextView *text, Pixmap p, int x, int y, int w, int h)
{
	GdkPixmap *pp, *tmp, *shaded_pixmap;
	GdkPixbuf *pixbuf;
	GdkColormap *cmap;
	GdkGC *tgc;
	unsigned char *buf;
	unsigned char *pbuf;
	int width, height, depth;
	int rowstride;
	int pbwidth;
	int pbheight;
	int i, j;
	int offset;
	int r, g, b, a;

	pp = gdk_pixmap_foreign_new (p);
	gdk_drawable_get_size (pp, &width, &height);
	cmap = gtk_widget_get_colormap (GTK_WIDGET (text));
	depth = gdk_drawable_get_depth (pp);

	if (width < x + w || height < y + h || x < 0 || y < 0)
	{
		tgc = gdk_gc_new (pp);
		tmp = gdk_pixmap_new (pp, w, h, depth);
		gdk_gc_set_tile (tgc, pp);
		gdk_gc_set_fill (tgc, GDK_TILED);
		gdk_gc_set_ts_origin (tgc, -x, -y);
		gdk_draw_rectangle (tmp, tgc, TRUE, 0, 0, w, h);
		gdk_gc_destroy (tgc);

		pixbuf = gdk_pixbuf_get_from_drawable (NULL, tmp, cmap,
															0, 0, 0, 0, w, h);
		gdk_pixmap_unref (tmp);
	} else
	{
		pixbuf = gdk_pixbuf_get_from_drawable (NULL, pp, cmap,
															x, y, 0, 0, w, h);
	}
	g_free (pp);

	if (!pixbuf)
		return NULL;

	buf = gdk_pixbuf_get_pixels (pixbuf);
	rowstride = gdk_pixbuf_get_rowstride (pixbuf);
	pbwidth = gdk_pixbuf_get_width (pixbuf);
	pbheight = gdk_pixbuf_get_height (pixbuf);

	a = 128;	/* alpha */
	r = trans_shade_r;
	g = trans_shade_g;
	b = trans_shade_b;

	if (gdk_pixbuf_get_has_alpha (pixbuf))
		offset = 4;
	else
		offset = 3;

	for (i=0;i<pbheight;i++)
	{
		pbuf = buf;
		for (j=0;j<pbwidth;j++)
		{
			pbuf[0] = ((pbuf[0] * r) >> 8);
			pbuf[1] = ((pbuf[1] * g) >> 8);
			pbuf[2] = ((pbuf[2] * b) >> 8);
			pbuf+=offset;
		}
		buf+=rowstride;
	}

	/* reuse the same pixmap to save a few cycles */
#ifdef RECYCLE
	if (xtext->recycle)
	{
		shaded_pixmap = xtext->pixmap;
		gdk_pixbuf_render_to_drawable (pixbuf, shaded_pixmap, xtext->fgc, 0, 0,
												 0, 0, w, h, GDK_RGB_DITHER_NORMAL, 0, 0);
	} else
#endif
	{
		gdk_pixbuf_render_pixmap_and_mask (pixbuf, &shaded_pixmap, NULL, 0);
	}
	gdk_pixbuf_unref (pixbuf);

	return shaded_pixmap;
}

static Window desktop_window = None;

/* stolen from zvt, which was stolen from Eterm */
static Pixmap get_pixmap_prop ()
{
	Atom type;
	int format;
	unsigned long length, after;
	unsigned char *data;
	Pixmap pix = None;
	static Atom prop = None;

	desktop_window = GDK_ROOT_WINDOW ();

	if (prop == None)
		prop = XInternAtom (GDK_DISPLAY (), "_XROOTPMAP_ID", True);
	if (prop == None)
		return None;

	XGetWindowProperty (GDK_DISPLAY (), desktop_window, prop, 0L, 1L, False,
							  AnyPropertyType, &type, &format, &length, &after,
							  &data);
	if (data)
	{
		if (type == XA_PIXMAP)
			pix = *((Pixmap *) data);

		XFree (data);
	}

	return pix;
}

/**************************************************************************/


gboolean redraw_notify_event (GtkWidget *widget,
		GdkEvent *event, gpointer user_data) {
	if ( trans_bg )
		update_transparent_background( NULL, NULL, "update" );
	return( FALSE );
}

static GdkPixmap *st_pixmap = NULL;
static GdkPixmap *st_pixmap_top = NULL;

gboolean update_transparent_background (GtkWidget *widget,
		GdkEventExpose *event, gpointer user_data) {
	GdkWindow *gwin;
	GdkWindow *gwin_top;
	Pixmap rootpix;
	int x, y;
	static int orig_x = -1;
	static int orig_y = -1;
	static int orig_w = -1;
	static int orig_h = -1;
	int width, height;
	int redraw = 0;
	int tx, ty, twidth, theight;
	static int orig_pane_pos = -1;
	int pane_pos;

	if ( ! trans_bg )
		return( FALSE );

	gwin = gtk_text_view_get_window( chat_text, GTK_TEXT_WINDOW_TEXT );
	gdk_window_get_deskrelative_origin( gwin, &x, &y);
	gdk_window_get_size( gwin, &width, &height);
	gwin_top = gtk_text_view_get_window( GTK_TEXT_VIEW(top_text), GTK_TEXT_WINDOW_TEXT );

	pane_pos = gtk_paned_get_position( GTK_PANED( vpaned ));

	if (( x != orig_x ) ||
		( y != orig_y ) ||
		( width != orig_w ) ||
		( height != orig_h ) ||
		( pane_pos != orig_pane_pos ) ||
		( ! st_pixmap ) ||
		( user_data )) {
		rootpix = get_pixmap_prop();
		if ( st_pixmap )
			gdk_pixmap_unref( st_pixmap );
		st_pixmap = shade_pixmap_gdk( chat_text, rootpix, x, y, width, height);
		redraw = 1;

		if ( pane_pos ) {
			gdk_window_get_deskrelative_origin( gwin_top, &tx, &ty);
			gdk_window_get_size( gwin_top, &twidth, &theight);
			if ( st_pixmap_top )
				gdk_pixmap_unref( st_pixmap_top );
			st_pixmap_top = shade_pixmap_gdk( GTK_TEXT_VIEW(top_text), rootpix,
				tx, ty, twidth, theight);
		}
	}

	if (( x != orig_x ) ||
		( y != orig_y ) ||
		( width != orig_w ) ||
		( height != orig_h ) ||
		( pane_pos != orig_pane_pos ) ||
		( user_data )) {
		if ( pane_pos ) {
			gdk_window_set_back_pixmap( gwin_top, st_pixmap_top, FALSE );
			gtk_widget_queue_draw( top_text );
		}

		gdk_window_set_back_pixmap( gwin, st_pixmap, FALSE );
		if (( event ) &&
			( ! redraw )) {
			gtk_widget_queue_draw_area( GTK_WIDGET(chat_text),
				event->area.x, event->area.y,
				event->area.width, event->area.height );
		} else {
			gtk_widget_queue_draw( GTK_WIDGET(chat_text));
		}
	}

	orig_x = x;
	orig_y = y;
	orig_w = width;
	orig_h = height;
	orig_pane_pos = pane_pos;

	return( FALSE );
}
#endif /* TRANS_BG */

int ct_append( char *str, int len ) {
#ifdef USE_GTK2
	char tmp[32];
	GtkTextIter iter;

	if (( ! len ) ||
		( ! str )) {
		return( 0 );
	}

	sprintf( tmp, "fg_%05d%05d%05d",
		chat_color.red, chat_color.green, chat_color.blue );
	gtk_text_buffer_get_end_iter( text_buffer, &iter );

/* this is firing off for degree signs and some foreign chars that should be ok
   so it's commented out for now.
	if ( ! g_utf8_validate( str, len, NULL )) {
		strcpy( tmp, "((g_utf8_validate failed))" );
		if ( str[len-1] == '\n' ) {
			strcat( tmp, "\n" );
		}
		gtk_text_buffer_insert( text_buffer, &iter, tmp, strlen( tmp ));
		return( 0 );
	}
*/

	/* NOTE: "underlined" must be last in this because it is sometimes set */
	/*       to NULL */
	gtk_text_buffer_insert_with_tags_by_name( text_buffer, &iter, str, len,
		tmp, chat_font, "not_editable", underlined, NULL );

	if ( underlined ) {
		free( underlined );
		underlined = NULL;
	}

#ifdef TRANS_BG
	if ( trans_bg )
		update_transparent_background( NULL, NULL, "update" );
#endif

#else
	int text_length;

	text_length = gtk_text_get_length( chat_text );

	gtk_text_set_point( chat_text, text_length );
	gtk_text_insert( chat_text, chat_font, &chat_color,
		NULL, (gchar *)str, len );
#endif

	remove_extra_lines();

	return( 0 );
}

int ct_append_fixed( char *str, int len ) {
#ifdef USE_GTK2
	char orig_font[128];
	char fixed_font[128];
	int pitch;
	char *ptr;

	ptr = chat_font + strlen( chat_font ) - 1;
	while(( ptr > chat_font ) && ( *ptr != ' ' )) {
		ptr--;
	}
	ptr++;
	pitch = atoi( ptr );

	strcpy( orig_font, chat_font );
	sprintf( fixed_font, "fixed %d", pitch );
	ct_set_font( fixed_font );
	ct_append( str, len );
	ct_set_font( orig_font );
#else
	GdkFont *orig_font_p;

	orig_font_p = chat_font;
	chat_font = gdk_font_load( "fixed" );
	ct_append( str, len );
	gdk_font_unref( chat_font );
	chat_font = orig_font_p;
#endif
	return( 0 );
}

int ct_freeze() {
#ifdef USE_GTK2
	/*
	GdkWindow *gwin;
	gwin = gtk_text_view_get_window( chat_text, GTK_TEXT_WINDOW_TEXT );
	gdk_window_freeze_updates( gwin );
	*/
#else
	gtk_text_freeze( chat_text );
#endif

	return( 0 );
}

int ct_thaw() {
#ifdef USE_GTK2
	/*
	GdkWindow *gwin;
	gwin = gtk_text_view_get_window( chat_text, GTK_TEXT_WINDOW_TEXT );
	gdk_window_thaw_updates( gwin );
	*/
#else
	gtk_text_thaw( chat_text );
#endif

	return( 0 );
}

int ct_clear() {
#ifdef USE_GTK2
	GtkTextIter start;
	GtkTextIter end;
#else
	GtkEditable *text_editable;
#endif
	int text_length;

	ct_freeze();
#ifdef USE_GTK2
	text_length = gtk_text_buffer_get_char_count( text_buffer );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &start, 0 );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &end, text_length );
	gtk_text_buffer_delete( text_buffer, &start, &end );

	gtk_text_buffer_get_end_iter( text_buffer, &end );
	end_mark = gtk_text_buffer_create_mark( text_buffer, "end_mark", &end, 0 );
#else
	text_length = gtk_text_get_length( chat_text );
	text_editable = &(chat_text->editable);
	gtk_editable_delete_text( GTK_EDITABLE(text_editable), 0,
		text_length );
#endif
	ct_thaw();

	return( 0 );
}

GdkColor *ct_get_color() {
	return( &chat_color );
}

#ifdef USE_GTK2
char *ct_get_font() {
#else
GdkFont *ct_get_font() {
#endif
	return( chat_font );
}

int ct_set_color( int r, int g, int b ) {
#ifdef USE_GTK2
	char tmp[32];
	GtkTextTagTable *tag_table;
#endif

#ifdef TRANS_BG
	if (( trans_bg ) &&
		( r == 0 ) &&
		( g == 0 ) &&
		( b == 0 )) {
		r = g = b = 255;
	} else
#endif
	/* if person sends white, change to black since background is white */
	if (( r == 0xff ) &&
		( g == 0xff ) &&
		( b == 0xff )) {
		r = g = b = 0xa0;
	}

	chat_color.red   = r * ( 65535 / 255 );
	chat_color.green = g * ( 65535 / 255 );
	chat_color.blue  = b * ( 65535 / 255 );

#ifdef USE_GTK2
	sprintf( tmp, "fg_%05d%05d%05d",
		chat_color.red, chat_color.green, chat_color.blue );

	tag_table = gtk_text_buffer_get_tag_table( text_buffer );
	if ( ! gtk_text_tag_table_lookup( tag_table, tmp )) {
		gtk_text_buffer_create_tag( text_buffer, tmp, "foreground-gdk",
			&chat_color, NULL);
	}
#else
	gdk_colormap_alloc_color( gtk_widget_get_colormap(GTK_WIDGET(chat_text)),
	        &chat_color, FALSE, TRUE);
#endif

	return( 0 );
}

#ifdef USE_GTK2
void ct_set_underline( int on ) {
	if ( on ) {
		if ( ! underlined ) {
			underlined = strdup( "underlined" );
		}
	} else {
		if ( underlined ) {
			free( underlined );
			underlined = NULL;
		}
	}
}

int ct_set_font( char *new_font ) {
	GtkTextTagTable *tag_table;

	strcpy( chat_font, new_font );

	tag_table = gtk_text_buffer_get_tag_table( text_buffer );
	if ( ! gtk_text_tag_table_lookup( tag_table, chat_font )) {
		gtk_text_buffer_create_tag( text_buffer, chat_font, "font",
			new_font, NULL);
	}
	return( 0 );
}
#else
int ct_set_font( GdkFont *new_font ) {
	chat_font = new_font;

	return( 0 );
}
#endif

int ct_set_max_lines( int lines ) {
	if ( lines >= 0 )
		max_lines = lines;
	else
		max_lines = 0;

	return( 0 );
}

int ct_capture_to_file( char *filename ) {
	FILE *fp;
	int  length;
	time_t time_now;
#ifdef USE_GTK2
	GtkTextIter start;
	GtkTextIter end;
	gchar *ptr;
#else
	int  i;
	gchar ch;
#endif

	fp = fopen( filename, "ab" );

	if ( ! fp )
		return( 0 );

#ifdef USE_GTK2
	length = gtk_text_buffer_get_char_count( text_buffer );
#else
	length = gtk_text_get_length( chat_text );
#endif

	time_now = time(NULL);

	fprintf( fp, "Captured at: %s", ctime(&time_now) );
	fprintf( fp, "-------------------------------------\n" );

#ifdef USE_GTK2
	gtk_text_buffer_get_iter_at_offset( text_buffer, &start, 0 );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &end, length );
	ptr = gtk_text_buffer_get_text( text_buffer, &start, &end, 0 );
	fwrite( ptr, 1, strlen( ptr ), fp );
	g_free( ptr );
#else
	for( i = 0; i < length; i++ ) {
		ch = GTK_TEXT_INDEX( chat_text, i );
		fwrite( &ch, 1, 1, fp );
	}
#endif

	fprintf( fp, "\n" );
	fclose( fp );

	return( 0 );
}

int ct_can_do_pixmaps( void ) {
#ifdef USE_GTK2
	return( 1 );
#else
	return( 0 );
#endif
}

int ct_append_pixmap( char *filename ) {
#ifdef USE_GTK2
	GdkPixbuf *pixbuf;
	GdkPixbuf *spixbuf;
	int	width;
	int height;
	int text_length;
	GtkTextIter iter;

	text_length = gtk_text_buffer_get_char_count( text_buffer );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &iter, text_length );

	pixbuf = gdk_pixbuf_new_from_file( filename, NULL );

	width = gdk_pixbuf_get_width( pixbuf );
	height = gdk_pixbuf_get_height( pixbuf );

/* should we scale or not???
	if ( width < height ) {
		width = ( 1.0 * width / height ) * 200;
		height = 200;
	} else {
		height = ( 1.0 * height / width ) * 200;
		width = 200;
	}
*/
	spixbuf = gdk_pixbuf_scale_simple( pixbuf, width, height,
		GDK_INTERP_BILINEAR );

	gtk_text_buffer_insert_pixbuf( text_buffer, &iter, spixbuf );

	gdk_pixbuf_unref( spixbuf );
	gdk_pixbuf_unref( pixbuf );
	
#ifdef TRANS_BG
	if ( trans_bg )
		update_transparent_background( NULL, NULL, "update" );
#endif

#endif
	return( 0 );
}

gboolean
on_chat_text_clicked                   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
#ifdef USE_GTK2
	int x, y;
	gint buf_x, buf_y;
#endif
	gchar *ptr;

	if (event->button == 1 && event->type == GDK_BUTTON_PRESS) {
#ifdef USE_GTK2
		x = event->x;
		y = event->y;

		gtk_text_view_window_to_buffer_coords( GTK_TEXT_VIEW(widget),
			GTK_TEXT_WINDOW_TEXT, x, y, &buf_x, &buf_y );
		ptr = get_word_at_pos( GTK_TEXT_VIEW(widget), buf_x, buf_y );
#else
		ptr = get_word_at_cursor( GTK_TEXT(widget));
#endif
		if ( check_clicked_text( ptr )) {
			return( TRUE );
		}
	}

	return FALSE;
}

void ct_set_indent( int indent_value ) {
	/* negative number indents successive lines, positive indents the first */
#ifdef USE_GTK2
	gtk_text_view_set_indent( GTK_TEXT_VIEW(top_text), 0 - indent_value );
	gtk_text_view_set_indent( chat_text, 0 - indent_value );
#endif
}

#ifdef TRANS_BG
void ct_set_transparent( int trans ) {
	char buf[512];

	if (( trans_bg ) &&
		( ! trans )) {
		/* reset background to blank white for now */
		ct_set_color( 255, 255, 255 );
		strcpy( buf,
			"************************************************************\n"
			"************************************************************\n"
			"************************************************************\n"
			"Transparency support is experimental in this version of "
			"Gyach.  To fully turn off transparency, you must exit and "
			"restart Gyach!\n" 
			"************************************************************\n"
			"************************************************************\n"
			"************************************************************\n"
			);
		ct_append( buf, strlen( buf ));
		ct_scroll_to_bottom();
	}

	trans_bg = trans;
	if ( trans_bg ) {
		ct_update_bg();
	}
}

void ct_set_transparent_shade( int r, int g, int b ) {
	trans_shade_r = r + 128;
	trans_shade_g = g + 128;
	trans_shade_b = b + 128;

	if ( trans_bg ) {
		gdk_pixmap_unref( st_pixmap );
		st_pixmap = NULL;
		ct_update_bg();
	}
}

void ct_update_bg() {
	if ( trans_bg )
		update_transparent_background( NULL, NULL, "update" );
}
#endif

#endif  /* GYACH_INT_TEXT */
