/*****************************************************************************
 * gyach.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/

#include "config.h"

#include "gyach.h"
#include "main.h"
#include "roomlist.h"
#include "support.h"
#include "util.h"

GtkWidget * room_window = NULL;

int  auto_close_roomlist = 1;
int  cache_room_list = 1;
int  show_adult = 0;

char *room_selected = NULL;


/* this is the third rewrite of this function and populate_room_list(). */
/* the latest incarnation uses some new urls I found while searching    */
/* the net last night.  the catfeed.html and feed.html are not really   */
/* html files, they are tab-delimited datafiles which are easily        */
/* parsed and quick to download.  the feed.html file contains the list  */
/* of all subrooms off a room as well as the count of users and voice   */
/* users in the room.                                                   */
void populate_child_room_list( char *number, GtkCTree *room_tree,
	GtkCTreeNode *parent_node )
{
	GtkLabel *room_label;
	GtkCTreeNode *child_node;
	GtkCTreeNode *tmp_parent;
	ROOM_ENTRY *room_item;
	char name_c[129] = "User Rooms";
	char tmp[129];
	char *data[1] = {name_c};
	char catlist[128] = "http://chat.yahoo.com/c/roomlist/feed.html?.rmcat=";
	char buf[65536];
	char *name_ptr;
	char *number_ptr;
	char *dummy_ptr;
	char *stats_ptr;
	char *ptr;
	char *tab;
	char *end;
	char *sptr;
	char *comma;
	int subrooms;
	int subroom;
	int tot_chatters;
	int tot_voice;
	int chatters[100];
	int voice[100];
	int url_length;
	int in_user_rooms = 0;

	DBG( 11, "populate_child_room_list()\n" );

	room_label = GTK_LABEL( lookup_widget( GTK_WIDGET(room_tree), 
					       "loading_status" ));

	/* find out if we are in user rooms already and if so, don't list again */
	room_item = gtk_ctree_node_get_row_data( room_tree, parent_node );

	my_strncat( catlist, number, sizeof(catlist));
	url_length = fetch_url( catlist, buf, ymsg_sess->cookie );

	process_gtk_events();

	gtk_clist_freeze( GTK_CLIST(room_tree) );

	ptr = buf;
	while( *ptr ) {
		end = strchr( ptr, '\n' );
		if ( end ) {
			*end = '\0';	
		}
		if ( ! strcmp( ptr, "PUBLIC_ROOMS" )) {
			ptr = end + 1;
			continue;
		}

		if ( ! strcmp( ptr, "PRIVATE_ROOMS" )) {
			/* do user rooms, add a subtree for them */
			strcpy( name_c, "User Rooms" );
			room_item = (ROOM_ENTRY *)malloc( sizeof( ROOM_ENTRY ));
			room_item->room_name = strdup( name_c );
			room_item->room_id = strdup( number );
			room_item->populated = 1;
			room_item->temp_child = NULL;

			parent_node = gtk_ctree_insert_node( room_tree, parent_node,
								NULL, data, 5, NULL, NULL, 
								NULL, NULL,
								FALSE, FALSE);

			gtk_ctree_node_set_selectable( room_tree, parent_node, 0 );
			gtk_ctree_node_set_row_data( room_tree, parent_node, room_item );

			in_user_rooms = 1;

			ptr = end + 1;
			continue;
		}

		/* grab the 3 fields */
		number_ptr = ptr;
		tab = strchr( number_ptr, '	' );	/* a tab character */
		*tab = '\0';

		name_ptr = tab + 1;
		tab = strchr( name_ptr, '	' );	/* a tab character */
		*tab = '\0';

		/* a blank field between 2 tabs */
		if ( ! in_user_rooms ) {
			dummy_ptr = tab + 1;
			tab = strchr( dummy_ptr, '	' );	/* a tab character */
			*tab = '\0';
		}

		/* now the dummy number field */
		dummy_ptr = tab + 1;
		tab = strchr( dummy_ptr, '	' );	/* a tab character */
		*tab = '\0';

		stats_ptr = tab + 1;

		/* now do the actual tree insert */
		memset( chatters, 0, sizeof( chatters ));
		memset( voice, 0, sizeof( voice ));
		subrooms = 0;
		tot_chatters = 0;
		tot_voice = 0;
		sptr = stats_ptr;
		while( sptr ) {
			comma = strchr( sptr, ',' );
			if ( comma ) {
				*comma = '\0';
			}

			subroom = atoi( sptr );
			sptr = strchr( sptr, ':' ) + 1;
			chatters[subroom] = atoi( sptr );
			tot_chatters += chatters[subroom];
			if ( strchr( sptr, ':' )) {
				/* voice count listed */
				voice[subroom] = atoi( strchr( sptr, ':' ) + 1 );
				tot_voice += voice[subroom];
			} else {
				/* no voice count listed */
				voice[subroom] = 0;
			}

			if ( subroom > subrooms ) {
				subrooms = subroom;
			}

			if ( comma ) {
				sptr = comma + 1;
			} else {
				sptr = NULL;
			}
		}

		if ( subrooms > 1 ) {
			snprintf( name_c, sizeof(name_c), "%s (%d)",
				name_ptr, tot_chatters );
			/* this shows voice chatter count as well
			snprintf( name_c, sizeof(name_c), "%s (%d, V: %d)",
				name_ptr, tot_chatters, tot_voice );
			*/
			room_item = (ROOM_ENTRY *)malloc( sizeof( ROOM_ENTRY ));
			room_item->room_name = strdup( name_ptr );
			room_item->room_id = NULL;
			room_item->populated = 1;

			tmp_parent = gtk_ctree_insert_node( room_tree, parent_node,
							NULL, data, 5, NULL, NULL, NULL, NULL,
							FALSE, FALSE);

			/* last field is 1 = selectable, 0 = not */
			gtk_ctree_node_set_selectable( room_tree, tmp_parent, 1 );
			gtk_ctree_node_set_row_data( room_tree, tmp_parent, room_item );

			for( subroom = 0; subroom < subrooms; subroom++ ) {
				if (( chatters[ subroom + 1 ] == 0 ) &&
					( voice[ subroom + 1 ] == 0 )) {
					continue;
				}
				snprintf( tmp, sizeof(tmp), "%s:%d", name_ptr, subroom + 1);
				snprintf( name_c, sizeof(name_c), "%s (%d)",
					tmp, chatters[ subroom + 1 ] );
				/* this would show voice as well
				snprintf( name_c, sizeof(name_c), "%s (%d, V: %d)",
					tmp, chatters[ subroom + 1 ],
					voice[ subroom + 1 ] );
				*/
				room_item = (ROOM_ENTRY *)malloc( sizeof( ROOM_ENTRY ));
				room_item->room_name = strdup( tmp );
				room_item->room_id = NULL;
				room_item->populated = 0;

				child_node = gtk_ctree_insert_node( room_tree, tmp_parent,
								NULL, data, 5, NULL, NULL, NULL, NULL,
								FALSE, FALSE);

				/* last field is 1 = selectable, 0 = not */
				gtk_ctree_node_set_selectable( room_tree, child_node, 1 );
				gtk_ctree_node_set_row_data( room_tree, child_node, room_item );
			}
		} else {
			snprintf( name_c, sizeof(name_c), "%s (%d)",
				name_ptr, tot_chatters );
			/* this shows voice chatter count as well
			snprintf( name_c, sizeof(name_c), "%s (%d, V: %d)",
				name_ptr, tot_chatters, tot_voice );
			*/
			room_item = (ROOM_ENTRY *)malloc( sizeof( ROOM_ENTRY ));
			room_item->room_name = strdup( name_ptr );
			room_item->room_id = NULL;
			room_item->populated = 0;

			child_node = gtk_ctree_insert_node( room_tree, parent_node,
							NULL, data, 5, NULL, NULL, NULL, NULL,
							FALSE, FALSE);

			/* last field is 1 = selectable, 0 = not */
			gtk_ctree_node_set_selectable( room_tree, child_node, 1 );
			gtk_ctree_node_set_row_data( room_tree, child_node, room_item );
		}

		ptr = end + 1;
	}
	gtk_clist_thaw( GTK_CLIST(room_tree));
}

void populate_room_list() {
	GtkCTree *room_tree;
	GtkCTreeNode *nodes[21];
	GtkLabel *room_label;
	ROOM_ENTRY *room_item;
	char catlist[128] = "http://chat.yahoo.com/c/roomlist/catfeed.html";
	char buf[65536];
	char title[129];
	char *name_ptr;
	char *number_ptr;
	char *level_ptr;
	char *dl_ptr;
	char *ptr;
	char *tab;
	char *end;
	int url_length;
	int level;

	DBG( 11, "populate_room_list()\n" );

	dl_ptr = strdup( "---- downloading list ----" );
	room_tree = GTK_CTREE(lookup_widget( room_window, "room_tree" ));

	room_label =
		GTK_LABEL( lookup_widget( GTK_WIDGET(room_tree), "loading_status" ));

	gtk_label_set_text( room_label, "Retrieving Room List..." );

	process_gtk_events();

	/* this allows the adult rooms in */
	if(show_adult)
	  my_strncat(catlist,"?.rmcat=1600083764", sizeof(catlist));

	url_length = fetch_url( catlist, buf, ymsg_sess->cookie );

	if ((url_length ) &&
		(!strstr( buf, "Business" )))
		return;

	gtk_label_set_text( room_label, "Loading Room List..." );
	gtk_ctree_set_line_style( room_tree, GTK_CTREE_LINES_NONE);
	gtk_ctree_set_expander_style( room_tree, GTK_CTREE_EXPANDER_TRIANGLE);

	process_gtk_events();

	nodes[0] = NULL;

	gtk_clist_freeze( GTK_CLIST(room_tree) );

	ptr = buf;
	while( *ptr ) {
		end = strchr( ptr, '\n' );
		if ( end ) {
			*end = '\0';	
		}

		/* grab the 3 fields */
		number_ptr = ptr;
		tab = strchr( number_ptr, '	' );	/* a tab character */
		*tab = '\0';

		level_ptr = tab + 1;
		tab = strchr( level_ptr, '	' );	/* a tab character */
		*tab = '\0';
		level = atoi( level_ptr );

		name_ptr = tab + 1;

		/* check the parent to see if we need to remove temp child */
		room_item = gtk_ctree_node_get_row_data( room_tree, nodes[level-1]);
		if (( room_item ) &&
			( room_item->temp_child )) {
			gtk_ctree_remove_node( room_tree, room_item->temp_child );
			room_item->populated = 0;
			room_item->temp_child = NULL;
		}

		room_item = (ROOM_ENTRY *)malloc( sizeof( ROOM_ENTRY ));
		room_item->room_name = strdup( name_ptr );
		room_item->room_id = strdup( number_ptr );
		room_item->populated = 0;
		room_item->temp_child = NULL;

		nodes[level] = gtk_ctree_insert_node( room_tree, nodes[level-1],
						NULL, &name_ptr, 5, NULL, NULL, NULL, NULL,
						FALSE, FALSE);

		/* last field is 1 = selectable, 0 = not */
		gtk_ctree_node_set_selectable( room_tree, nodes[level], 0 );
		gtk_ctree_node_set_row_data( room_tree, nodes[level], room_item );

		/* now download and insert the children */
		snprintf( title, sizeof(title), "Retrieving %s List...", name_ptr );
		gtk_label_set_text( room_label, title );
		gtk_clist_thaw( GTK_CLIST(room_tree) );
		process_gtk_events();
		gtk_clist_freeze( GTK_CLIST(room_tree) );

		room_item->temp_child = gtk_ctree_insert_node( room_tree,
				nodes[level], NULL, &dl_ptr, 5,
					NULL, NULL, NULL, NULL, FALSE, FALSE);
		gtk_ctree_node_set_selectable( room_tree,
			room_item->temp_child, 0 );

		ptr = end + 1;
	}

	free( dl_ptr );
	gtk_label_set_text( room_label, "Room List" );
	gtk_clist_thaw( GTK_CLIST(room_tree) );
}

