/*****************************************************************************
 * users.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _USERS_H_
#define _USERS_H_

typedef struct pm_session {
	GtkWidget *pm_window;
	GtkWidget *pm_text;
	char *pm_user;
	int typing;
} PM_SESSION;

extern GList *user_list;
extern GList *left_list;
extern GList *full_list;

extern GtkWidget * chat_users;
extern GtkWidget * chat_user_menu;
extern char *user_selected;
extern char *follow_user;

extern int  show_html;
extern int  show_statuses;
extern int  show_enters;
extern int  show_blended_colors;
extern int  show_colors;
extern int  show_fonts;
extern int  show_avatars;
extern char *send_avatar;
extern int  show_emoticons;

extern GtkWidget * pm_window;
extern GtkWidget * pm_entry;
extern GtkWidget * pm_user;
extern GList *pm_list;
extern int  pm_in_sep_windows;
extern int  pm_from_friends;
extern int  pm_from_users;
extern int  pm_from_all;
extern int  auto_raise_pm;
extern int  auto_reply_when_away;
extern int  pm_brings_back;

extern GtkWidget * profile_window;
extern char *prof_text;
extern char *prof_pic;

/* generic user/userlist routines */
int find_user_row( char *user );
void user_add( char *user );
void user_remove( char *user );
void chatter_list_populate( char *list, int clear_first );
void chatter_list_add( char *user );
void chatter_list_remove( char *user );
void chatter_list_status( char *user, gchar **status_image, char *status );
GtkFunction view_profile( gpointer data );
void *fetch_profile( void *arg );
void *display_url( void *arg );
int set_last_comment( char *user, char *comment );
char *get_last_comment( char *user );
void show_last_comments();

/* pm sessions */
GList *find_pm_session( char *user );
GList *find_pm_session_from_widget( GtkWidget *widget, char *name );

#endif /* #ifndef _USERS_H_ */
