/*****************************************************************************
 * util.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2000-2002 Chris Pinkham
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * cpinkham@infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 *****************************************************************************/


#ifndef _UTIL_H_
#define _UTIL_H_

typedef struct smiley {
	char *sm_text;
	char *sm_file;
} SMILEY;

extern char mail_user[];
extern char *recv_sound;
extern char *send_sound;
extern int  profile_viewer;
extern SMILEY *smileys;


void strip_html_tags( char *str );
int my_system( char *command );
void display_profile();
int fetch_url( char *image_url, char *buf, char *cookie );
void lower_str( char *str );
void smileys_load();
int check_smiley( char *str );
void convert_smileys( char *str );
void convert_tags( char *str );
void strip_junk( char *str );
void capture_text_to_file( char *filename );
void subst_escs( char *str );
char *filter_text( char *txt );
char *replace_args( char *str, char *args );
void *fetch_avatar( void *arg );
void display_avatar( char *user, char *avatar );
void *play_sound( void *arg );
gint clist_strcasecompare(GtkCList *clist, gconstpointer ptr1, gconstpointer ptr2);
gint gstrcmp( gpointer a, gpointer b );
GList *gyach_g_list_free( GList *list );
GList *gyach_g_list_copy( GList *list );
GList *gyach_g_list_merge( GList *main, GList *sub );

void my_strncat( char *dest, char *src, int size);
void my_strncpy( char *dest, char *src, int size);
int filename_is_sane( char *filename );


#endif /* #ifndef _UTIL_H_ */
