/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993
  Takashi MANABE (manabe@tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

#include	<config.h>

#include	<stdio.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<string.h>
#include	<unistd.h>
#include	<sys/mman.h>
#include	<linux/mm.h>
#include	<sys/kd.h>
#undef free
#include	<stdlib.h>

#include	<mem.h>
#include	<defs.h>
#include	<errors.h>
#include	<vga.h>


#define GRAPH_BASE 0xA0000
#define GRAPH_SIZE 0x10000
#define FONT_SIZE  0x2000

#define	VGA_FONT_SIZE	128
#define	VGA_FONT_HEIGHT	16

#define	NUM_VIDEOH_INFO	4
#define	NUM_VIDEOV_INFO	4

/* DAC Palette */
#define	VGAPAL_OADR	0x3C8
#define	VGAPAL_IADR	0x3C7
#define	VGAPAL_DATA	0x3C9

/* Misc */
#define	VGAMISC_IN	0x3CC
#define	VGAMISC_OUT	0x3C2

/* Input Stat 1 */
#define	VGAST1_ADDR	0x3DA

#define COUNTER_ADDR    0x61

static	char	*gramMem;	/* dummy buffer for mmapping grahics memory */
static	char	*fontBuff1;	/* saved font data - plane 2 */
static	int	gramHead;

static
    void	VgaGetStartAddress(void)
{
    PortOutb(0x0c, VGACRT_ADDR);
    gramHead = (PortInb(VGACRT_ADDR + 1) & 0xff) << 8;
    PortOutb(0x0d, VGACRT_ADDR);
    gramHead |= PortInb(VGACRT_ADDR + 1) & 0xff;
}

static int	VgaAttach(void)
{
    int	devMem;
    
    /* get I/O permissions for VGA registers */
    ioperm(VGACRT_ADDR, 1, 1);
    ioperm(VGAATTR_A_O, 1, 1);
    ioperm(VGAGRP_ADDR, 1, 1);
    ioperm(VGASEQ_ADDR, 1, 1);
    ioperm(VGAPAL_OADR, 1, 1);
    ioperm(VGAPAL_IADR, 1, 1);
    ioperm(VGACRT_DATA, 1, 1);
    ioperm(VGAATTR_DATA, 1, 1);
    ioperm(VGAGRP_DATA, 1, 1);
    ioperm(VGASEQ_DATA, 1, 1);
    ioperm(VGAMISC_IN, 1, 1);
    ioperm(VGAMISC_OUT, 1, 1);
    ioperm(VGAST1_ADDR, 1, 1);
    ioperm(VGAPAL_DATA, 1, 1);
    ioperm(COUNTER_ADDR, 1, 1);
    
    if ((devMem = open("/dev/mem", O_RDWR) ) < 0) {
	perror("/dev/mem");
	return FAILURE;
    }
    if ((gramMem = malloc(GRAPH_SIZE + (PAGE_SIZE-1))) == NULL ||
	(fontBuff1 = malloc(FONT_SIZE)) == NULL) {
	perror("malloc ");
	return FAILURE;
    }
    if ((unsigned long)gramMem % PAGE_SIZE)
	gramMem += PAGE_SIZE - ((unsigned long)gramMem % PAGE_SIZE);
    gramMem = (unsigned char *)mmap(
				    (caddr_t)gramMem,
				    GRAPH_SIZE,
				    PROT_READ|PROT_WRITE,
				    MAP_SHARED|MAP_FIXED,
				    devMem,
				    GRAPH_BASE
				    );
    close(devMem);
    if ((long)gramMem < 0) {
	perror("mmap");
	return FAILURE;
    }
    
    return SUCCESS;
}

static void	VgaDetach(void)
{
    gramHead = 0;
    ioperm(VGACRT_ADDR, 1, 0);
    ioperm(VGAATTR_A_O, 1, 0);
    ioperm(VGAGRP_ADDR, 1, 0);
    ioperm(VGASEQ_ADDR, 1, 0);
    ioperm(VGAPAL_OADR, 1, 0);
    ioperm(VGAPAL_IADR, 1, 0);
    ioperm(VGACRT_DATA, 1, 0);
    ioperm(VGAATTR_DATA, 1, 0);
    ioperm(VGAGRP_DATA, 1, 0);
    ioperm(VGASEQ_DATA, 1, 0);
    ioperm(VGAMISC_IN, 1, 0);
    ioperm(VGAMISC_OUT, 1, 0);
    ioperm(VGAST1_ADDR, 1, 0);
    ioperm(VGAPAL_DATA, 1, 0);
    ioperm(COUNTER_ADDR, 1, 0);
    
    munmap(gramMem, GRAPH_SIZE);
    
    SafeFree((void **)&gramMem);
    SafeFree((void **)&fontBuff1);
}

main()
{
    int i, bit, val, pg;
    u_char red, grn, blu, ext;
    char *file;
    unsigned addr;
    FILE *fp, *fr, *fg, *fb, *fe;
    
    VgaAttach();
    PortOutb(PortInb(COUNTER_ADDR)|3, COUNTER_ADDR);
    usleep(1000);
    PortOutb(PortInb(COUNTER_ADDR)&0xFC, COUNTER_ADDR);
    file = strdup("0.dump.tmp");
    VgaGetStartAddress();
    printf("P6 640 480 257\n");
    for (pg = 0; pg < 4; pg ++) {
	PortOutb(4, VGAGRP_ADDR);
	PortOutb(pg, VGAGRP_DATA);
	*file = pg + '0';
	fp = fopen(file, "w");
	for (i = 0; i < 640*480/8; i ++) {
	    addr = (i + gramHead) % (640*480/8);
	    fprintf(fp, "%c", (u_char)*(gramMem + addr));
	}
	fclose(fp);
    }
    PortOutb(PortInb(COUNTER_ADDR)|3, COUNTER_ADDR);
    usleep(10000);
    PortOutb(PortInb(COUNTER_ADDR)&0xFC, COUNTER_ADDR);
    VgaDetach();
    fr = fopen("0.dump.tmp", "r");
    fg = fopen("1.dump.tmp", "r");
    fb = fopen("2.dump.tmp", "r");
    fe = fopen("3.dump.tmp", "r");
    for (i = 0; i < 640*480/8; i ++) {
	red = fgetc(fr);
	grn = fgetc(fg);
	blu = fgetc(fb);
	ext = fgetc(fe);
	for (bit = 0; bit < 8; bit ++) {
	    val = (ext & 0x80) ? 0xFF: 0xC9;
	    printf("%c%c%c",
		   (blu & 0x80) ? val: 0,
		   (grn & 0x80) ? val: 0,
		   (red & 0x80) ? val: 0);
	    red <<= 1;
	    grn <<= 1;
	    blu <<= 1;
	    ext <<= 1;
	}
    }
    fclose(fe);
    fclose(fb);
    fclose(fg);
    fclose(fr);
    unlink("0.dump.tmp");
    unlink("1.dump.tmp");
    unlink("2.dump.tmp");
    unlink("3.dump.tmp");
}
