/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/types.h>
#include	<sys/ioctl.h>
#include	<sys/file.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<errno.h>

#include	<interface.h>
#include	<fnld.h>

extern struct fontInfo fi;
extern forceLoad;

u_char	*FontLoadBdf(fp)
FILE *fp;
{
    char *fdata = NULL, line[256], *p, *w, reg[256];
    u_char ch, ch2;
    int	num, width, high, i, code, data, k, n;
    struct fontRegs *fReg;
    struct fontLoaderRegs *fldReg;

    fReg = &fSRegs[0];
    fldReg = &fldSRegs[0];
    fi.type = CodingByRegistry("ISO8859-1");
    num = width = high = 0;
    while(fgets(line, 256, fp)) {
	if (!width && !high &&
	    !strncmp("FONTBOUNDINGBOX", line,
		     strlen("FONTBOUNDINGBOX"))) {
	    p = line + sizeof("FONTBOUNDINGBOX");
	    sscanf(p, "%d %d", &width, &high);
	} else if (!strncmp("CHARSET_REGISTRY", line, 16)) {
	    p = line + sizeof("CHARSET_REGISTRY");
	    while(*p != '"') p ++;
	    w = ++p;
	    while(*p != '"') p ++;
	    *p = '\0';
	    strcpy(reg, w);
	} else if (!strncmp("CHARSET_ENCODING", line, 16)) {
	    p = line + sizeof("CHARSET_ENCODING");
	    while(*p != '"') p ++;
	    w = ++p;
	    while(*p != '"') p ++;
	    *p = '\0';
	    strcat(reg, "-");
	    strcat(reg, w);
	    fi.type = CodingByRegistry(reg);
	} else if (!num && !strncmp("CHARS ", line, 6)) {
	    p = line + sizeof("CHARS");
	    sscanf(p, "%d", &num);
	    break;
	}
    }
    fi.width = width;
    fi.high = high;
    if (fi.type & CHR_DBC) {
	fldReg = &fldDRegs[fi.type&~CHR_DFLD];
	fReg = &fDRegs[fi.type&~CHR_DFLD];
	if (fldReg->max)
	    fi.size = fldReg->addr(fldReg->max >> 8, fldReg->max & 0xFF)
		+ 16;
	else
	    fi.size = (width / 8 + ((width % 8 > 0) ? 1: 0)) * num * 16;
	width = 0;
    } else {
	fldReg = &fldSRegs[fi.type&~CHR_SFLD];
	fReg = &fSRegs[fi.type&~CHR_SFLD];
	if (fldReg->max)
	    fi.size = fldReg->max * 16;
	else
	    fi.size = num * 16;
    }
    if ((fdata = (u_char *)malloc(fi.size)) == NULL) return(NULL);
    k = 0;
    while(fgets(line, 256, fp)) {
	if (!strncmp("ENCODING", line, strlen("ENCODING"))) {
	    p = line + sizeof("ENCODING");
	    code = atoi(p);
	} else if (!strncmp("BITMAP", line, strlen("BITMAP"))) {
	    p = fdata + code * 16;
	    k ++;
#ifdef BDFCAT
	    printf("----- %X -----\n", code);
#endif
	    if (!(fi.type & CHR_DBC)) {
		for (i = 0; i < fi.high; i ++, p ++) {
		    fscanf(fp, "%2X", &data);
#ifdef BDFCAT
		    for (n = 0; n < 7; n ++)
			printf("%c", ((data << n) & 0x80) ? '#':' ');
		    printf("\n");
#else
		    *p = data;
#endif
		}
	    } else {
		ch = (code >> 8) & 0xFF;
		ch2 = code & 0xFF;
		num = fldReg->addr(ch, ch2);
		if (num > width) width = num;
		p = fdata + num;
		for (i = 0; i < fi.high; i ++, p ++) {
		    fscanf(fp, "%4X", &data);
#ifdef BDFCAT
		    for (n = 0; n < 15; n ++)
			printf("%c", ((data << n) & 0x80) ? '#':' ');
		    printf("\n");
#else
		    *p = (data >> 8) & 0xFF;
		    p ++;
		    *p = data & 0xFF;
#endif
		}
	    }
	}
    }
    return(fdata);
}

#ifdef BDFCAT
struct fontInfo fi;
forceLoad;

void main(int argc, char *argv[])
{
    FILE *fp;

    fp = fopen(argv[1], "r");
    FontLoadBdf(fp);
}
#endif
