/*
	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)

	KON is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	KON is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* getcap library - read configuration file and invoke initializer function */

#ifndef GETCAP_H
#define GETCAP_H

#include	<defs.h>

/* Initializer function should return 0 on success, -1 on failure. */
typedef int	(initializer)(const char *);

/* Define initializer function func for capability name.  If def_value is nil,
   then the entry of the name must exist in configuration file.  An error is
   flagged if no entry is found.  If def_value is non-nil and no entry is found
   in configuration file, then func is invoked with def_value. */
extern void	DefineCap(const char *name, initializer *func, const char *def_value);

/* Delete all initializer functions. */
extern void	CapInit(void);

/* Read configuration file named filename and invoke initializer function for each entry.
   Return 0 on success, -1 on failure. */
extern int	ReadConfig(const char *filename);

/* Set value for capability capName.  Return 0 on success, -1 if capName not defined. */
extern int	SetCapArg(const char *capName, const char *value);

#define	MAX_COLS	256		 /* maximum line length of config file */

/* Utility function that return 1 if confstr is "On" and 0 if "OFF". */
extern bool BoolConf(const char *confstr);

#endif
