/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

/* mem -- memory handling libraries */

#ifndef MEM_H
#define MEM_H

static inline
    void PortOutw(u_short value, u_short port)
{
    __asm__ ("outw %0,%1"
	     ::"a" ((u_short) value),
	     "d" ((u_short) port));
}

static inline
    void PortOutb(char value, u_short port)
{
    __asm__ ("outb %0,%1"
	     ::"a" ((char) value),
	     "d" ((u_short) port));
}

static inline
    void lzero(void *head, int n)
{
    __asm__ ("cld\n\t"
	     "rep\n\t"
	     "stosl"
	     ::"a" (0),
	     "c" (n>>2),
	     "D" ((long)head)
	     :"cx","di");
}

static inline
    void bmove(void *dst, void *src, int n)
{
    __asm__ ("cld\n\t"
	     "rep\n\t"
	     "movsb\n\t"
	     ::"c" (n),
	     "D" ((long)dst),
	     "S" ((long)src)
	     :"cx","di","si");
}

static inline
    void brmove(void *dst, void *src, int n)
{
    __asm__ ("std\n\t"
	     "rep\n\t"
	     "movsb\n\t"
	     ::"c" (n),
	     "D" ((long)dst),
	     "S" ((long)src)
	     :"cx","di","si");
}

static inline
    void bzero2(void *head, int n)
{
    __asm__ ("cld\n\t"
	     "rep\n\t"
	     "stosb"
	     ::"a" (0),
	     "c" (n),
	     "D" ((long)head)
	     :"cx","di");
}

extern u_char PortInb(u_short);
extern void wzero(void *, int);
extern void wmove(void *, void *, int);
extern void lmove(void *, void *, int);
extern void SafeFree(void **);

#endif
