/*
	HAN - HANgul On Linux Console -
	Copyright (C) 1994 Oh SungKyu(hanmaum@baram.kaist.ac.kr)

	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)

	HAN is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	HAN is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* vc -- high-level console driver */

#ifndef VC_H
#define VC_H

#define	ATTR_ULINE	0x80	/* under line */
#define	ATTR_REVERSE	0x40	/* reverse */
#define	ATTR_HIGH	0x20	/* high */

#define	LATCH_S		0x0 /* single byte char */
#define	LATCH_1		0x20 /* double byte char 1st byte */
#define	LATCH_2		0x40 /* double byte char 2nd byte */

#define	CLEAN_S		0x80
#define	CODEIS_1	LATCH_1
#define	CODEIS_2	LATCH_2
#define	LANG_CODE	0x0F
/*
#define	LANG_DCODE	LANG_CODE|CODEIS_1
#define	LANG_SCODE	LANG_CODE
*/

extern void	ConsoleInit(const char *video_type);
extern void	ConsoleStart(void);
extern void	ConsoleCleanup(void);
extern void	TextClearAll(void);
extern void	TextClearEol(u_char);
extern void	TextClearEos(u_char);
extern void	TextDeleteChar(int);
extern void	TextInsertChar(int);
extern void	TextMoveDown(int top, int btm, int line);
extern void	TextMoveUp(int top, int btm, int line);
extern void	TextMode(void);
extern void	GraphMode(void);
extern void	ScrollUp(int);
extern void	ScrollDown(int);
extern void	TextWput(u_char ch1, u_char ch2);
extern void	TextSput(u_char ch);
extern void	TextReverse(int fx, int fy, int tx, int ty);
extern void	TextRefresh(void);
extern void	TextInvalidate(void);
extern void	TextCopy(int fx, int fy, int tx, int ty);
extern void	TextPaste(void);
extern void	PollCursor(bool wakeup); /* Called to wakeup, or every 0.1 sec when idle */
extern void	Beep(void);
extern void	ChangeCursorShape(int mode);

struct cursorInfo {
    short kanji;	 /* ξˤ TRUE */
    u_int addr;		 /* VRAM ɥ쥹 */
    bool sw;		 /* FALSE ʤɽػ */
    int	interval;	 /* Ǵֳ */
    int	count;		 /* ѥ */
    bool shown;		 /* ɽե饰 */
};

/* video driver interface */
struct videoInfo {
    bool
	has_hard_scroll;	 /* ϡɥ뤬Ȥ뤫ɤ */
    void
	(*init)(void),		 /*  */
	(*text_mode)(void),	 /* ƥȥ⡼ɤؤ */
	(*graph_mode)(void),	 /* եå⡼ɤؤ */
	(*wput)(u_char *code, u_char fc, u_char bc), /*  */
	(*sput)(u_char *code, u_char fc, u_char bc), /* ANK */
	(*set_cursor_address)(struct cursorInfo *c, u_int x, u_int y),
	/*  c Υɥ쥹 (x,y)  */
	(*set_address)(u_int i),
	/* ʸ񤭹ߥɥ쥹 i ʸܤ */
	(*cursor)(struct cursorInfo *),	/* ȥ */
	(*clear_all)(void),	 /* ̥ꥢ */
	(*screen_saver)(bool),	 /* ꡼֥/֥ */
	(*detatch)(void),	 /* ɥ饤в */
	/* ϡɥ뤬ȤʤаʲNULL */
	(*set_start_address)(void),	/* ɽϥɥ쥹 */
	(*hard_scroll_up)(int lines), 	/* ϡɥ륢å */
	(*hard_scroll_down)(int lines),	/* ϡɥ */
	(*change_cursor_shape)(int lines);	/* 1:normal, 2:other */
};

struct dispInfo {
    int
	gsize;
    short
	gxdim,
	gydim,
	txmax,
	tymax,
	glineChar,	/* text ʬ graph Կ */
	glineByte,	/* graph ʬΥХȿ */
	tlineByte;	/* text ʬΥХȿ */
};

extern struct dispInfo		dInfo;
extern struct cursorInfo	cInfo;
extern struct videoInfo		vInfo;

#endif
