/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993, 1994 Takashi MANABE
  (manabe@Roy.dsl.tutics.tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

/* vt -- VT emulator */

#ifndef VT_H
#define VT_H

#include	<defs.h>
#include	<fnld.h>

struct _con_info {
    char
	x,
	y,
	xmax,	/* 79 */
	ymin,	/* 0:볫Ϲ */
	ymax,	/* 29 */
	tab;	/* 8 */
    u_char
	fcol,	/* ե */
	bcol,	/* Хå */
	attr,	/* ʸ° */
	sb,	/* 1 byte code եֹ */
	db,	/* 2 byte code եֹ */
	knj1;	/* 饯 1 byte */
    void (*esc)(u_char);
    enum {
	CS_LEFT,
	CS_RIGHT,
	CS_GRAPH,
	CS_DBCS} trans, g[2];
    bool
	soft,
	ins,
	active,
	wrap,
	text_mode;
};

extern struct	_con_info con;

#define	CODE_2022	0	/* 2022 Τߤ˽*/
#define	CODE_EUC	1	/* EUC ˤ⽾ */
#define	CODE_SJIS	2	/* SJIS ˤ⽾ */

#define	G0_SET	0
#define	G1_SET	0x80

extern void	VtInit(void);
extern void	VtStart(void);
extern void	VtEmu(const char*, int nchars);
extern void	VtCleanup(void);

#define	sjistojis(ch, cl)\
{\
    ch -= (ch > 0x9F) ? 0xB1: 0x71;\
    ch = ch * 2 + 1;\
    if (cl > 0x9E) {\
	cl = cl - 0x7E;\
	ch ++;\
    } else {\
	if (cl > 0x7E) cl --;\
	cl -= 0x1F;\
    }\
}

#define	jistosjis(ch, cl)\
{\
    if (ch & 1) cl = cl + (cl > 0x5F ? 0x20:0x1F);\
    else cl += 0x7E;\
    ch = ((ch - 0x21) >> 1) + 0x81;\
    if (ch > 0x9F) ch += 0x40;\
}

/*
  derived from Mule:codeconv.c to support "ESC $(0" sequence
  thanks to K.Handa <handa@etl.go.jp>
  */

#define muletobig5(type, m1, m2)\
{\
    unsigned code = (m1 - 0x21) * 94 + (m2 - 0x21);\
\
    if (type == DF_BIG5_1) code += 0x16F0;\
    m1 = code / 157 + 0xA1;\
    m2 = code % 157;\
    m2 += m2 < 0x3F ? 64 : 98;\
}

enum {
    DF_GB2312,
    DF_JISX0208,
    DF_KSC5601,
    DF_JISX0212,
    DF_BIG5_0,
    DF_BIG5_1
    };

#endif
