/*
	HAN - HANgul On Linux Console -
	Copyright (C) 1992, 1993, 1994 Takashi MANABE (manabe@tut.ac.jp)

	KON - Kanji ON Linux Console -
	Copyright (C) 1992, 1993, 1994 Takashi MANABE (manabe@tut.ac.jp)

	HAN is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	HAN is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>

#ifdef __FreeBSD__
#include        <errno.h>
#endif

#include	<getcap.h>

#include	<defs.h>
#include	<version.h>
#include	<vc.h>

#include	<hfilter.h>

static char *startupStr, *execProg;

int	ConfigExecProg(const char *string)
{
	execProg = strdup(string);
	return SUCCESS;
}

static int	ConfigStartup(const char *string)
{
	startupStr = strdup(string);
	return SUCCESS;
}

static void	RunStartupCmd(void)
{
	char *p;

	p = strtok(startupStr, "\n");
	while(p) {
		system(p);
		p = strtok(NULL, "\n");
	}
}

static bool startupMessage;

static int	ConfigMessage(const char *confstr)
{
	startupMessage = BoolConf(confstr);
	return SUCCESS;
}

static int	ConfigHangulKeyboard(const char *confstr)
{
	hfilter_setkeyboard(atoi(confstr));
	return SUCCESS;
}

static int	ConfigHangulToggleChar(const char *confstr)
{
	hfilter_settogglechar(atoi(confstr));
	return SUCCESS;
}

void	ChildInit(void)
{
	DefineCap("StartupMessage", ConfigMessage, "On");
	DefineCap("StartUp", ConfigStartup, NULL);
	DefineCap("HangulKeyboard", ConfigHangulKeyboard, "2");
	DefineCap("HangulToggleChar", ConfigHangulToggleChar, "31");
}

void	ChildCleanup(void)
{
	free(startupStr);
}

void	ChildStart(FILE *errfp)
{
	char	*shell, *tail, *tcap;
	char	buff[80];

	setgid(getgid());
	setuid(getuid());

	RunStartupCmd();
#if defined(linux)
	sprintf(buff, "TERMCAP=:co#%d:li#%d:tc=console:",
		dInfo.txmax + 1, dInfo.tymax + 1);
#elif defined(__FreeBSD__)
	sprintf(buff,"TERM=vt100");
#endif
	tcap = strdup(buff);
	putenv(tcap);

	if (startupMessage) {
	    printf("\rHAN " VERSION "\r\n"
                   "\tCopyright (C) 1994 Oh SungKyu\r\n"
                   "\tCopyright (C) 1993, 1994 Takashi MANABE and MAEDA Atusi\r\n"
		   "HAN comes with \x1b[4mABSOLUTELY NO WARRANTY\x1b[m.\r\n"
		   "HAN is free software, and you are welcome to redistribute it\r\n"
		   "HAN under certain conditions; show COPYING for details.\r\n");
#if defined(__FreeBSD__)
	    printf("\rHAN for FreeBSD-2.x\r\n");
#endif
	}
	printf("HAN using VT number %c.\n\n",
#if defined(linux)
	       *(ttyname(fileno(errfp))+8));
#elif defined(__FreeBSD__)
	       *(ttyname(fileno(errfp))+9));
#endif
	fflush(stdout);

	if (execProg)
	    execlp(execProg, execProg, 0);
	else {
	    if ((execProg = getenv("SHELL")) == NULL)
		execProg = "/bin/sh";
	    if ((tail = rindex(execProg, '/')) == NULL)
		tail = " sh";
	    sprintf(buff, "-%s", tail + 1);
	    execl(execProg, buff, 0);
	}
	fprintf(errfp, "HAN> couldn't exec shell\r\n");
	fprintf(errfp, "%s: %s\r\n", execProg, strerror(errno));
	exit(EXIT_FAILURE);
}
