/*
  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993, 1994 Takashi MANABE (manabe@tut.ac.jp)
  
  KON is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  KON is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

/*
  This code is based on vgalib.
  
  Thanks to frandsen@diku.dk (Tommy Frandsen).
  */

#include	<config.h>

#ifdef	HAS_VGA

#include	<stdio.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<string.h>
#include	<unistd.h>
#include	<sys/mman.h>
#if defined(linux)
#include	<linux/mm.h>
#include	<sys/kd.h>
#endif
#undef free
#include	<stdlib.h>

#include	<mem.h>
#include	<getcap.h>
#include	<defs.h>
#include	<errors.h>
#include	<vc.h>
#include	<vt.h>
#include	<vga.h>
#include	<fnld.h>

static
    void SvgaSetStartAddress(void)
{
    int	til;
    
    til = (dInfo.gydim - 1 - (gramHead / dInfo.glineByte)) << 4;
    
    PortOutw((gramHead  & 0xff00) | 0x0c, vgaCrtAddr);
    PortOutw((gramHead << 8) | 0x0d, vgaCrtAddr);
    PortOutw((til << 4) | 0x18, vgaCrtAddr);
    PortOutw((til & 0x1000) | LineComp8, vgaCrtAddr);
    PortOutw(((til & 0x2000) << 1) | LineComp9, vgaCrtAddr);
}

struct videoInfo SvgaInfo =
{
    TRUE,
    VgaInit,
    VgaTextMode,
    VgaGraphMode,
    VgaWput,
    VgaSput,
    VgaSetCursorAddress,
    VgaSetAddress,
    VgaCursor,
    VgaClearAll,
    VgaScreenSaver,
    VgaDetach,
    SvgaSetStartAddress,
    VgaHardScrollUp,
    VgaHardScrollDown,
    VgaChangeCursorShape
    };

int SvgaSetVideoType(struct videoInfo *info, const char *regs)
{
    union videoTimings video;

    *info = SvgaInfo;
    VgaReadNewRegs(regs, &video);
    if (VgaAttach() < 0) return FAILURE;
    VgaDefaultCaps();
    return SUCCESS;
}

#endif
