#include <stdlib.h>

#include <hautomata.h>
#include <hfilter.h>

static int hfilter_keyboard = 2;
static unsigned char hfilter_togglechar = 31;

struct hfilter *hfilter_new()
{
    struct hfilter *hfilter_ptr;

    hfilter_ptr = (struct hfilter *)malloc(sizeof(struct hfilter));
    hfilter_ptr->automata = hanterm_automata_new(hfilter_keyboard);

    return hfilter_ptr;
}

void hfilter_delete(hfilter_ptr)
struct hfilter *hfilter_ptr;
{
    hanterm_automata_delete(hfilter_ptr->automata);
    free(hfilter_ptr);
}

int hfilter_input (hfilter_ptr, ch, buffer)
struct hfilter *hfilter_ptr; 
int ch;
char *buffer;
{
    return hanterm_automata_input(hfilter_ptr->automata, ch, buffer);
}

char *hfilter_cursor (hfilter_ptr)
struct hfilter *hfilter_ptr; 
{
    return hfilter_ptr->automata->temp_hangul_;
}

int hfilter_hangulstate (hfilter_ptr)
struct hfilter *hfilter_ptr; 
{
    return hfilter_ptr->automata->hangul_state_;
}

int hfilter_istogglechar (ch)
unsigned char ch;
{
    return hfilter_togglechar == ch;
}

void hfilter_setkeyboard (keyboard)
int keyboard;
{
    if (keyboard == 2 || keyboard == 3)
        hfilter_keyboard = keyboard;
}

void hfilter_settogglechar (togglechar)
unsigned char togglechar;
{
        hfilter_togglechar = togglechar;
}
