/*
  HAN - HANgul on Linux Console -
  Copyright (C) 1994 Oh SungKyu
  (hanmaum@baram.kaist.ac.kr)

  HAN - Hangul on FreeBSD console -
  Copyleft 1997, Kim Se Hee(yujeny@pandora.snu.ac.kr)
                 Choi Jun Ho(junker@jazz.snu.ac.kr)

  KON - Kanji ON Linux Console -
  Copyright (C) 1992, 1993, 1994 Takashi MANABE
  (manabe@Roy.dsl.tutics.tut.ac.jp)
  
  HAN is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  HAN is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <getcap.h>

#include <version.h>
#include <term.h>

void main(int argc, const char *argv[])
{
    char	*p;
#if defined(linux)
    fprintf(stderr, "HANgul On Linux console " VERSION "\n\n");
#elif defined(__FreeBSD__)
    fprintf(stderr, "HANgul On FreeBSD console " VERSION "\n\n");
#endif

    if (geteuid() != 0) {
	fprintf(stderr, "can not get I/O permissions.\n");
	exit(EXIT_FAILURE);
    }

    ChangeNewConsole();
    TermInit(argc - 1, argv + 1);
    if (ReadConfig(CONFIG_NAME) < 0) {
	fprintf(stderr, "HAN> error reading %s\n", CONFIG_NAME);
	exit(EXIT_FAILURE);
    }
    TermStart();
}
