/*
  syslogk - capture linux kernel message and send it to system logger
  Copyright (C) 1992, 1993 Peter MacDonald (sanjuan!pmacdona@sol.UVic.CA)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Modified by MAEDA Atusi (mad@math.keio.ac.jp) Jan 22 1993
    - send message to system logger instead of printing to stdout
*/

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <syscall.h>
#include <syslog.h>

/*
#define SYS_linux_syslog SYS_syslog
static _syscall3(int,linux_syslog,int,type,char *,buf,int,size)
*/
static _syscall3(int,syslog,int,type,char *,buf,int,size)

void usage(void)
{
	puts("capture kernel messages and send them to system logger.");
   	puts("usage: syslogk on");
	puts("       syslogk off");
	exit(-1);
}

char buffer[1024];

int main(int argc, char ** argv)
{
        int i;

        errno = 0;
        if (argc == 2 && !strcmp("off",argv[1]))
                linux_syslog(0,0,0);
        else if (argc == 2 && !strcmp("on",argv[1]))
	{
                linux_syslog(1,0,0);
		openlog("kernel", LOG_ODELAY, LOG_KERN); 
		syslog(LOG_INFO, "syslogk restarted");
                while (1) {
			char *p;
                        i = linux_syslog(2,buffer,1024);
                        if (i < 0)
                                if (errno == EINTR)
                                        continue;
                                else
                                        break;
			buffer[i] = '\0';
			p = buffer;
			syslog(LOG_ERR, "%s", p);
			for (p = strchr(p, '\n'); p && p < (buffer + i); 
			     p = strchr(p, '\n')) {
				while (isspace(*p)) {
					p++;
				}
				if (p < (buffer + i)) {
					syslog(LOG_INFO, "%s", p);
				}
			}
                }
	}
	else
		usage();
        if (errno)
                syslog(LOG_ERR, "syslogk: %m");
	syslog(LOG_INFO, "syslogk exiting");
	closelog();
        return errno;
}
