/*
  Hatari - cart.img

  This file is distributed under the GNU Public License, version 2 or at
  your option any later version. Read the file gpl.txt for details.
*/

/* Cartridge - with our gemdos handler */
/* C-Init flag has bit 3 set = before disk boot, but after GEMDOS init */
unsigned char cart_hdr[] =
{
  0xAB,0xCD,0xEF,0x42,        /* C-FLAG */
  0x00,0x00,0x00,0x00,        /* C-NEXT */
  0x08,0xFA,0x00,0x24,        /* C-INIT */
  0x00,0x00,0x00,0x00,        /* C-RUN */
  0x00,0x00,                  /* C-TIME */
  0x00,0x00,                  /* C-DATE */
  0x00,0x00,0x00,0x00,        /* C-BSIZ, offset: $14*/
  'H','A','T','A','R','I','.','I','M','G',0x00,0x00, /* C-NAME */

  /* Code ($FA0024) - Set up GEMDOS handler and initialize some system variables */
  0xA0,0x00,                  /* Line-A init (for VDI resolutions, see OpCode_SysInit()) */
  0x00,0x0A,                  /* SYSINIT_OPCODE */
  0x4E,0x75                   /* RTS */
};


/* NOTE! Remove first 0x1c (PRG_HEADER_SIZE) bytes from image */

unsigned char cart_img[624-PRG_HEADER_SIZE] =
{
0x00,0xfa,0x11,0xc8,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x08,0x69,0x00,
0x00,0x0a,0x66,0x00,0x00,0x04,0x4e,0x73,0x00,0x09,0x41,0xef,0x00,0x08,
0x08,0x17,0x00,0x05,0x66,0x04,0x4e,0x68,0x54,0x48,0x4a,0x50,0x66,0x2a,
0x2f,0x0e,0x2c,0x48,0x2f,0x0e,0x61,0x00,0x00,0x3c,0x2c,0x5f,0x61,0x00,
0x00,0x8a,0x61,0x00,0x00,0xa8,0x42,0xae,0x00,0x02,0x42,0xae,0x00,0x0a,
0x2d,0x40,0x00,0x06,0x3c,0xbc,0x00,0x04,0x2c,0x5f,0x60,0x00,0xff,0xc4,
0x0c,0x50,0x00,0x03,0x66,0xbc,0x2f,0x0e,0x2c,0x48,0x61,0x00,0x00,0x0e,
0x61,0x00,0x00,0x5e,0x61,0x00,0x00,0x7c,0x2c,0x5f,0x4e,0x73,0x3f,0x3c,
0x00,0x2f,0x4e,0x41,0x54,0x4f,0x20,0x40,0x2f,0x18,0x2f,0x18,0x2f,0x18,
0x2f,0x18,0x2f,0x18,0x2f,0x18,0x2f,0x18,0x2f,0x18,0x2f,0x18,0x2f,0x18,
0x2f,0x18,0x2f,0x08,0x3f,0x3c,0x00,0x17,0x2f,0x2e,0x00,0x02,0x3f,0x3c,
0x00,0x4e,0x4e,0x41,0x50,0x4f,0x20,0x5f,0x21,0x1f,0x21,0x1f,0x21,0x1f,
0x21,0x1f,0x21,0x1f,0x21,0x1f,0x21,0x1f,0x21,0x1f,0x21,0x1f,0x21,0x1f,
0x21,0x1f,0x4a,0x80,0x67,0x04,0x58,0x4f,0x60,0xaa,0x4e,0x75,0x2f,0x2e,
0x00,0x0a,0x2f,0x2e,0x00,0x06,0x42,0xa7,0x3f,0x3c,0x00,0x05,0x3f,0x3c,
0x00,0x4b,0x4e,0x41,0x4f,0xef,0x00,0x10,0x4a,0x80,0x6b,0x02,0x4e,0x75,
0x58,0x4f,0x60,0x86,0x48,0xe7,0x03,0x1c,0x2a,0x40,0x42,0x67,0x2f,0x2e,
0x00,0x02,0x3f,0x3c,0x00,0x3d,0x4e,0x41,0x50,0x4f,0x2c,0x00,0x2f,0x0d,
0x06,0x97,0x00,0x00,0x00,0xe4,0x48,0x78,0x00,0x1c,0x3f,0x06,0x3f,0x3c,
0x00,0x3f,0x4e,0x41,0x4f,0xef,0x00,0x0c,0x2f,0x0d,0x06,0x97,0x00,0x00,
0x01,0x00,0x48,0x79,0x7f,0xff,0xff,0xff,0x3f,0x06,0x3f,0x3c,0x00,0x3f,
0x4e,0x41,0x4f,0xef,0x00,0x0c,0x3f,0x06,0x3f,0x3c,0x00,0x3e,0x4e,0x41,
0x58,0x4f,0x49,0xed,0x00,0x08,0x20,0x0d,0x06,0x80,0x00,0x00,0x01,0x00,
0x28,0xc0,0x20,0x2d,0x00,0xe6,0x28,0xc0,0xd0,0xad,0x00,0x08,0x28,0xc0,
0x28,0xed,0x00,0xea,0xd0,0xad,0x00,0xea,0x28,0xc0,0x28,0xed,0x00,0xee,
0x20,0x0d,0x06,0x80,0x00,0x00,0x00,0x80,0x2b,0x40,0x00,0x20,0x28,0x6d,
0x00,0x18,0xd9,0xed,0x00,0xf2,0x26,0x6d,0x00,0x08,0x20,0x0b,0x4a,0x6d,
0x00,0xfe,0x66,0x32,0x2e,0x14,0x28,0xfc,0x00,0x00,0x00,0x00,0xbe,0xbc,
0x00,0x00,0x00,0x00,0x67,0x22,0xd7,0xc7,0x7e,0x00,0xd1,0x93,0x1e,0x14,
0x18,0xfc,0x00,0x00,0xbe,0x3c,0x00,0x00,0x67,0x10,0xbe,0x3c,0x00,0x01,
0x66,0x06,0x47,0xeb,0x00,0xfe,0x60,0xe8,0xd6,0xc7,0x60,0xe2,0x20,0x2d,
0x00,0x1c,0x67,0x0a,0x20,0x6d,0x00,0x18,0x42,0x18,0x53,0x80,0x66,0xfa,
0x20,0x0d,0x4c,0xdf,0x38,0xc0,0x4e,0x75,0x48,0xe7,0x7f,0xfe,0x3f,0x3c,
0x00,0x00,0x3f,0x3c,0x00,0x00,0x3f,0x3c,0x00,0x01,0x2f,0x3c,0x00,0x00,
0x16,0x7a,0x3f,0x3c,0x00,0x00,0x3f,0x3c };
