#include <stdio.h>

/* ------------------------------------------------------
    Search for Starting Mark and print out (ENGLISH) prologue
    mark : Starting Code
    Two file pointer   : fhin, fhout
  ------------------------------------------------------- */

void rmprolog(mark,fpin,fpout)
char mark[];
FILE *fpin, *fpout;
{
    unsigned char c;
    int i,p=0,len=strlen(mark);

    while( (c=getc(fpin)) != (unsigned char) EOF ) {
        if (c==mark[p]) {
            if (p==len-1) {
                /* bug fix:enclosed c=getc(fpin) with (). jshin ( 7/18/96) */
                if ( (c=getc(fpin)) != '\n') ungetc(c,fpin);
                return;
            } else {
                p++;
            }
        } else {
            for ( i=0; i<p; i++ )
                putc(mark[i],fpout);
            p=0;
            putc(c,fpout);
        }
    }
    ungetc(c,fpin);
}

extern int prstat;
#define BUF 4096

#define  PRNONE     0
#define  PRENG      1
#define  PRINTING   2
#define  PRINTED    3 /* Output Routine Inner Stat */

int putprolog(fpin,fpout) 
FILE *fpin, *fpout;
{
    unsigned char ibuf[BUF];

    while  (prstat==PRNONE)
        if ( fgets((char *)ibuf,BUF,fpin) == NULL ) 
            return (1);  /* end of file. no more conversion is necessary */
        else 
            prstat=ks2iso(ibuf,fpout); 

    return(0);
           
}


#define isksc(c)   ( (unsigned char) (c) > (unsigned char) '\240'   && \
       (unsigned char)  (c) < (unsigned char) '\377' ) 
#define is7ksc(c)   ( (unsigned char) (c) > (unsigned char) '\040'   && \
       (unsigned char)  (c) < (unsigned char) '\177' ) 

#define KSC 1
#define ASCII 0
#define SI '\017'
#define SO '\016'

int ks2iso(ibuf,fpout)
unsigned char *ibuf;
FILE *fpout;
{
    int mode=ASCII;
    int i=0;
    int c;
    static int ishangul=0;
    unsigned char *iptr=ibuf;
   

    if ( !ishangul )

     /* search for KSC 5601 character(s) in ibuf */

        while (*iptr != '\n' && *iptr != (unsigned char) EOF && 
                 *iptr != '\0'  ) {
           if ( isksc(*iptr) ) {
              ishangul = 1;               /* found KSC 5601 */
              fprintf(fpout,"\033$)C\n");   /* put out the designator */
              break;                      
           }
           iptr++;
        }

    if ( !ishangul) {     /* KSC 5601 doesn't appear, yet */
        fputs((char *) ibuf,fpout);   /* no conversion */
        return(PRNONE);
    }

    iptr=ibuf;     /* back to the beginning of the ibuf */

    while (  *iptr != '\n' && *iptr != (unsigned char) EOF &&
             *iptr != '\0'  ) {

        if ( mode == ASCII && isksc(*iptr))  {
         
            fputc(SO,fpout);
            fputc(0x7f & *iptr,fpout);
            mode = KSC;
        }
        else if ( mode == ASCII && !isksc(*iptr) )
            fputc(*iptr,fpout);
        else if ( mode == KSC && isksc(*iptr) )
/*      else if ( mode == KSC && ( isksc(*iptr) || *iptr == ' ' ) ) */
            fputc(0x7f & *iptr,fpout);
        else {
            fputc(SI,fpout);
            fputc(*iptr,fpout);
            mode = ASCII;
        }
        iptr++;
     }
     if ( mode == KSC) 
        fputc(SI,fpout);


     if ( *iptr == '\n'  || ( *iptr == '\0' && (iptr-ibuf) == BUF ) )      
       fputc('\n',fpout);       

     return(PRINTED);
}

       

/* ------------------------------------------------------
    Read and write the headers (until \n).
    if there is any KSC char, Printout through prwc
    Two file pointer : fhin, fhout
    function pointer : prwc

    A hacked version of sdn2ks by Uhhyung Choi.
    Modified by jylee on Dec, 1, 1992.

    Modified for header-only input by jshin, June, 1996
  ------------------------------------------------------- */

#define HDR_BUF_LEN 1024

extern int bqheader_decode();

extern void base64_to_string();
extern void string_to_base64();
extern void qencode_to_string();
extern void header_switch();

enum Head_Encode {Bencode,Qencode};

int rmSDNheader(fpin,fpout,outCode,prwc)
FILE *fpin, *fpout;
int outCode;
void (*prwc)();
{
    unsigned char ibuf[HDR_BUF_LEN],obuf[HDR_BUF_LEN],tbuf[HDR_BUF_LEN];
    unsigned char *iptr, *optr, *tptr;
    unsigned long int outwc;

    char *charset[] = {"EUC-KR", "ISO-2022-KR", NULL};
    char encode_prefix[20];
    int isbqheader;

    do {
        iptr = ibuf;
        if (fgets((char *) ibuf,HDR_BUF_LEN,fpin) == NULL)  /* no message body  */ 
           return(1);                       /* header only (6/8/96)  */

        if ( ! strncasecmp("Content-Type:",iptr,13) || 
             !strncasecmp("Content-Transfer-Encoding:",iptr,26) ) {
             header_switch(iptr,fpout);
             continue;
        }
                                            
        while (*iptr) {                    
            int i=-1;
            isbqheader=0;


            while ( charset[++i]  != NULL ) {

                sprintf(encode_prefix,"=?%s?B?",charset[i]);
                if (  ! strncasecmp(encode_prefix,iptr,
                strlen(encode_prefix)) ) {
                    isbqheader=
                    bqheader_decode(&iptr,encode_prefix,Bencode, 
                    fpin,fpout,outCode,prwc);
                    break;
                }

                sprintf(encode_prefix,"=?%s?Q?",charset[i]);
                if (  ! strncasecmp(encode_prefix,iptr,
                strlen(encode_prefix)) ) {
                    isbqheader=
                    bqheader_decode(&iptr,encode_prefix,Qencode, 
                    fpin,fpout,outCode,prwc);
                    break;
                }
            }  /* end of while loop for a set of charsets  */

/*   if you wish to have the backward compatibility with 
     now obsolete sendmail 8.6.9h1, remove the comment
     for the following if block  */

/*
            strcpy(encode_prefix,"=?B?EUC-KR?=");
            if (  !strncasecmp(encode_prefix,iptr, strlen(encode_prefix)) ) {
                isbqheader=
                bqheader_decode(&iptr,encode_prefix,Bencode, 
                fpin,fpout,outCode,prwc);
            }
*/

            if (  isbqheader != 1 ) {  
                fputc(*iptr++,fpout);
            }
                        
        }  
    } while (ibuf[0]!='\n');
    return(0);
}

extern void pr2m();
extern unsigned long int convk8();

void putSDN(Printwc,fpout,outCode)
unsigned long int Printwc;
FILE *fpout;
int outCode;
{
    static int cp=0;
    unsigned char ibuf[HDR_BUF_LEN],obuf[HDR_BUF_LEN],tbuf[HDR_BUF_LEN];
    unsigned char *iptr, *tptr;

    if ( cp >= HDR_BUF_LEN ) {
        pr2m(Printwc,fpout,outCode);
        return;
    }

    if ( Printwc == '\n' ) {        /* End of Line */
        if ( cp == 0 ) {
            cp = HDR_BUF_LEN;
            fputc('\n',fpout);
            return;
        }
        ibuf[cp++] = '\n';
        ibuf[cp] = NULL;
        cp = 0;
        iptr = ibuf;
        while (*iptr) {
            tptr = tbuf;
            while (*iptr && *iptr<0x80) fputc(*iptr++,fpout);
            while (*iptr && (*iptr>0x80 || *iptr ==' ')) *tptr++ = *iptr++;
            *tptr = NULL;
            if (tbuf[0]!=NULL) {
                string_to_base64(obuf, tbuf);
                fprintf(fpout,"=?EUC-KR?B?%s?=",obuf);
            }
        }
        return;
    }

    if ( Printwc < 0x100 ) {        /* ASC */
        ibuf[cp++] = Printwc;
        return;
    }

    Printwc = convk8(Printwc);        /* NON-ASC */
    if ( (Printwc>>16) == 0x8ffb ) {
        ibuf[cp++] = (Printwc>>8)&0xff;
        ibuf[cp++] = Printwc&0xff;
    } else {
        ibuf[cp++] = 0xa4;
        ibuf[cp++] = (Printwc>>24)&0xff;
        ibuf[cp++] = 0xa4;
        ibuf[cp++] = (Printwc>>16)&0xff;
        ibuf[cp++] = 0xa4;
        ibuf[cp++] = (Printwc>>8)&0xff;
        ibuf[cp++] = 0xa4;
        ibuf[cp++] = Printwc & 0xff;
    }
}

/*
   These subroutines come in bq.c with Hangul Mailing Package SDN/KS
   @(#)bq.c:encode/decode modules    is@ev.trigem.co.kr    1992.7.22

   To compile this subroutine under the sysyem without sys/type.h
   I have copied one line from sys/type.h
    typedef unsigned long   u_long;

   June-Yub Lee at Courant Institute on Dec, 1 , 1992
   jylee@kitty.cims.nyu.edu or jylee@math1.kaist.ac.kr
*/

/* modified by jshin for Q as well as B header deocing */

/* 
   If the encoded word is complete and the decoded string is put out,
   '1' is returned and input pointer *iptr0 is shifted to point to
   the character following the encoded word.  

   Otherwise, return -1 and the pointer *iptr0 is not changed
*/

#define BQ_BUF_SIZE 100

/* buffer size is drastically cut to 100 which seems to be pretty small, but
   RFC 2047 specifies that an encoded word can't be longer than
   75 characters so that it actually is quite generous.
   Feb. 98, J. Shin <jshin@pantheon.yale.edu>
*/

int bqheader_decode(iptr0,prefix,encoding,fpin,fpout,outCode,prwc)
unsigned char **iptr0;
char *prefix;
int  encoding;
FILE *fpin, *fpout;
int outCode;
void (*prwc)();

{


    unsigned char obuf[BQ_BUF_SIZE],tbuf[BQ_BUF_SIZE];
    unsigned char *iptr,*optr, *tptr;
    unsigned long int outwc;

    iptr = *iptr0;

    iptr+=strlen(prefix);
    tptr = tbuf;

/* RFC 2047 section 5 puts a number of restrictions on what can be
   in encoded text. Not being a full-fledged RFC 2047 decoder, hcode 
   only checks if there's any whitespace or '?'.
*/
   
    while (  *iptr && strncmp("?=",iptr,2) && tptr-tbuf < BQ_BUF_SIZE - 2 )  {
         if ( isspace(*iptr) || *iptr == '?' ) break;
         *tptr++ = *iptr++;
    }
    *tptr = NULL;
    if (  ! strncmp("?=",iptr,2) ) {
        iptr+=2;
        if (  encoding == Bencode) 
            base64_to_string(obuf, tbuf);
        else 
            qencode_to_string(obuf, tbuf); 
        optr=obuf;
        for ( ; *optr; optr++) {
            if (*optr>0x80) {
                outwc = 0x8ffb00 + *optr;
                outwc = (outwc<<8) + *(++optr);
            } else {
                outwc = *optr;
            }
            (*prwc)(outwc,fpout,outCode);
        }
        *iptr0 = iptr;
        return 1;
     }
/* bqheader_decode is invoked as the string matches the prefix 
   of the RFC 2047 encoded word, but the suffix for the encoded
   word, '?=' is not found so that  *iptr0 is not changed
   and '-1' is returned to signify that the encoded word
   is not complete
*/
     else      
        return -1;
}


/* In AIX 4.1, this line may have to be commented out to avoid 
   conflict with u_long defined in standard header of AIX 4.1 
   (jshin. Jul, 1996) */

typedef unsigned long   u_long; 


/**** B A S E 6 4 _ T O _ S T R I N G ****/

void base64_to_string(obuf, ibuf)
char *obuf, *ibuf;
{
        register u_long btmp = 0;
        register short int count = 0;

        while (*ibuf)
        {
                if (*ibuf == '+')
                        btmp = (btmp << 6) | 62;
                else if (*ibuf == '/')
                        btmp = (btmp << 6) | 63;
                else if (isdigit(*ibuf))
                        btmp = (btmp << 6) | (52 + *ibuf - '0');
                else if (isupper(*ibuf))
                        btmp = (btmp << 6) | (*ibuf - 'A');
                else if (islower(*ibuf))
                        btmp = (btmp << 6) | (26 + *ibuf - 'a');
                else  /* In case of pad and error. */
                        btmp = (btmp << 6) | 0;

                if (++count >= 4)
                {
                        *obuf++ = (char)((btmp & 0x0ff0000) >> 16);
                        *obuf++ = (char)((btmp & 0x000ff00) >> 8);
                        *obuf++ = (char)(btmp & 0x00000ff);

                        btmp = 0;
                        count = 0;
                }

                ibuf++;
        }

        *obuf = '\0';

        return;
}  /* end of base64_to_string(). */


/**** S T R I N G _ T O _ B A S E 6 4 ****/

#define B64_0                   0x0fc0000
#define B64_1                   0x003f000
#define B64_2                   0x0000fc0
#define B64_3                   0x000003f
#define PAD                     64

static char *b64_alphabet =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

void string_to_base64(obuf, ibuf)
char *obuf, *ibuf;
{
        register u_long btmp;
        register short int i, count;

        while (*ibuf)
        {
                for (i = count = 0, btmp = 0; i < 3; i++)
                        if (*ibuf)
                        {
                                btmp = (btmp << 8) | (u_long)(*ibuf++ & 0x0ff);
                                count++;
                        }
                        else
                                btmp = (btmp << 8) | (u_long)0;

                *obuf++ = b64_alphabet[(B64_0 & btmp) >> 18];
                *obuf++ = b64_alphabet[(B64_1 & btmp) >> 12];
                *obuf++ = b64_alphabet[count >= 2 ? (B64_2 & btmp) >> 6 : PAD];
                *obuf++ = b64_alphabet[count == 3 ? (B64_3 & btmp) : PAD];
        }

        *obuf = '\0';
        return;

}  /* end of string_to_base64(). */


void qencode_to_string(obuf, ibuf)
char *obuf, *ibuf;
{
    
    while ( *ibuf ) {
        if ( *ibuf == '_' ) 
            *obuf++ = ' ';
        else if ( *ibuf == '=' ) {
            *obuf = ( *(ibuf+1) - ( *(ibuf+1) > '9' ? 
                'A'-'9' - 1 : 0 ) - '0'  ) * 16;

            *obuf +=  *(ibuf+2) - ( *(ibuf+2) > '9' ? 
                'A'-'9' - 1 : 0 ) - '0'  ; 
            ibuf+=2;
                        obuf++;
        }
        else 
            *obuf++=*ibuf;
        ibuf++;
    }
            
    *obuf = '\0';
    return;
}

/* not done, yet */
/* void header_switch(iptr0,fpout,name_len) */
void header_switch(iptr,fpout)
/* unsigned char **iptr0; */
unsigned char *iptr; 
FILE *fpout;
/* int  name_len; */
{


/*   while ( name_len--  > 0 )
        fputc(*iptr++,fpout);     */

    while ( *iptr ) 
        if ( ! strncasecmp("iso-2022-kr",iptr,11) ) {
           iptr+= 11;
           fprintf (fpout,"EUC-KR"); 
        }
        else if ( ! strncasecmp("7bit",iptr,4) ) {
           iptr+=4;
           fprintf(fpout,"8bit"); 
        } else
           fputc(*iptr++,fpout);
          
}
