/* ***********************************************************
 Program : Hangul Code Conversion Program
 Author :  June-Yub Lee (jylee@kitty.cims.nyu.edu:jylee@math1.kaist.ac.kr)
 Created : Jan, 07, 1992
 Modified : Ver. 1.1  Feb, 29, 1992 
 Modified : Ver. 1.2  Oct, 03, 1992
 Modified : Ver. 2.0  Dec, 06, 1992
 Modified : Ver. 2.1  Sep, 18, 1994

 This Program is free software under the GNU General Public License.
 If you are installing this program for your own work or other users,
 please send me a e-mail so that I can fix any possible bug and
 update for new Hangul Code including UNICODE.
************************************************************ */

#include <stdio.h>
#include <strings.h>
#include "hcode.h"

extern void pr2m();
extern void pr3b();
extern void putSDN();
extern unsigned long int gettr();
extern unsigned long int getks();
extern unsigned long int getiso();
extern unsigned long int getnb();
extern void opt_check();
extern void rmprolog();
extern int rmSDNheader();
extern int putprolog(); 

int inNB;
int prstat=PRNONE;

int mailfilter=0;         /* return 0 if mailfilter=1 to work with
                             procmail,Pine and other programs to expect
                             0 on success from filtering programs. jshin */
char *basename();        /* strips  directory */

main(argc,argv)
int argc;
char *argv[];
{
	int inCode, outCode;
	FILE *fpin, *fpout;
	void (*prwc)();
	unsigned char c;
	unsigned long int (*getwc)();
	unsigned long int PrintChar=0;
        int isheadonly=0;
        int iseof=0;

	opt_check(argc,argv,&inCode,&outCode, &fpin, &fpout);

	if ( outCode >= NB ) {
		prwc = pr3b;
	} else if ( outCode == SD ) {
		prwc = putSDN;
	} else {
		prwc = pr2m;
	}

	if ( inCode == KS || inCode == H3 ) {
		getwc = getks;
                if ( outCode == IS && inCode == KS )
	            iseof = putprolog(fpin,fpout);                
	}
	else if ( inCode == TR)
		getwc = gettr;
	else if ( inCode == IS ) {
		getwc = getiso;
		rmprolog("\033$)C",fpin,fpout);
	} else if ( inCode == SD) {
		getwc = getiso;
		if ( ! (isheadonly=rmSDNheader(fpin,fpout,outCode,prwc)) )
		    rmprolog("\033$)C",fpin,fpout);
	} else if ( inCode >= NB ) {
		getwc = getnb;
		inNB = inCode - NB;
	} 

                
		
    if ( ! isheadonly && ! iseof ) 
        while (  (c=getc(fpin)) != (unsigned char) EOF ) {
       	    PrintChar = (*getwc)(c);
	    if ( PrintChar != 0 ) (*prwc)(PrintChar,fpout,outCode);
	    PrintChar = 0;
        }

/* Error Codes */

	if ( fpin != stdin) fclose(fpin);
	if ( fpout != stdout) fclose(fpout);
        if ( mailfilter == 0 )
	    return( inCode*(prstat==PRINTED||prstat==PRINTING) );
        else
            return 0;
}

/* ------------------------------------------------------
	Command Line Option Check Routine
	Two integes Return : inCode and outCode
	Two file pointer   : fhin, fhout
	Defaults : from_IS, to_KS, stdin, stdout;
  ------------------------------------------------------- */

void opt_check(argc, argv, inCode, outCode, fhin, fhout)
char *argv[];
FILE **fhin, **fhout;
int argc, *inCode, *outCode;
{
	char *program;
	*inCode = InDEF;
	*outCode = OutDEF;
        program= (program=strrchr(argv[0],'/')) == NULL ? argv[0] : program+1 ;
              /* strip off directories and leave only basename. jshin */ 
  
	while (--argc) {
		argv++;
		if ( argv[0][0]!='-' || argv[0][1]=='\0' ) {
			break;
		} else if ( argv[0][2]=='\0' ) {
                        if ( argv[0][1]== '?' ) {
			    fprintf(stderr,"Usage: %s %s\n",program,syn);
			    exit(-1);
                        } else if ( argv[0][1] == 'm' ) 
                            mailfilter=1;
                        else 
			    *inCode = in_choice [ tolower(argv[0][1])-'a' ];
		} else if ( argv[0][3]=='\0' ) {
			*inCode = in_choice [ tolower(argv[0][1])-'a' ];
			*outCode = out_choice [ tolower(argv[0][2])-'a' ];
		} else  {
			fprintf(stderr,"Usage: %s %s\n",program,syn);
			exit(-1);
		}
		if ( *inCode == 0 ) {
			fprintf(stderr,"Unknown InCode: %s %s\n",program,syn);
			exit(-1);
		} else if ( *outCode == 0 ) {
			fprintf(stderr,"Unknown OutCode: %s %s\n",program,syn);
			exit(-1);
		}
	}

	*fhin = stdin;
	*fhout = stdout;
	if ( argc > 2 ) {
		fprintf(stderr,"Unknown Syntax: %s %s\n",program,syn);
		exit(-1);
	} else if ( argc == 2 ) {
		if ( argv[0][0]!='-' && (*fhin=fopen(argv[0],"r"))==NULL ) {
   			fprintf(stderr,"%s: Read Err on %s\n",program,argv[0]);
   			exit(1);
		}
		if ( (*fhout=fopen(argv[1],"w")) == NULL ) {
   			fprintf(stderr,"%s: Write Err on %s\n",program,argv[1]);
   			exit(1);
		}
	} else if ( argc == 1 ) {
		if ( argv[0][0]!='-' && (*fhin=fopen(argv[0],"r"))==NULL ) {
   			fprintf(stderr,"%s: Read Err on %s\n",program,argv[0]);
   			exit(1);
		}
	}
}

