/***************************************************************************
                          Action.cxx  -  Event engine implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <assert.h>
#include "sysdep.h"
#include "Action.h" //PORT: set to be last, for it uses strlen first time.


Action::Action(Screen& screen) : screen(screen), lastChar(0), table(screen)
{
}

#define KEYBOARD_CHARS "1234567890-=!@#$%^&*()_+qwertyuiop[]QWERTYUIOP{}" \
                       "asdfghjkl;\'`ASDFGHJKL:\"~\\|" \
                       "zxcvbnm,./ZXCVBNM<>? "

aString&
Action::getActionKeyBinding(Action::Actions act, int whichone)
{
  static aString res = "" ;

  for (int i=0; i<table.get_size() ; i++) {
    if (table[i].getAction() == act) {
      if (!whichone) {
        res = table[i].sequenceAsString(screen) ;
        return res ;
      }
      whichone-- ;
    }
  }
  res = "" ;
  return res ;
}

Action::Actions
Action::getNextAction()
{
  Actions action = Null ;
  int i , matchPrefix = 1;
  aString message;
  Array<int> prefix ;

  while (matchPrefix && (action == Null)) {
    if (prefix.get_size()) {
      screen.Message((char *)(const char*)message) ;
      screen.Refresh() ;
    }

    lastChar = screen.GetCh() ; // when moving to a graphical environment
                                // screen.GetCh() will be the actual message loop
    prefix.append(&lastChar,1) ;
    message += screen.KeyName(lastChar) ;

    matchPrefix = 0 ;
    for (i=0 ; (i<table.get_size()) && (action == Null) ; i++) {
      matchPrefix += table[i].matchPrefix(prefix) ;
      action = table[i].match(prefix) ;
    }
  }
  if (!matchPrefix && (prefix.get_size() == 1))
    if (strchr(KEYBOARD_CHARS, lastChar) && (char)(lastChar))
      action = Char ;
  return action ;
}

int
Action::getLastChar()
{
  return lastChar ;
}

Action::Translation::Translation(Action::Translation& t) :
        keySequence(t.keySequence),
        action(t.action)
{
}

Action::Translation::Translation() :  action(Action::Null)
{
}

Action::Translation::Translation(translation_st &t) :
         action(t.action)
{
  int i=0 ;
  while (t.keySeq[i])
    keySequence.append( t.keySeq[i++] ) ;
}

Action::Actions
Action::Translation::match(Array<int> &keySeq)
{
  int m = 1 , i;
  if (keySeq.get_size() == keySequence.get_size()) {
    for (i=0; (i<keySeq.get_size()) && m ; i++)
      if (keySeq[i] != keySequence[i])
        m = 0 ;
    if (m)
      return action ;
  }
  return Null ;
}

int
Action::Translation::matchPrefix(Array<int> &keySeq)
{
  if (keySeq.get_size() <= keySequence.get_size()) {
    int m=1 , i;
    for (i=0 ; (i < keySeq.get_size() ) && m ; i++)
      if (keySeq[i] != keySequence[i])
        m=0 ;
    return m ;
  }
  return 0 ;
}

Action::Translation&
Action::Translation::operator=(Action::Translation &t)
{
  keySequence = t.keySequence ;
  action = t.action ;
  return *this; //PORT: added
}

aString
Action::Translation::sequenceAsString(Screen& screen)
{
  aString res ;

  for (int i =0 ; i < keySequence.get_size() ; i++)
      res += screen.KeyName(keySequence[i]) ;
  return res ;
}


Action::TranslateTable::TranslateTable(Screen &screen)
{
  translation_st default_mappings[] = {
  { { 27, '6', 0}, Action::GotoLine }, // ESC-6
  { { 1,0}, Action::Home           }, // ^A
  { { 5,0}, Action::End            },  // ^E
  { { 27,'p',0},Action::PgUp           },
  { { 27,'P',0},Action::PgUp           },
  { { 27,'n',0},Action::PgDn           },
  { { 27,'N',0},Action::PgDn           },
  { { 25,0}, Action::DeleteLine     },  // ^Y
  { {  4,0}, Action::DeleteChar     },  // ^D
  { { '',0}, Action::DeleteChar     }, //
//  { {'',0}, Action::BackSpace      }, // ?
  { { 8,0}, Action::BackSpace      }, // ^H
  { { 11, 2,0}, Action::MarkBlockBegin         }, // ^K^B
  { { 11, 11,0}, Action::MarkBlockEnd         }, // ^K^K
  { { 11, 5,0}, Action::MarkBlockEnd         }, // ^K^E
  { { 11,21,0}, Action::UnmarkBlock         },  // ^K^U
  { { 11, 8,0}, Action::UnmarkBlock         },  // ^K^H
  { { 11, 3,0}, Action::CopyBlock         },  // ^K^C
  { { 11, 4,0}, Action::DeleteBlock         }, // ^K^D
  { { 11,22,0}, Action::MoveBlock         }, // ^K^V
  { { 11,'\r',0}, Action::MoveBlock         }, // ^K^M
  { { 24, 6,0}, Action::LoadFile         },   // ^X^F
  { { 24, 23,0}, Action::SaveFileAs         }, // ^X^W
  { { 24,  7, 0}, Action::GotoLine }, // ^X^G
  { { 24,'b',0}, Action::NextBuffer         }, // ^Xb
  { { 24,'B',0}, Action::NextBuffer         }, // ^XB
  { { 27, 't', 0}, Action::SpellLearnAllWords }, // ESC-t
  { { 20, 0}, Action::SpellWord }, // ESC-t

// menus
  { { 27, '0' ,0}, Action::MainMenu }, // ESC-0
//  { {'.','[','2','2','~',0}, Action::MainMenu }, // F10
  { { 27, 27,'f',0}, Action::FileMenu }, // F10
  { { 27, 27,'e',0}, Action::EditMenu }, // F10
  { { 27, 27,'s',0}, Action::SearchMenu }, // F10

  { { 27,'l',0}, Action::LaTeX }, // ESC-l
  { { 24, 12,0}, Action::LaTeX }, // ^X^L

  { { 27, 'x',0}, Action::DviView }, // ESC-x
  { { 24, 24,0}, Action::DviView }, // ^X^X

  { { 24, 13,0}, Action::MathSymbolsView         }, // ^X^M

  { { 27, 27, 'l', 0}, Action::LaTeXMenu}, //ESC-ESC-l

  { { 7, 0}, Action::BufferList         }, // ^G
  { { 24, 2,0}, Action::BufferList         }, // ^X^B

  { { 27,'@',0}, Action::NextBuffer         }, //ESC-@ (like F12)
  { { 27,'[','2','4','~',0}, Action::NextBuffer },  //F12 on xterm
  { { 27,'!',0} , Action::PreviousBuffer } ,  // ESC-! (like F11)
  { { 27,'[','2','3','~',0}, Action::PreviousBuffer },  // F11 on xterm
  { { 26,0}, Action::Suspend        }, // ^Z
  { { 14,0}, Action::NextLine       }, // ^N
  { { 16,0}, Action::PreviousLine   }, // ^P

  { { 23,0}, Action::ToggleLanguage }, // ^W
  { { 27,'w',0}, Action::ChangeDirection }, //  ESC-W
  { { 27,'W',0}, Action::ChangeDirection }, // ESC-W

  { { 27, 6,0}, Action::NextLogicalWord    }, // ESC-^F
  { { 27, 2,0}, Action::PreviousLogicalWord   }, // ESC-^B
  { {  6, 0}, Action::RealForwardChar    }, // ^F
  { {  2, 0}, Action::RealBackwardChar   }, // ^B
  { { 11,23,0}, Action::SaveFile     }, // ^K^W
  { { 24,19,0}, Action::SaveFile     }, // ^X^S -not useable on terminals or OS/2, since ^S is XOFF
  { { 12,0}, Action::Refresh        }, // ^L
  { { '\r',0}, Action::NewLine        }, //^M
  { { '\n',0}, Action::NonIndentingNewLine        }, //^J
  { { 27,'a',0}, Action::BeginningOfFile }, // ESC-a
  { { 27, 27,'7',0}, Action::BeginningOfFile }, // ESC-ESC-7
  { { 27,'A',0}, Action::BeginningOfFile }, // ESC-A
  { { 27,'e',0}, Action::EndOfFile }, // ESC-e
  { { 27,'E',0}, Action::EndOfFile }, // ESC-E
  { { 27, 27,'8',0}, Action::EndOfFile     }, // ESC-ESC-8
  { { 27,'h',0}, Action::Help  }, // ESC-h
  { { 27,8,0}, Action::LaxetCommandHelp  }, // ESC-^h
  { { 27,'O','P',0}, Action::Help  }, // ESC-O-P  (PF1 on vt terminals)
  { { 27,'[','2','8','~',0}, Action::Help }, // ESC-[-2-8-~  (help key on vt320?)
//  { {screen.ENTER,0}, Action::NewLine        },
  { { 27,'1',0}, Action::Help    }, // ESC-1
  { { 27,'2',0}, Action::SaveFile     }, // ESC-2
  { { 27,'O','Q',0}, Action::SaveFile     },  // ESC-O-Q (PF2 on vt terminals)
  { { 27,'[','D',0}, Action::BackwardChar   }, // ESC-[-D  (Left key on vt terminals)
  { { 27,'[','C',0}, Action::ForwardChar    }, // ESC-[-C (Right key on vt terminals)

  { { 27, 27,'[','D',0}, Action::WordLeft   }, // ESC-[-D  (Left key on vt terminals)
  { { 27, 27,'[','C',0}, Action::WordRight    }, // ESC-[-C (Right key on vt terminals)

  { { 27,'s',0}, Action::Find }, //ESC-s
//  { {'.','S',0}, Action::Find }, //ESC-S
  { { 27,'r',0}, Action::FindReplace }, //ESC-r
//  { {'.','R',0}, Action::FindReplace }, //ESC-R

  { { 21,0},Action::Undo  },
  { { 27,'9',0},Action::Undo  },
  { { 27, 21, 0}, Action::Redo } , //ESC-^U
  { { 27, 27,'9', 0}, Action::Redo } , //ESC-F9


  { { 27,'[','A',0}, Action::PreviousLine   }, // ESC-[-A (Up key)
  { { 27,'[','B',0}, Action::NextLine       } , // ESC-[-B (Down key)

  { { 24, 3,0}, Action::Exit         },             // ^X^C
  { { 27,'3',0}, Action::Exit         },
  { { 24, 11,0}, Action::Exit         }, // ^K^X
  { { 27,'O','R',0}, Action::Exit         },

  { { 27,'[','6','~',0},Action::PgDn           },
  { { 27,'8',0},Action::PgDn           },
  { { 27,'7',0},Action::PgUp           },
  { { 27,'[','5','~',0},Action::PgUp           },
} ;
  assert(sizeof(translation_st) != 0) ;
  _addSpecial(screen) ;
  if (!_addUserKeys(screen)) {
  int siz = sizeof(default_mappings)/sizeof(translation_st) ;
  int i ;
  Array<Translation> a1 ;
  for (i=0 ; i< siz/2 ; i++) {
    Translation t(default_mappings[i]) ;
    a1.append(&t,1) ;
  }
  Array<Translation> a2 ;
  for (; i< siz ; i++) {
    Translation t(default_mappings[i]) ;
    a2.append(&t,1) ;
  }
  append(a1) ;
  append(a2) ;
  }
}


#define STRING 187645
#define ERROR  187646
#define ENDOFLINE 187647
#define ENDOFINPUT 187648

#include "lex.yy.h"

int
Action::TranslateTable::_addUserKeys(Screen& screen) {
  int nextToken ;
  char msg[100] ;
  Actions currentCommand ;
  currentCommand = Action::Null ;

  Array<Translation> fr ;

  FILE *fo = fopen(KEY_BINDINGS_FILE,"r") ;
  char *hercname = strdup(KEY_BINDINGS_FILE) ;
  if (!fo) {
    char *homet = getenv("HOME") ;
    char *herc = new char [strlen(homet)+2+strlen(KEY_BINDINGS_FILE)] ;
    strcpy(herc, homet) ;
    if (herc[strlen(herc)-1]!='/') {
        strcat(herc, "/") ;
    } /* endif */
    strcat(herc,KEY_BINDINGS_FILE) ;
    delete hercname ;
    hercname = herc ;
    fo = fopen(herc, "r") ;
  }
  // no file in the local directory, and neither in the home directory
  // so let's load the file in he2's data directory
  if (!fo) {
     char *hedir = getenv("HEDIR") ;
     if (hedir) {
        char *herc = new char [strlen(hedir)+2+strlen(KEY_BINDINGS_FILE)] ;
        strcpy(herc, hedir) ;
        if (herc[strlen(herc)-1]!='/') {
           strcat(herc, "/") ;
        } /* endif */
        strcat(herc,KEY_BINDINGS_FILE) ;
        delete hercname ;
        hercname = herc ;
        fo = fopen(herc, "r") ;
     }
  }
  if (fo) {
     yyrestart( fo ) ;
     yyinitme() ;
     while ((nextToken = yylex()) != ENDOFINPUT) {
        if (nextToken == ERROR) {
           sprintf(msg,"Lexical error in file %s on %c (line %d)\n\n",hercname,
                 *yytext,
                 linecount+1) ;
           screen.MVAddStr(5,2,msg) ;
           screen.Refresh() ;
           screen.GetCh() ;
           exit(1) ;
        } else
           if (nextToken == STRING) {
              if (currentCommand > 0) {
                 translation_st tr ;
                 init_translation_st(tr, strseq, currentCommand) ;
                 Translation  t(tr) ;
                 fr.append(&t, 1) ;
              } else {
                 sprintf(msg,"Missing operation name in file %s (line %d)\n\n",
                       hercname, linecount+1) ;
                 screen.MVAddStr(5,2,msg) ;
                 screen.GetCh() ;
                 exit(1) ;
              }
           } else
              if (nextToken == ENDOFLINE) {
                 currentCommand = Action::Null ;
              } else {
                 // if returned Action::something
                 currentCommand = (Action::Actions)nextToken ;
              }
     }
     fclose(fo) ;
     append(fr) ;
     delete hercname ;
     return 1 ;
  }
  delete hercname ;
  return 0 ;
}

void
Action::TranslateTable::_addSpecial(Screen &screen)
{
  translation_st default_mappings[] = {
  { { 27, 't', 0}, Action::SpellLearnAllWords }, // ESC-t
  { { 20, 0}, Action::SpellWord }, // ESC-t
  { {screen.TAB, 0}, Action::Tab }, // Tab
  { {screen.F6,0}, Action::GotoLine  },
  { {screen.F10,0}, Action::MainMenu }, // F10
  { {screen.F12,0}, Action::NextBuffer } , //F12
  {{screen.F11,0}, Action::PreviousBuffer } , // F11
  { { 27,screen.PPAGE,0}, Action::BeginningOfFile }, // ESC-PgUp
  { { 27,screen.F7,0}, Action::BeginningOfFile }, // ESC-F7
  { { 27, screen.HOME,0}, Action::BeginningOfFile }, // ESC-Home
  { { 27,screen.NPAGE,0}, Action::EndOfFile     }, // ESC-PgDn
  { { 27,screen.F8,0}, Action::EndOfFile     }, // ESC-F8
  { { 27,screen.END,0}, Action::EndOfFile     }, // ESC-End
  { {screen.REFRESH,0}, Action::Refresh        },
  { {screen.F1,0}, Action::Help    },
  { {screen.F2,0}, Action::SaveFile     },
  { {screen.SAVE,0}, Action::SaveFile     },
  { {screen.LEFT,0}, Action::BackwardChar   },
  { {screen.RIGHT,0}, Action::ForwardChar    },
  { { 27,screen.LEFT,0}, Action::WordLeft   },
  { { 27,screen.RIGHT,0}, Action::WordRight    },
  { {screen.F9,0},Action::Undo  },
  { {screen.UP,0}, Action::PreviousLine   },
  { {screen.DOWN,0}, Action::NextLine       } ,
  { {screen.SUSPEND,0}, Action::Suspend        },
  { {screen.F3,0}, Action::Exit         },
  { {screen.EXIT,0}, Action::Exit         },
  { {screen.BACKSPACE,0}, Action::BackSpace      },
  { {screen.DC,0}, Action::DeleteChar     },
  { {screen.DL,0}, Action::DeleteLine     },
  { { 27, screen.F9, 0}, Action::Redo } , //ESC-F9
  { {screen.NPAGE,0},Action::PgDn           },
  { { 27,screen.DOWN,0},Action::PgDn           },
  { {screen.F8,0},Action::PgDn           },
  { {screen.PPAGE,0},Action::PgUp           },
  { {screen.F7,0},Action::PgUp           },
  { { 27,screen.UP,0},Action::PgUp           },
  { {screen.END,0}, Action::End            },
  { {screen.HOME,0}, Action::Home       }
} ;
  assert(sizeof(translation_st) != 0) ;
  int siz = sizeof(default_mappings)/sizeof(translation_st) ;
  int i ;
  Array<Translation> a1 ;
  for (i=0 ; i< siz/2 ; i++) {
    Translation t(default_mappings[i]) ;
    a1.append(&t,1) ;
  }
  Array<Translation> a2 ;
  for (; i< siz ; i++) {
    Translation t(default_mappings[i]) ;
    a2.append(&t,1) ;
  }
  append(a1) ;
  append(a2) ;
}
