/***************************************************************************
                          Action.h  -  Event engine declaration
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __Action_h__
#define __Action_h__
#include "Array.h"
#include "Screen.h"
#include "aString.h"

#define MAX_KEYS 7

class Action {
private:
   Screen& screen ;

public:
   Action(Screen& screen) ;
   enum Actions {
       Null, // no legal action has been identified
       Home, End, PgUp, PgDn, Tab, Char, DeleteLine, DeleteChar, BackSpace, Help, LaxetCommandHelp,
       Exit, Suspend, NextLine, PreviousLine, ToggleLanguage, ChangeDirection,
       RealForwardChar, RealBackwardChar, ForwardChar, BackwardChar,
       Left, Right, Refresh,
       NewLine, NonIndentingNewLine, BeginningOfFile, EndOfFile,
       WordRight, WordLeft, NextLogicalWord, PreviousLogicalWord, Undo, Redo,
       // some more actions
       LaTeX, DviView, MathSymbolsView,
       // Block actions
       MarkBlockBegin, MarkBlockEnd, CopyBlock, MoveBlock, DeleteBlock, UnmarkBlock,
//       HideBlockMark, ReadBlockFrom, WriteBlockTo,
       // Buffer actions
       NextBuffer, PreviousBuffer,
       LoadFile, SaveFile, SaveFileAs, BufferList,
       // Menu operations
       MainMenu, FileMenu, EditMenu, LaTeXMenu, SearchMenu, OptionsMenu, HelpMenu,
       // Search & replace
       Find, FindNextForward, FindNextBackward, FindReplace, GotoLine,
       FindReplaceQuery,
       SpellLearnAllWords , SpellWord} ;
   Actions getNextAction() ; // interacts with the keyboard
   // use whichone = 0 for first
   aString& getActionKeyBinding(Action::Actions act, int whichone=0) ;
//   aString getActionSecondKeyBinding(Action::Actions act) ;
   int getLastChar() ;
private:
   struct translation_st {
     int keySeq[MAX_KEYS] ; // allow at max a MAX_KEYS sequence key
     Actions action ;
   } ;
   class Translation {
       Array<int> keySequence ;
       Actions action ;
   public:
       Translation(Translation &) ;
       Translation() ;
       Translation(translation_st &) ;
       Actions match(Array<int> &keySeq ) ;
       Actions getAction() { return action ; }
       aString sequenceAsString(Screen &screen) ;
       int matchPrefix(Array<int> &prefix) ;
       Translation& operator=(Translation &) ;
   } ;
   class TranslateTable : public Array<Translation>
   {
   public:
       TranslateTable(Screen &screen) ; // default translate table
   private:
       int _addUserKeys(Screen &screen) ;
       void _addSpecial(Screen &screen) ;
       void init_translation_st(translation_st &st,char *str, Action::Actions act) {
        int i=0 ;
        while ((st.keySeq[i++]=(int)*str++) != 0) ;
        st.action = act ;
   }
   } ;
   int lastChar ;
   TranslateTable table ;
} ;

#endif
