/***************************************************************************
                          Array.h - flexible array handling template class
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __Array_h__
#define __Array_h__

#define CONSTRUCT_FROM(a,typ)     a,(sizeof(a)/sizeof(typ))

template <class T>
class Array {
   T *mem ;
   int size ;
   int maxsize ;
public:
   T invalidElement ;
   int get_size() { return size ; } ;
   Array<T>& operator=(Array<T> a)
   {
      if (!maxsize)
        if (size) delete mem ;
      size = a.size ;
      if (!maxsize)
        mem = new T[size] ;
      for (int i=0; i<size; i++)
          mem[i] = a[i] ;
      return (*this) ;
   }

   void clear()
   {
      if (!maxsize)
        if (size) delete mem ;
      size = 0 ;
   }
   // Add destructor for array , to handle memory leakage 18/4/97
   //~Array() { if (size && mem) delete mem ; }

   Array(int maxsize) : size(0), maxsize(maxsize) {
      mem = new T[maxsize] ;
   }

   Array() : mem(0), size(0), maxsize(0) {}

   Array(T *a, int size) : size(size), maxsize(0)
   {
      mem = new T[size] ;
      for (int i=0; i<size; i++)
          mem[i]=a[i] ;
   }

   Array(Array<T> &a) : size(a.get_size()), maxsize(0)
   {
      mem = new T[size] ;
      for (int i=0; i<size; i++)
          mem[i]=a[i] ;
   }

   T& operator[](int at)
   {
      if (at < size)
         return mem[at] ;
      return invalidElement ;
   }

   void append(T *a, int _size)
   {
      T *new_mem  ;
      if (!maxsize)
        new_mem = new T[size + _size] ;
      else new_mem = mem ;
      int i ;

      if (!maxsize)
        for (i=0; i<size; i++)
           new_mem[i] = mem[i] ;
      for (i=0;i<_size; i++)
         new_mem[i+size] = a[i] ;

      if (!maxsize)
        if (size) delete mem ;
      mem = new_mem ;
      size += _size ;
   }

   void append(Array<T> a)
   {
      append(a.mem, a.size) ;
   }

   void append(T v)
   {
      append(&v, 1) ;
   }

   void prepend(T *a, int _size)
   {
      T *new_mem ;
      if (!maxsize)
        new_mem = new T[size + _size] ;
      else
        new_mem = mem ;

      int i ;
      if (size)
      for (i=size-1;i>=0 ;i-- ) {
         new_mem[i+_size] = mem[i] ;
      } /* endfor */
      for (i=0; i<_size; i++)
         new_mem[i] = a[i] ;
      if (!maxsize)
        if (size) delete mem ;
      mem = new_mem ;
      size += _size ;
   }

   void prepend(Array<T> a)
   {
      prepend(a.mem, a.size) ;
   }

   void prepend(T v)
   {
      prepend(&v, 1) ;
   }

} ;

#endif
