/***************************************************************************
                          CursesScreen.cxx - a curses based Screen implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __CursesScreen_h__
#define __CursesScreen_h__
#include "Screen.h"
//#include "curses.h"

#define SPECIAL_SEPARATOR '\267'
#define LEFT_END_MARK '\253'
#define RIGHT_END_MARK '\273'

struct CursesWindow {
 int nlines, ncols, begin_y, begin_x ;
 int border ;
 CursesWindow(int nlines, int ncols, int begin_y, int begin_x, int border) :
     nlines(nlines), ncols(ncols), begin_y(begin_y),begin_x(begin_x), 
     border(border) {}
} ;



class CursesScreen : public Screen {
// a handler of virtual screen for unix systems
   int rows, cols ;
   int colors_enabled ;
   int hardy, hardx ;
public:
   CursesScreen(int hebrew_location, int alternate_hebrew_location) ;
   virtual ~CursesScreen() ;
   void TemporaryExit(int justrefresh=0, char *cmd=0, int background=0) ;
   void Suspend() ;
   void GetMaxYX(int *y, int *x, int wh=0) ;
   void Erase(int wh=0, int flip_reverse=0) ;
   void Refresh(int wh=0) ;
   void MVAddStr(int y, int x, char *str, int wh=0) ;
   void Move(int y, int x, int wh=0) ;
   void DeleteLn(int wh=0) ; /* delete the current line */
   void InsertLn(int wh=0) ; /* inserts a line at cursor */
   int  GetCh() ;    /* get next character from input , interactive */
   char *KeyName(int c) ; /* return the name of key c */
   int getLastLineNum() { return rows - 1 ; }
   int getWidth() { return cols ; }
   int allocateNewWindow(int nlines, int ncols, int begin_y, int begin_x, int brdr) ;
   void closeAllocatedWindow(int wh) ;
   void setWindowTopTitle(char *str, int wh) ;
} ;

#endif

