/***************************************************************************
                          Edit.cxx - The main Editor implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#ifndef WIN32
#       include <unistd.h> //PORT:
#endif
#include <signal.h>
#include <stdio.h>
#include <assert.h>
#include "Edit.h"
#include "Action.h"
#include <stdlib.h>
#include "langdep.h"
#include "HebrewEditor.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#include "LineEdit.h"

char
Edit::buffer[MAX_SCREEN_WIDTH] ;
char
Edit::buffer2[MAX_SCREEN_WIDTH] ;


///////////////////////////////////////////////////////
////  AUXILIARY FUNCTIONS
///////////////////////////////////////////////////////



void
Edit::_markBlock(int copy_to_scratch)
{
  _markBlock(file.getStartMarker(), file.getEndMarker(), copy_to_scratch) ;
}

void
Edit::_markBlock(Marker startm, Marker endm, int copy_to_scratch)
{
   if (!copy_to_scratch) return ;

          if ((startm.line > 0) && (endm.line > 0) &&
                      ((endm.line > startm.line) || ((endm.line == startm.line) && (endm.offset > startm.offset))) ) {
           int curline = current_line ;
           if (he->scratch->from)
             if (he->scratch->from != this)
                he->scratch->from->file.unmarkBlock() ;
           if (!read_only)
              he->scratch->from = this ;
           else
              he->scratch->from = (Edit *)0 ;

           he->scratch->file.eraseContent() ;
           he->scratch->current_offset = 0 ; he->scratch->curx = 1 ; he->scratch->current_line = 1 ;

            if (startm.line == endm.line) {
              aString tmp = ((aString &)(file.line(startm.line))).at(startm.offset, endm.offset) ;
             (aString &)(he->scratch->file.line(1)) = tmp  ;
           } else {
              int cl=1 ;
              aString tmp = ((aString &)(file.line(startm.line))).at(startm.offset, ((aString &)(file.line(startm.line))).length()) ;
             (aString &)(he->scratch->file.line(cl)) = tmp  ;
             for (int l = startm.line+1; l < endm.line ; l++) {
                   tmp = (aString &)(file.line(l)) ;
                   he->scratch->file.insert_after(cl++, (char *)(const char *)tmp) ;
             }
             (aString &)tmp = ((aString &)(file.line(endm.line))).at(0, endm.offset) ;
             he->scratch->file.insert_after(cl++,(char *)(const char *)tmp) ;
             he->scratch->file.line(1) ;
             he->scratch->current_offset = 0 ; he->scratch->curx = 1 ; he->scratch->current_line = 1 ;
          }
//          he->scratch->file.recompile_file(sizex) ;
//          he->scratch->_relocate_curx(0) ;
//          he->scratch->modified = 1 ;
//          he->scratch->_calc_curx() ;
          file.line(curline) ;
          } else {
           he->scratch->file.eraseContent() ;
           he->scratch->current_offset = 0 ; he->scratch->curx = 1 ; he->scratch->current_line = 1 ;
//          he->scratch->file.recompile_file(sizex) ;
//          he->scratch->_relocate_curx(0) ;
//          he->scratch->modified = 1 ;
//          he->scratch->_calc_curx() ;
          }
}



int
Edit::_x_pos()
{
    return _x_position ;
}

char*
Edit::_newline()
{
   static aString data ;
   data = " \n" ;
   file.line(current_line)._insert_ch(curx,current_offset,input.translate_char(' '), _x_position) ;
   _relocate_curx(1) ;
   file.insert_after(current_line, (file.line(current_line)).split(curx)) ;
   file.recompile_section(sizex) ;
     if (current_offset >= file.line(current_line).line_count(sizex)) cury-- ;
     _relocate_curx(0) ;

    int tmp=current_line ;   /////// TAKE CARE OF AUTOINDENT
    int margin = (file.line(tmp-1)).getMargin() + MARGIN_FIX ;
    if (margin < 0) margin = 0 ;
    if (margin > sizex/2) margin = sizex/2 ;
    aString tmpstr = (aString &)(file.line(tmp)) ;
    aString tmprep = areplicate(' ', margin) ;
    data += tmprep ;
    (aString& )(file.line(tmp)) = tmprep + tmpstr ;
    file.recompile_section(sizex) ;
   for (int i=0; i<margin; i++) _relocate_curx(1) ;
   return (char *)(const char *)data ;
}

void
Edit::_maketitle(int show)
{
   input.set_mode(keyboard_mode) ;
   if (show) {
     aString kbmode = "(English)" ;
     aString Modified = "(modified)" ;
     char buff[1000] ;
     if (keyboard_mode == hebrew)
       kbmode="(Hebrew) " ;
     if (!undo.is_modified()) Modified = " " ;
     sprintf(buff,"%10s Line: %5d  Column: %5d  %s #%s", (const char *)Modified,
           current_line, curx, (const char *)kbmode,
           (const char *)name) ;
     for (int i=strlen(buff) ; i<sizex ; i++)
        strcat(buff," ") ;
     win->BottomTitleStr(buff) ;
  }
}

void
Edit::_quite_refresh()
{
   _display_line(cury) ;
}

void
Edit::_refresh()
{
   aString emptyline = areplicate(' ',sizex) ;
   int i ;
   _maketitle() ;
   for (i=1 ; (i <= sizey) /*&& (i <= file.lines())*/ ; i++)
      _display_line(i) ;
   for (; i <= sizey ; i++)
      win->MVAddStr(i-1+screen_start_line,screen_start_column,(char *)(const char *)emptyline) ;
   win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
   win->scr->Refresh() ;
   win->Refresh() ;
}
void

Edit::_scroll(int lines, int refresh_flag)
{
  if (lines < 0) {
     for (int i=0; i< -lines; i++) {
        if (_line_to_display(sizey+1)) {
           if (refresh_flag) {
             win->Move(screen_start_line,sizex-1+screen_start_column) ;
             win->DeleteLn() ;
           }
           if (first_offset < (file.line(first_line)).line_count(sizex) - 1)
              first_offset++ ;
           else {
              first_line++ ;
              first_offset = 0 ;
           }
           if (refresh_flag)
              _display_line(sizey) ;
        }
     }
  } else {
     for (int i=0; i< lines ; i++) {
        if ((first_line > 1) || ((first_line == 1) && first_offset)) {
             if (refresh_flag) {
                win->Move(sizey-1+screen_start_line,screen_start_column) ;
                win->DeleteLn() ;
                win->Move(screen_start_line,sizex-1+screen_start_column) ;
                win->InsertLn() ;
            }
                if (first_offset)
                   first_offset-- ;
                else {
                  first_line-- ;
                  first_offset = (file.line(first_line)).line_count(sizex)-1 ;
                }
               if (refresh_flag)
                  _display_line(1) ;
        }
     }
  }
}

void
Edit::_display_line(int num) // display screan line number num
{
  aString emptyline = areplicate(' ',sizex) ;
  int tnum = 0 ;
  int line, offset ;
  line=first_line ;
  if ((file.line(line)).line_count(sizex) - first_offset >= num)
    offset = first_offset + num - 1;
  else {
    tnum = (file.line(line)).line_count(sizex) - first_offset ;
    for (line++;((line <= file.lines()) && (tnum + (file.line(line)).line_count(sizex) < num)) ;
         tnum += (file.line(line++)).line_count(sizex)) ;
    offset = (num - tnum) - 1 ;
  }
  if ((line<=file.lines()) && (offset >= 0)) {
//    aString attributes = areplicate(' ', sizex)  ;
    // The following code will be replaced with a code getting the original attributes
    // from the representation strings
    char *origatts = new char [sizex+1] ;
    for (int j=0; j<sizex; j++)
       origatts[j] = ' ' ;
    origatts[sizex] = '\0' ;
    char *origattptr = origatts ;
    // end of to be replaced code

    char *atts = workbuffer  ;
    *atts = '\0' ;

     hebStringMode lang = (file.line(line)).getMajorMode() ;
     hebStringMode mlang = lang ;
//     if (lang == StrHebrew) {
//           *atts++ = '2' ;
//           *atts='\0' ;
//     }
    char lastCode = 0 ;
    int att1on = 0 ;
    int att2on = 0 ;
    int att3on = 0 ;
     for (int i=0; i< sizex; i++) {
           int l = (file.line(line)).getCurrentXlocation(offset, i) ;
           hebStringMode nlang= (file.line(line)).getCurrentXlang(offset, i) ;
           char code = (file.line(line)).getCurrentXcode(offset, i) ;
           if (l != SPLIT_VALUE) {
             if (nlang != lang) {
               if (nlang == mlang) {
                 *atts++ = '@' ;
                 *atts='\0' ;
                 att1on = 0 ;
               } else {
                 *atts++ = '2' ;
                 *atts='\0' ;
                 att1on = 1 ;
               }
               lang = nlang ;
             } // end if
             if (code != lastCode) {
               if ((code & INVALID_HEBREW_WORD) ||
                   (code & INVALID_ENGLISH_WORD))
               {

                 *atts++ = '3' ;
                 *atts='\0' ;
                 att2on = 1 ;
               } else {
                 *atts++ = '#' ;
                 *atts='\0' ;
                 att2on = 0 ;
               }
               if (code & INVALID_LAXET_COMMAND)
               {

                 *atts++ = '4' ;
                 *atts='\0' ;
                 att3on = 1 ;
               } else {
                 *atts++ = '$' ;
                 *atts='\0' ;
                 att3on = 0 ;
               }
               lastCode = code ;
             }
           } else {
             if (att1on) {
               *atts++ = '@' ;
               *atts='\0' ;
               att1on = 0 ;
               lang=mlang ;
             }
             if (att2on) {
               *atts++= '#' ;
               *atts='\0' ;
               att2on = 0 ;
               lastCode = 0 ;
             }
             if (att3on) {
               *atts++= '$' ;
               *atts='\0' ;
               att3on = 0 ;
               lastCode = 0 ;
             }
           }

           while ((*atts++=*origattptr++) != ' ') ;
//           *atts++ = ' ' ; // replace this with the original attributes instead
                           // by copying all non spaces until and including the first
                           // encountered space
           *atts='\0' ;
//          while (strcmp(attributes.at(locale-1, locale) , " ")) locale++ ;
       } // end for
       // add code here to copy all attributes until end of original attribute string
       strcat(atts, origattptr) ;
       // code to be removed
       delete origatts ;
       // end of code to be removed

   Marker startm = file.getStartMarker() , endm = file.getEndMarker() ;
   if ((!file.markActive()) || (line < startm.line) || (line > endm.line)) {
           strcpy(workbuffer2, workbuffer) ;
   } else {
//       char *rep = (file.line(line)).represent(sizex,offset) ;
//       char *prep = rep ;
       if ((line >= startm.line) && (line <= endm.line)) {
             char *atts1 = workbuffer ;
             char *atts2 = workbuffer2 ;
             int reversed = 0 ;
             if ((line > startm.line) && (line < endm.line)) {
                 *atts2++ = '1' ;
                 *atts2='\0' ;
                 reversed =1  ;
            }
            for (int i=0; i< sizex; i++) {
                int l = (file.line(line)).getCurrentXlocation(offset, i) ;
                if ((l != SPLIT_VALUE) &&
                    (
                      ((line > startm.line) && (line < endm.line)) ||
                      ((line == startm.line) && (startm.line < endm.line) && (l > startm.offset)) ||
                      ((startm.line < endm.line) && (line == endm.line) && (l <= endm.offset)) ||
                      ((startm.line == endm.line) && (l > startm.offset) && (l <= endm.offset))
                     )
                   )  {
                   if (!reversed) {
                       *atts2++ = '1' ;
                       *atts2='\0' ;
                        reversed = 1 ;
                   }
                } else {
                  if (reversed) {
                       *atts2++ = '!' ;
                       *atts2='\0' ;
                        reversed = 0 ;
                  }
               }
           while ((*atts2++=*atts1++) != ' ') ;
           *atts2 = '\0' ;
//            *atts2++ = *atts1++ ;
//            while (*atts1 != ' ') *atts2++ = *atts1++ ;
           } // end of for
           strcpy(atts2,"!@#$") ; // Turn off all attributes
      } // end of if
   }
//    aString toDisplay = (file.line(line)).represent(sizex, offset) ;

   win->MVAddStrAttr(num-1+screen_start_line,screen_start_column,
                     (file.line(line)).represent(sizex,offset),
                     workbuffer2) ;
  } else
    win->MVAddStr(num-1+screen_start_line,screen_start_column,(char *)(const char *)emptyline) ;
}

int
Edit::_line_to_display(int num) // display screan line number num
{
  int tnum = 0 ;
  int line, offset ;
  line=first_line ;
  if ((file.line(line)).line_count(sizex) - first_offset >= num)
    offset = first_offset + num - 1;
  else {
    tnum = (file.line(line)).line_count(sizex) - first_offset ;
    for (line++;(tnum + (file.line(line)).line_count(sizex) < num) &&
                (line <= file.lines()) ;
         tnum += (file.line(line++)).line_count(sizex)) ;
    offset = (num - tnum) - 1 ;
  }
  if (line <= file.lines())
     return TRUE ;
  return FALSE ;
}

int
Edit::_relocate_curx(int update)
{
  if (curx + update < 1) {
     if ((current_offset > 0) || (current_line > 1)) {
        _previous_line() ;
        curx = file.line(current_line).length() ;
        return _relocate_curx(0) ;
     }
     return 0 ;
  }

  if (curx+update > ((aString &)file.line(current_line)).length()) {
      if ((current_offset < (file.line(current_line)).line_count(sizex)-1) || (current_line < file.lines())) {
        _next_line() ;
        curx = 1 ;
        return _relocate_curx(0) ;
     }
     return 0 ;
  }
  curx += update ;
  int newcurx = curx ;
  int count = file.line(current_line).line_count(sizex) ;
  for (int i=0 ; i<count; i++) {
      for (int j=0; j<sizex ; j++) {
         if (file.line(current_line).getCurrentXlocation(i,j) == curx) {
             while (current_offset > i) _previous_line() ;
             while (current_offset < i) _next_line() ;
             _x_position = j ;
             curx =  newcurx ;
             hebStringMode mode = file.line(current_line).getCurrentXlang(current_offset,_x_position) ;
             if (mode == StrHebrew)
                 keyboard_mode = hebrew ;
            else
                 keyboard_mode = english ;
            return  1;
          }
      }
  }
  return 0 ;
}

// calculate curx, while fixing _x_position and languageMode as well
void
Edit::_calc_curx()
{
   int x = file.line(current_line).getCurrentXlocation(current_offset, _x_position) ;
   hebStringMode mode = file.line(current_line).getCurrentXlang(current_offset,_x_position) ;
   if (x != SPLIT_VALUE) {
     if (mode == StrHebrew)
        keyboard_mode = hebrew ;
     else
        keyboard_mode = english ;
     curx = x ;
     return ; // a correct location
   }
//   current_offset = 0 ;
   if (mode == StrHebrew) { // look to the left until you reach sizex, then look to the right
      int tmp = _x_position ;
      while ((x==SPLIT_VALUE) && (++_x_position < sizex))
         x = file.line(current_line).getCurrentXlocation(current_offset,_x_position) ;
       if (x == SPLIT_VALUE) {
         _x_position = tmp ;
         while ((x==SPLIT_VALUE) && (--_x_position >= 0))
            x = file.line(current_line).getCurrentXlocation(current_offset,_x_position) ;
       }
//       hebStringMode mode1 = file.line(current_line).getCurrentXlang(current_offset,_x_position) ;
//       assert(x != SPLIT_VALUE) ; // has to be here, or else it is a bug elsewhere
       if (x==SPLIT_VALUE) { // this is probably an empty line
           if ((file.line(current_line)).getMajorMode() == StrHebrew)
               x = sizex ;
           else
               x = 1 ;
       }
       if (mode == StrHebrew)
           keyboard_mode = hebrew ;
       else
           keyboard_mode = english ;
       curx = x ;
       return ;
   } else {
      int tmp = _x_position ;
      while ((x==SPLIT_VALUE) && (--_x_position >= 0))
         x = file.line(current_line).getCurrentXlocation(current_offset,_x_position) ;
       if (x == SPLIT_VALUE) {
         _x_position = tmp ;
         while ((x==SPLIT_VALUE) && (++_x_position < sizex))
            x = file.line(current_line).getCurrentXlocation(current_offset,_x_position) ;
       }
//       hebStringMode mode1 = file.line(current_line).getCurrentXlang(current_offset,_x_position) ;
//       assert(x!=SPLIT_VALUE) ; // has to be here, or else it is a bug elsewhere
       if (x==SPLIT_VALUE) { // this is probably an empty line
           if ((file.line(current_line)).getMajorMode() == StrHebrew)
               x = sizex ;
           else
               x = 1 ;
       }
        if (mode == StrHebrew)
           keyboard_mode = hebrew ;
        else
           keyboard_mode = english ;
        curx = x ;
        return ;
   }
}

//        for (i=0; i<sizey-2; i++) _next_line() ;
//         _scroll(-(sizey-2)) ;
void
Edit::_next_page(int refresh_flag)
{
//        for (i=0; i<sizey-2; i++) _next_line() ;
//         _scroll(-(sizey-2)) ;
  int flag = 0 ;
  int current_visual_line = cury ;

 for (int i=0; i<sizey; i++)
   _next_line(0) ;
/*
  if ((current_line < file.lines()) ||
      ((current_line == file.lines())
       && (current_offset < (file.line(current_line)).line_count(sizex)-1))) {
    if (current_offset < (file.line(current_line)).line_count(sizex)-1) {
       current_offset++ ;
    }
    else {
       if (current_line < file.lines()) current_line++ ;
       current_offset = 0 ;
    }
    if (cury < sizey) cury++ ;
     else if (_line_to_display(sizey+1)) {
           flag =1 ;
           if (first_offset < (file.line(first_line)).line_count(sizex) - 1)
              first_offset++ ;
           else {
              first_line++ ;
              first_offset = 0 ;
           }
      }
  }
 }
*/
    _calc_curx() ;
    if (refresh_flag) {
       if (flag==0) {
      Marker rescroll = {current_line, curx-1, current_visual_line} ;
      _relocateAtMarker(rescroll) ;
         win->Refresh();
      }
      _refresh() ;
   }
}

void
Edit::_previous_page(int refresh_flag)
{
  int flag = 0 ;
  int current_visual_line = cury ;
 for (int i=0; i<sizey; i++)
    _previous_line(0) ;
/*
  if ((current_line > 1) ||
      ((current_line == 1) && current_offset)) {
    if (cury > 1) cury-- ;
    else if ((first_line > 1) ||
         ((first_line == 1) && first_offset)) {
         flag = 1 ;
                if (first_offset)
                   first_offset-- ;
                else {
                  first_line-- ;
                  first_offset = (file.line(first_line)).line_count(sizex)-1 ;
                }
    }
    if (current_offset) {
      current_offset-- ;
    }
    else {
      current_line-- ;
      current_offset = (file.line(current_line)).line_count(sizex)-1 ;
    }
  }
 }
*/
    _calc_curx() ;
    if (refresh_flag) {
      if (flag==0) {
      Marker rescroll = {current_line, curx-1, current_visual_line} ;
      _relocateAtMarker(rescroll) ;
         win->Refresh();
      }
      _refresh() ;
    }
}

int
Edit::_next_line(int refresh_flag)
{
  if ((current_line < file.lines()) ||
      ((current_line == file.lines())
       && (current_offset < (file.line(current_line)).line_count(sizex)-1))) {
    if (current_offset < (file.line(current_line)).line_count(sizex)-1) {
       current_offset++ ;
    }
    else {
       if (current_line < file.lines()) current_line++ ;
       current_offset = 0 ;
    }
    if (cury < sizey) cury++ ;
    else if (_line_to_display(sizey+1)) _scroll(-1, refresh_flag) ;
  } else return 0 ;
  _calc_curx() ;
  _relocate_curx(0) ;
  return 1 ;
}

int
Edit::_previous_line(int refresh_flag)
{
  if ((current_line > 1) ||
      ((current_line == 1) && current_offset)) {
    if (cury > 1) cury-- ;
    else if ((first_line > 1) ||
         ((first_line == 1) && first_offset)) _scroll(1, refresh_flag) ;
    if (current_offset) {
      current_offset-- ;
    }
    else {
      current_line-- ;
      current_offset = (file.line(current_line)).line_count(sizex)-1 ;
    }
  } else return 0 ;
  _calc_curx() ;
  _relocate_curx(0) ;
  return 1 ;
}

void
Edit::_forward() // actually go right!
{
   hebStringMode mode = file.line(current_line).getMajorMode() ;
   if (_x_position < sizex-1) {
       int tmp ;
        while ((_x_position < sizex-1) &&
           ((tmp=file.line(current_line).getCurrentXlocation(current_offset,++_x_position))== SPLIT_VALUE)) ;
      // if there is no chage, meaning we are at an end or beginning of line, so
      // added this if statement 18/4/97
      if ((current_offset < (file.line(current_line)).line_count(sizex)-1) || (current_line < file.lines())) {
        if (tmp == SPLIT_VALUE) {
          _x_position = 0 ;
          if (mode == StrHebrew)
            _previous_line() ;
          else
            _next_line() ;
         }
      }
   } else if ((current_offset < (file.line(current_line)).line_count(sizex)-1) || (current_line < file.lines())) {
      _x_position=0 ;
      if (mode == StrHebrew)
         _previous_line() ;
      else
         _next_line() ;
   }
    _calc_curx() ;
}

void
Edit::_backward() // actually go left!
{
   hebStringMode mode = file.line(current_line).getMajorMode() ;
   if (_x_position > 0) {
       int tmp ;
        while ((_x_position > 0) &&
           ((tmp=file.line(current_line).getCurrentXlocation(current_offset,--_x_position))== SPLIT_VALUE)) ;
      if (tmp == SPLIT_VALUE) {
        _x_position = sizex-1 ;
        if (mode == StrEnglish)
          _previous_line() ;
        else
          _next_line() ;
      }
   } else if ((current_offset > 0) || (current_line > 1)) {
      _x_position=sizex-1 ;
      if (mode == StrEnglish)
         _previous_line() ;
      else
         _next_line() ;
   }
   _calc_curx() ;
}


void
Edit::_relocateAtMarker(Marker mark)
{
   if ((current_line > mark.line) || ((current_line == mark.line) && (curx > mark.offset+1))) {
        for (;first_line>mark.line  ; _previous_page(0)) ;
        for (;current_line < mark.line ; _next_line(0)) ;
        for (;current_line > mark.line ; _previous_line(0)) ;
        for (;curx>mark.offset+1; _relocate_curx(-1)) ;
        for (;curx<mark.offset+1; _relocate_curx(1)) ;
//        win->Refresh() ;
//        _refresh() ;
   } else
     if ((current_line < mark.line) || ((current_line == mark.line) && (curx < mark.offset+1))) {
        for (;current_line <mark.line  ; _next_page(0)) ;
//        for (;current_line > mark.line ; _previous_line(0)) ;
        if (current_line > mark.line) _previous_page(0) ;
        for (;current_line < mark.line ; _next_line(0)) ;
        for (;curx>mark.offset+1; _relocate_curx(-1)) ;
        for (;curx<mark.offset+1; _relocate_curx(1)) ;
//        win->Refresh() ;
//        _refresh() ;
    } // else you are already located there.
    if ((mark.offset_from_top >= 0) && (cury < mark.offset_from_top)) {
         int i, count=0 ;
         for (i=0; i< mark.offset_from_top-1; i++) count+=_previous_line(0) ;
         for (i=0; i< count; i++) _next_line(0) ;
         for (;curx>mark.offset+1; _relocate_curx(-1)) ;
         for (;curx<mark.offset+1; _relocate_curx(1)) ;
    } else
    if ((mark.offset_from_top >= 0) && (cury > mark.offset_from_top)) {
         int i , count=0;
         for (i=0; i< (sizey)-mark.offset_from_top; i++) count+=_next_line(0) ;
         for (i=0; i< count; i++) _previous_line(0) ;
         for (;curx>mark.offset+1; _relocate_curx(-1)) ;
         for (;curx<mark.offset+1; _relocate_curx(1)) ;
    }
/*
 // just in case this last trick, moved your from where you were supposed to be
   if ((current_line > mark.line) || ((current_line == mark.line) && (curx > mark.offset+1))) {
        for (;first_line>mark.line  ; _previous_page(0)) ;
        for (;current_line < mark.line ; _next_line(0)) ;
        for (;current_line > mark.line ; _previous_line(0)) ;
        for (;curx>mark.offset+1; _relocate_curx(-1)) ;
        for (;curx<mark.offset+1; _relocate_curx(1)) ;
//        win->Refresh() ;
//        _refresh() ;
   } else
     if ((current_line < mark.line) || ((current_line == mark.line) && (curx < mark.offset+1))) {
        for (;current_line <mark.line  ; _next_page(0)) ;
//        for (;current_line > mark.line ; _previous_line(0)) ;
        if (current_line > mark.line) _previous_page(0) ;
        for (;current_line < mark.line ; _next_line(0)) ;
        for (;curx>mark.offset+1; _relocate_curx(-1)) ;
        for (;curx<mark.offset+1; _relocate_curx(1)) ;
//        win->Refresh() ;
//        _refresh() ;
    } // else you are already located there.
*/
}


void
Edit::goto_line(int num) {
    Marker where = {num, 0,-1} ;

    if ((num <=0) || (num > file.lines())) {
          _refresh() ;
          win->Message(MSG_INVALID_LINE_NUMBER) ;
          return ;
    }
    _relocateAtMarker(where) ;
    win->MessageClear(1) ;
    win->Refresh() ;
    _refresh() ;
}


void
Edit::searchForNext(char *text)
{
          if (!text) return ;
          if (!*text) return ;
          Marker starting_point = {current_line, curx, -1} ;
          Marker find = file.search(text,starting_point) ;
          if (find.line > 0) {
              _relocateAtMarker(find) ;
              file.setStartMarker(find.line, find.offset) ;
              file.setEndMarker( find.line, find.offset + strlen(text) ) ;
              _markBlock() ;
          }

        win->Refresh();
        _refresh() ;
}

void
Edit::searchForPrevious(char *text)
{
          if (!text) return ;
          if (!*text) return ;
          Marker starting_point = {current_line, curx-2, -1} ;
          Marker find = file.searchBackward(text,starting_point) ;
          if (find.line > 0) {
              _relocateAtMarker(find) ;
              file.setStartMarker(find.line, find.offset) ;
              file.setEndMarker( find.line, find.offset + strlen(text) ) ;
              _markBlock() ;
          }

        win->Refresh();
        _refresh() ;
}


void
Edit::searchFor(char *text)
{
          Marker starting_point = {current_line, curx-1, cury} ;
          Marker find = file.search(text,starting_point) ;
          if (find.line > 0) {
              _relocateAtMarker(find) ;
              file.setStartMarker(find.line, find.offset) ;
              file.setEndMarker( find.line, find.offset + strlen(text) ) ;
              _markBlock() ;
          }

        win->Refresh();
        _refresh() ;
}


void Edit::_insertDataBlock(Marker location, char * data_block)
{
   _relocateAtMarker(location) ;
   char *data = strdup((char *)(const char *)(data_block)) ;
   if (!*data) {
       delete data ;
       return ;
   }
   char *ptr=data , *ptr2 ;

   if (!strchr(ptr,'\n')) { // only one line
      aString tmp = ((aString &)(file.line(current_line))).at(0,curx-1) ;
      tmp += (const char *)ptr ;
      tmp+= ((aString &)(file.line(current_line))).at(curx-1,((aString &)(file.line(current_line))).length()) ;
      (aString &)(file.line(current_line)) = tmp  ;
//      file.setStartMarker(current_line, curx-1) ;
//      file.setEndMarker(current_line, curx-1+((aString &)((he->scratch->file).line(1))).length()-1) ;
//      _markBlock() ;
      file.recompile_section(sizex) ;
   } else {
      ptr2 = strchr(ptr, '\n') ;
      *ptr2 = '\0' ;
      int cl=current_line ;
      int curline = current_line ;
      aString tmp = ((aString &)(file.line(current_line))).at(0,curx-1) ;
      if (*ptr)
         tmp += ptr ;
      // remember the rest of the line to add it
      aString restofline = ((aString &)(file.line(current_line))).at(curx-1,((aString &)(file.line(current_line))).length()) ;
      // set the current line to the new value.
      (aString &)(file.line(cl)) = tmp  ;
      // now insert the rest of the line
      file.insert_after(cl, (char *)(const char *)restofline) ; // sort of a place holder
      ptr = ptr2+1 ;
      for (ptr2=strchr(ptr,'\n'); ptr2!=0 ; ptr2 = strchr(ptr, '\n')) {
        *ptr2 = '\0' ;
        file.insert_after(cl++, ptr) ;
        ptr = ptr2+1 ;
      }
      if (*ptr) {
        tmp =  ptr ;
        (aString &)(file.line(++cl)) = tmp + restofline ;
      } else (aString &)(file.line(++cl)) = restofline ;
//      file.setEndMarker(cl, tmp.length()) ;
//      _markBlock() ;
      file.line(curline) ;
      file.recompile_section(sizex) ;
   }
   delete data ;
}



void Edit::_deleteDataBlock(Marker location, char * data_block)
{
   _relocateAtMarker(location) ;
   char *data = strdup((char *)(const char *)(data_block)) ;
   if (!*data) {
       delete data ;
       return ;
   }
   char *ptr=data , *ptr2 ;

   if (!strchr(ptr,'\n')) { // only one line
     aString tmp = ((aString &)(file.line(current_line))).at(0,curx-1) ;
     tmp+= ((aString &)(file.line(current_line))).at(curx-1+strlen(ptr),
                          ((aString &)(file.line(current_line))).length()) ;
     (aString &)(file.line(current_line)) = tmp  ;
     file.recompile_section(sizex) ;
   } else {
      ptr2 = strchr(ptr, '\n') ;
      *ptr2 = '\0' ;
      int cl=current_line ;
      aString tmp = ((aString &)(file.line(cl))).at(0,curx-1) ;
      for (ptr = ptr2+1, ptr2=strchr(ptr,'\n'); ptr2 ; ptr=ptr2+1, ptr2 = strchr(ptr, '\n')) {
        file.delete_line(cl+1) ; ;
      }
      tmp+= ((aString &)(file.line(cl+1))).at(strlen(ptr),((aString &)(file.line(cl+1))).length()) ;
      (aString &)(file.line(cl)) = tmp  ;
      file.delete_line(cl+1) ;
      file.line(cl) ;
      file.recompile_section(sizex) ;
   }
   delete data ;
}

// Constructors
Edit::Edit(HebrewEditor *he, const char *name, aWindow *win, int read_only, char *title) :
        he(he),
        undo(this),
        screen_start_line(0) , screen_start_column(0),
        file_p( new hebFile(he, name,win->scr->hebrew_location,*(win->scr),1,getActiveSpelling())),
        name(name) ,
        curx(1), cury(1),
        cury_offset(0) ,
        win(win),
        input(win->scr->hebrew_location,english),
        continue_edit(TRUE),
        first_line(1), first_offset(0),
        sizex(80), sizey(23),
        specialSeparator(win->scr->special_separator),
        last_action(Action::Null),
        esc(0),
        ctrlK(0), ctrlQ(0),
        left_end_mark(win->get_left_end_mark()),
        right_end_mark(win->get_right_end_mark()),
        read_only(read_only),
        _x_position(0),
        delay_compilation(0),
        modified(0) ,
        file(*file_p),
        from(0),
        action(*he->globalActionManager) {
   keyboard_mode = english;
   current_line = first_line ;
   current_offset = first_offset ;
   win->GetMaxYX(&sizey,&sizex) ;
//       --sizey ;
   if (title) {
       win->setWindowTopTitle(title) ;
   } /* endif */
}

   // READ ONLY initialized from data_block ;
Edit::Edit(HebrewEditor *he, char *title, const char *text, aWindow *win, int read_only ) :
        he(he),
        undo(this),
        screen_start_line(0) , screen_start_column(0),
        file_p( new hebFile(he, "",win->scr->hebrew_location,*(win->scr),1, getActiveSpelling())),
        name(name),
        curx(1), cury(1), cury_offset(0),
        win(win),
        input(win->scr->hebrew_location,english),
        continue_edit(TRUE),
        first_line(1), first_offset(0),
        sizex(80), sizey(23),
        specialSeparator(win->scr->special_separator),
        last_action(Action::Null),
        esc(0),
        ctrlK(0), ctrlQ(0),
        left_end_mark(win->get_left_end_mark()), right_end_mark(win->get_right_end_mark()),
        read_only(read_only),
        _x_position(0),
        delay_compilation(0),
        modified(0) ,
        file(*file_p),
        from(0),
        action(*he->globalActionManager) {
   keyboard_mode = english;
   current_line = first_line ;
   current_offset = first_offset ;
   win->GetMaxYX(&sizey,&sizex) ;
//       --sizey ;
   file.recompile_file(sizex) ;
   Marker beginning = {1,0,-1} ;
   if (text) {
     _insertDataBlock(beginning, (char *)text) ;
   } /* endif */
   if (title) {
      win->setWindowTopTitle(title) ;
   } /* endif */
}



//#include "Edit_events.cxx"
