/***************************************************************************
                          Edit.h - The main Editor implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#ifndef __Edit_h__
#define __Edit_h__

#include "hebFile.h"
#include <string.h>
#include "Input.h"
#include "Array.h"
#include "Action.h"
#include "Screen.h"
#include "aString.h"
#include "aDictionary.h"

#include "aWindow.h"

// recompile_section after MAX_DELAY events of Char and Delete/BackSpace
// so recompile only the current line.
// set MAX_DELAY to 1 to recompile_section after every Char/Delete/BackSpace event.
//   for Delete/BackSpace, recompilation is delayed only if the action is assured to not involve any other lines,
//   because Delete can JOIN the next line with the current, when pressed at EOL, and BackSpace can JOIN the
//  current with the previous, when at HOL (Home Of Line)
#define MAX_DELAY 20

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define READ_ONLY 1

#define SCRATCH_BUFFER_NAME "~~scratch~~"

#include "Undo.h"

class HebrewEditor ;

class Edit {
protected:
   HebrewEditor *he ;
   Undo undo ;
   Marker work_marker ;
   aString work_data_block ;
   int screen_start_line, screen_start_column ;
   hebFile* file_p ;
   aString name ;
   int curx, cury, cury_offset ;
   aWindow *win ;
   Input input ;
   int continue_edit ;
   int first_line ; /* of file, that is show on screen */
   int first_offset ; /* within line that is split into several virtual lines */
   int current_line ;
   int current_offset ;
   int sizex, sizey ;
   InputMode keyboard_mode ;
   int specialSeparator ;
   Action::Actions last_action ;
   int esc, ctrlK, ctrlQ ;
   char left_end_mark, right_end_mark ;
   int read_only ;
   int _x_position ;
   int delay_compilation ;
   int modified ;
   static char buffer[MAX_SCREEN_WIDTH] ;
   static char buffer2[MAX_SCREEN_WIDTH] ;
   char workbuffer[5000] ;
   char workbuffer2[5000] ;
public:
   hebFile& file ;
   Edit *from ;
   Action &action ;
   // these are updated by refresh and used by _relocateAtMarker()
protected:
   virtual int  getActiveSpelling() { return 1 ; }
   virtual char *suggestWords(aDictionary *dict, aString& word) ;
   virtual int show_line_end_marks() { return 1 ; }
   virtual int _need_to_save() { return 1 ; }
   virtual void _maketitle(int show = 1) ;
   virtual void _scroll(int lines, int refresh_flag = 1) ;
   virtual void _refresh() ;
   virtual void _quite_refresh() ;
   virtual char * _newline() ; // new line returns the characters that were added, since
                        // indentation can be applied (for undo purposes)
   virtual void _display_line(int num) ;
   virtual int  _line_to_display(int num) ;
   virtual int _x_pos() ;
   virtual void _next_page(int refresh_flag=1) ;
   virtual void _previous_page(int refresh_flag=1) ;
   virtual int _next_line(int refresh_flag = 1) ;
   virtual int _previous_line(int refresh_flag =1) ;
   virtual void _forward() ;
   virtual void _backward() ;
   virtual void _calc_curx() ; // updates curx, _x_position and keyboard_mode
   virtual int _relocate_curx(int update) ; // updates curx, _x_position and keyboard_mode , moves to next/previous logical
                                                                 // position
// MESSAGE HANDLERS
public:
   virtual void _LaxetCommandHelp(Action::Actions act) ;
   virtual void _SpellWord(Action::Actions act) ;
   virtual void _LearnAllWords(Action::Actions act) ;
   virtual void _Tab(Action::Actions act) {}
   virtual void _MarkBlockBegin(Action::Actions act) ;
   virtual void _MarkBlockEnd(Action::Actions act) ;
   virtual void _UnmarkBlock(Action::Actions act) ;
   virtual void _DeleteBlock(Action::Actions act) ;
   virtual void _CopyBlock(Action::Actions act) ;
   virtual void _MoveBlock(Action::Actions act) ;
   virtual void _Suspend(Action::Actions act) ;
   virtual void _Help(Action::Actions act) ;
   virtual void _Find(Action::Actions act) ;
   virtual void _FindReplace(Action::Actions act) ;
   virtual void _DeleteChar(Action::Actions act) ;
   virtual void _BackSpace(Action::Actions act) ;
   virtual void _DeleteLine(Action::Actions act) ;
   virtual void _SaveFile(Action::Actions act) ;
   virtual void _Refresh(Action::Actions act) ;
   virtual void _NewLine(Action::Actions act) ;
   virtual void _Exit(Action::Actions act) ;
   virtual void _NextLogicalWord(Action::Actions act) ;
   virtual void _PreviousLogicalWord(Action::Actions act) ;
   virtual void _RealForwardChar(Action::Actions act) ;
   virtual void _RealBackwardChar(Action::Actions act) ;
   virtual void _WordRight(Action::Actions act) ;
   virtual void _WordLeft(Action::Actions act) ;
   virtual void _ForwardChar(Action::Actions act) ; // go right
   virtual void _BackwardChar(Action::Actions act) ; // go left
   virtual void _NextLine(Action::Actions act) ;
   virtual void _PreviousLine(Action::Actions act) ;
   virtual void _Home(Action::Actions act) ;
   virtual void _End(Action::Actions act) ;
   virtual void _BeginningOfFile(Action::Actions act) ;
   virtual void _EndOfFile(Action::Actions act) ;
   virtual void _PgUp(Action::Actions act) ;
   virtual void _PgDn(Action::Actions act) ;
   virtual void _Char(Action::Actions act) ;
   virtual void _LanguageToggle(Action::Actions act) ;
   virtual void _ChangeDirection(Action::Actions act) ;
   virtual void _Undo(Action::Actions act) ;
   virtual void _Redo(Action::Actions act) ;
public:
   Edit(HebrewEditor *he, const char *name, aWindow *win, int read_only = 0 , char *title=0) ;
   // READ ONLY initialized from data_block ;
   Edit(HebrewEditor *he, char *title, const char *text, aWindow *win, int read_only = 1 ) ;

   virtual ~Edit() {}

   virtual void processFile(int show=1) {
        if (show) {
          _maketitle() ;
          win->Message("(Processing files)") ;
       }
       file.recompile_file(sizex) ;
   }

   virtual void refresh() {
       win->Refresh() ;
       win->MessageTip() ;
       _refresh() ;
   }
   virtual int finished() { return !continue_edit ; }
   virtual void processAction(Action::Actions act) ;
   Action::Actions getNextAction() { return action.getNextAction() ; }
   void setName(char *newname) { name  = newname ; file.setName(newname) ; }
   aString& getName() { return name ; }
   void goto_line(int num) ;
   void searchFor(char *text) ;
   void searchForNext(char *text) ;
   void searchForPrevious(char *text) ;
   Marker where() { Marker m={current_line, curx-1, cury} ; return m ; }
   void _insertDataBlock(Marker location, char * data_block) ;
   void _deleteDataBlock(Marker location, char * data_block) ;
   virtual void _relocateAtMarker(Marker mark) ;
   virtual void _markBlock(Marker startm, Marker endm, int copy_to_scratch=0) ;
   virtual void _markBlock(int copy_to_scratch=0) ; // mark block by file.start_marker, file.end_marker
   virtual int get_current_line() { return current_line ; }
   virtual int getModified() { return undo.is_modified() ; }
} ;

#endif
