/***************************************************************************
                          Edit_events.cxx - Event handling for Edit
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WIN32
#       include <unistd.h> //PORT:
#endif
#include <signal.h>
#include <stdio.h>
#include <assert.h>
#include "Edit.h"
#include "Help.h"
#include "Action.h"
#include <stdlib.h>
#include "langdep.h"
#include "aSelectionBox.h"
#include "aDictionary.h"
#include "HebrewEditor.h"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#include "LineEdit.h"


void
Edit::processAction(Action::Actions act)
{
//   int i ; // for general use
   action.getLastChar() ;

   if (screen_start_line != win->getLastLineNum())
          win->MessageClear() ;
   switch (act) {
     case Action::LaxetCommandHelp:
          _LaxetCommandHelp(act) ;
          break ;

     case Action::SpellWord:
          _SpellWord(act) ;
          break ;

     case Action::SpellLearnAllWords:
          _LearnAllWords(act) ;
          break ;

     case Action::Tab:
          _Tab(act) ;
          break ;

     case Action::MarkBlockBegin:
          _MarkBlockBegin(act) ;
          break ;

     case Action::MarkBlockEnd:
          _MarkBlockEnd(act) ;
          break ;

     case Action::UnmarkBlock:
          _UnmarkBlock(act) ;
          break ;

     case Action::DeleteBlock:
          _DeleteBlock(act) ;
          break ;

     case Action::CopyBlock:
          _CopyBlock(act) ;
          break ;

     case Action::MoveBlock:
          _MoveBlock(act) ;
          break ;

     case Action::Suspend: // suspend this program
          _Suspend(act) ;
          break ;

     case Action::Help:
          _Help(act) ;
        break ;

     case Action::Find:
          _Find(act) ;
         break ;

     case Action::FindReplace:
          _FindReplace(act) ;
         break ;

     case Action::Undo:
          _Undo(act) ;
         break ;

     case Action::Redo:
          _Redo(act) ;
         break ;

     case Action::DeleteChar: // delete current char
          _DeleteChar(act) ;
        break ;


     case Action::BackSpace: // delete previous char
          _BackSpace(act) ;
        break ;

     case Action::DeleteLine: // delete line
          _DeleteLine(act) ;
        break ;

     case Action::SaveFile:
          _SaveFile(act) ;
        break ;

     case Action::ToggleLanguage:
        _LanguageToggle(act) ;
        break ;

     case Action::ChangeDirection: // insert \sethebrew or \unsethebrew commands
        _ChangeDirection(act) ;
        break ;

     case Action::Refresh:
          _Refresh(act) ;
          break ;

     case Action::NewLine:
          _NewLine(act) ;
        break ;

     case Action::Exit:
          _Exit(act) ;
        break ;

     case Action::NextLogicalWord:
          _NextLogicalWord(act) ;
        break ;

     case Action::PreviousLogicalWord:
          _PreviousLogicalWord(act) ;
        break ;

     case Action::RealForwardChar:
          _RealForwardChar(act) ;
        break ;

     case Action::RealBackwardChar:
          _RealBackwardChar(act) ;
        break ;

     case Action::WordRight:
          _WordRight(act) ;
        break ;

     case Action::WordLeft:
          _WordLeft(act) ;
        break ;

     case Action::BackwardChar:
          _BackwardChar(act) ;
        break ;

     case Action::ForwardChar:
          _ForwardChar(act) ;
        break ;

     case Action::NextLine:
          _NextLine(act) ;
        break ;

     case Action::PreviousLine:
          _PreviousLine(act) ;
        break ;

     case Action::Home:
          _Home(act) ;
        break ;

     case Action::End:
          _End(act) ;
        break ;

     case Action::BeginningOfFile:
          _BeginningOfFile(act) ;
        break ;

     case Action::EndOfFile:
          _EndOfFile(act) ;
        break ;

     case Action::PgUp:
          _PgUp(act) ;
        break ;

     case Action::PgDn:
          _PgDn(act) ;
        break ;

     case Action::Char:
          _Char(act) ;
        break ;

     default: // ignore Null action
        break ;
   }
   if ((act != Action::Char)&&(act != Action::DeleteChar) && (act!= Action::BackSpace) && (delay_compilation > 0)) {
         file.recompile_section(sizex) ;
         delay_compilation = 0 ;
         _refresh() ;
   } else if (delay_compilation >= MAX_DELAY) {
         file.recompile_section(sizex) ;
         delay_compilation = 0 ;
         _refresh() ;
   }

   _maketitle() ;
   win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
   win->scr->Refresh() ;
   win->Refresh() ;
   last_action = act ;
}



///////////////////////////////////////////////////////
////  ACTIONS
///////////////////////////////////////////////////////


void
Edit::_LanguageToggle(Action::Actions act) {
       if (read_only) return ;
        if (keyboard_mode == hebrew)
          keyboard_mode = english ;
        else
          keyboard_mode = hebrew ;
        input.set_mode(keyboard_mode) ;
}

void
Edit::_ChangeDirection(Action::Actions act) {
       if (read_only) return ;

       undo.invalidate_current() ;

       Marker _startm = file.getStartMarker() ;
       Marker _endm = file.getEndMarker() ;
       Marker before = where() ;
       aString inserting="\\sethebrew\n" ;
       if ((file.line(current_line)).getMajorMode()==StrHebrew)
           inserting = "\\unsethebrew\n" ;

       _insertDataBlock(before, (char *)(const char*)inserting) ;
       Marker after = where() ;
       undo.record_action(UndoSt::ActInsert, inserting, before, after, _startm, _endm) ;
       _End(act) ;
       _NextLine(act) ;
       _Home(act) ;
       _refresh() ;
}

void
Edit::_MarkBlockBegin(Action::Actions act)
{
       undo.invalidate_current() ;
   file.setStartMarker(current_line, curx-1) ;
   _markBlock(file.getStartMarker(), file.getEndMarker()) ;
   _markBlock(1) ;
   _refresh() ;
}

void
Edit::_MarkBlockEnd(Action::Actions act)
{
       undo.invalidate_current() ;
   file.setEndMarker(current_line, curx-1) ;
   _markBlock(file.getStartMarker(), file.getEndMarker()) ;
   _markBlock(1) ;
   _refresh() ;
}

void
Edit::_UnmarkBlock(Action::Actions act)
{
       undo.invalidate_current() ;
          file.unmarkBlock() ;
           if (act == Action::UnmarkBlock) {
             he->scratch->file.eraseContent() ;
             he->scratch->current_offset = 0 ; he->scratch->curx = 1 ; he->scratch->current_line = 1 ;
            he->scratch->file.recompile_file(sizex) ;
            he->scratch->_relocate_curx(0) ;
            he->scratch->modified = 1 ;
            he->scratch->_calc_curx() ;
          }
          _refresh() ;
}

void
Edit::_DeleteBlock(Action::Actions act)
{
      if (read_only) return ;
       undo.invalidate_current() ;

       Marker _startm = file.getStartMarker() ;
       Marker _endm = file.getEndMarker() ;
       Marker before = _startm ;
       aString data = "" ;
          if (file.markActive()) {
           _markBlock(1) ; // copy to he->scratch (sort of a 'cut')
           Marker startm=file.getStartMarker() ;
           Marker endm=file.getEndMarker() ;
               _relocateAtMarker(startm) ;
            if (act == Action::DeleteBlock) {
               win->Refresh() ;
               _refresh() ;
            }
            if (endm.line == startm.line) {
              data += ((aString &)(file.line(startm.line))).at(startm.offset,endm.offset) ;
               _deleteDataBlock(where(), (char *)(const char*)data) ;
           } else {
//              int cl=current_line ;
              data += ((aString &)(file.line(startm.line))).at(startm.offset,
                             ((aString&)(file.line(startm.line))).length()-1) ;
              data += " \n" ;
             for (int l = startm.line+1; l <= endm.line ; l++) {
                   if (l < endm.line) {
                      data += ((aString &)(file.line(l))) ;
                      data += '\n' ;
                   } else
                    data += ((aString &)(file.line(endm.line))).at(0, endm.offset) ;
             }
             _deleteDataBlock(where(), (char *)(const char *)data) ;
          }
          if (act == Action::DeleteBlock) {
             _UnmarkBlock(act) ;
             file.line(startm.line) ;
             modified = 1 ;
             _relocate_curx(0) ;
             Marker after = where() ;
             undo.record_action(UndoSt::ActDelete, data, where(), after, _startm, _endm) ;
             _refresh() ;
           }
          }
}

void
Edit::_CopyBlock(Action::Actions act)
{
 if (read_only) return ;
       undo.invalidate_current() ;

  Marker _startm = file.getStartMarker() ;
  Marker _endm = file.getEndMarker() ;
  Marker before = where() ;
  aString data = "" ;
  if (act == Action::CopyBlock) {
     Marker startm = file.getStartMarker() ;
     Marker endm = file.getEndMarker() ;
    if (((current_line > startm.line) ||
       (current_line == startm.line)&&(curx > startm.offset+1)) &&
      ((current_line < endm.line) ||
       (current_line == endm.line)&&(curx < endm.offset+1))) {
        // trying to copy a block into a marked block!, illegal now
         win->Message(MSG_INVALID_COPY_BLOCK) ;
         return ;
     }
  }
  int curline = current_line ;
  if (he->scratch->file.isFileEmpty()) {
      if (file.markActive())
           _markBlock(1) ;
  } else if ((he->scratch->from == this) && (act == Action::CopyBlock))
     _markBlock(1) ;

  if (!he->scratch->file.isFileEmpty()) {  // I can't use file.markActive now, because a block can be
    // copied from another buffer,using the he->scratch buffer.
    if ((he->scratch->file).lines() == 1) {
      data += ((aString &)((he->scratch->file).line(1))) ; //.at(0,((aString &)((he->scratch->file).line(1))).length()) ; // he->scratch is not compiled anymore so there is no extra space
      _insertDataBlock(where(), (char *)(const char *)data) ;
      file.setStartMarker(current_line, curx-1) ;
      file.setEndMarker(current_line, curx-1+((aString &)((he->scratch->file).line(1))).length()) ;
      _markBlock() ;
    } else {
      file.setStartMarker(current_line, curx-1) ;
      int cl=current_line ;
      data += ((aString &)((he->scratch->file).line(1))).at(0,((aString &)((he->scratch->file).line(1))).length()) ;
      for (int l = 2; l < he->scratch->file.lines() ; l++) {
        data += '\n' ;
        data += (aString &)(he->scratch->file.line(l)) ;
        cl++ ;
      }
      aString tmp = ((aString &)((he->scratch->file).line(he->scratch->file.lines()))) ; //.at(0,
      data += '\n' ;
      data += tmp ; cl++ ;
      _insertDataBlock(where(), (char *)(const char*)data) ;
      file.setEndMarker(cl, tmp.length()) ;
      _markBlock() ;
      file.line(curline) ;
//      file.recompile_section(sizex) ;
    }
    file.line(curline) ;
    modified = 1 ;
    _relocate_curx(0) ;
    Marker after = where() ;
    if (act == Action::CopyBlock)
       undo.record_action(UndoSt::ActInsert, data, before, after, _startm, _endm) ;
    else
      work_data_block = data ;

    _refresh() ;
  }
}


void
Edit::_MoveBlock(Action::Actions act)
{
  if (read_only) return ;
       undo.invalidate_current() ;
  if (he->scratch->file.isFileEmpty()) {
      if (file.markActive())
           _markBlock(1) ;
  }
  if (he->scratch->from)
        if (he->scratch->from != this) {
          win->Message(MSG_INVALID_MOVE_BLOCK_FROM_DIFFERENT_BUFFER) ;
          return ;
  }
  Marker startm = file.getStartMarker() ;
  Marker endm = file.getEndMarker() ;
  Marker _startm = file.getStartMarker() ;
  Marker _endm = file.getEndMarker() ;
  Marker before = startm ;
  if (((current_line > startm.line) ||
       (current_line == startm.line)&&(curx > startm.offset+1)) &&
      ((current_line < endm.line) ||
       (current_line == endm.line)&&(curx < endm.offset+1))) {
    // trying to move a block into a marked block!, illegal now
    win->Message(MSG_INVALID_MOVE_BLOCK_INTO_MARKED_BLOCK) ;
    return ;
  }

  if (((current_line == endm.line) && (curx == endm.offset+1)) ||
       ((current_line == startm.line) && (curx == startm.offset+1)))
       return ; // ignore, just like moving a block right after itself, or right before itself

//  int curline = current_line ;
  if (!he->scratch->file.isFileEmpty()) {
    // I can't use file.markActive now, because a block can be
    // copied from another buffer,using the scratch buffer.
    if (he->scratch->from == this) {
      Marker newLocale = { current_line, curx-1, cury } ;
        if ((startm.line == current_line) && (curx > startm.offset+1)) {
               newLocale.offset -= ( (aString&)(he->scratch->file.line(1)) ).length() ;
               newLocale.offset_from_top = -1 ;
              _relocateAtMarker(newLocale) ;
        } else
        if ((endm.line == current_line) && (curx > endm.offset+1)) {
               newLocale.offset -= endm.offset-startm.offset ;
              if (endm.line > startm.line)
               newLocale.line -= (endm.line - startm.line)-1 ;
        } else if (current_line > endm.line)
              if (endm.line > startm.line)
               newLocale.line -= (endm.line - startm.line) ;
        _DeleteBlock(act) ;
        _relocateAtMarker(newLocale) ; // with same offset from top if needed, so visually it would look as if
                                                                     // the editor stayed in the same place.
//        if (current_line > startm.line) {
//               newLocale.line -= he->scratch->file.lines() -1;
//            _relocateAtMarker(newLocale) ;
//        }
     }
    _CopyBlock(act) ;
    Marker after = where() ;
    undo.record_action(UndoSt::ActMove, work_data_block, before, after, _startm, _endm) ;
  }
}


void
Edit::_Suspend(Action::Actions act)
{
    undo.invalidate_current() ;
    action.getLastChar() ;
    win->Erase() ;
    if (getenv("HE2_NEW_SHELL_ON_SUSPEND") != NULL)
       win->TemporaryExit() ;
    else
       win->Suspend() ;
    win->GetMaxYX(&sizey,&sizex) ;
//        --sizey ;
    file.recompile_file(sizex) ;
    win->Erase() ;
    win->Refresh();
    _refresh() ;
}

void
Edit::_Help(Action::Actions act)
{
        if (!read_only) {
          {
         aWindow *tmpWin ;
         win->Message("(Processing help text)") ;
         aString helpFileName = he->programPrefix ;
         helpFileName += "/" ;
         helpFileName += HE_TUTORIAL_FILE_NAME ;
         Help help(he, tmpWin=new aWindow(win->scr, sizey-6, sizex-11,3,5), (const char *)helpFileName) ;

         help.processFile() ;
         help.refresh() ;

         while (!help.finished())
            help.processAction(help.getNextAction()) ;
         // enable to copy text from help
         if (help.file.markActive())
           help._markBlock(1) ;

         delete tmpWin ;
        }
//        win->Erase() ;
        win->Refresh();
        _refresh() ;
        }

}

void
Edit::_Find(Action::Actions act)
{
//        if (!read_only) {
             Marker startm = file.getStartMarker() ;
             Marker endm = file.getEndMarker() ;

             SearchFor *input_line ;

              int c =win->Question(QTN_SEARCH_HEBREW_ENGLISH) ;
              while ((c != 'h')&& (c!='H') && (c!= 'e') && (c!='E'))
                     c =win->Question(QTN_SEARCH_HEBREW_ENGLISH) ;
              int sy, sx ;
              win->scr->GetMaxYX(&sy,&sx) ;
              aWindow *linewin=new aWindow(win->scr,1,sx,sy-1,0,0) ;

              if ((c == 'h') || (c == 'H'))
                   input_line = new SearchForHebrew(he, HEBREW_SEARCH_MESSAGE,linewin,this) ;
              else
                   input_line = new SearchFor(he, ENGLISH_SEARCH_MESSAGE,linewin,this) ;

             Marker current = {current_line, curx-1, cury} ;
             input_line->refresh() ;

             while (!input_line->finished())
                 input_line->processAction(act=input_line->getNextAction()) ;
             win->MessageClear(1) ;
             if (act != Action::NewLine) {
                _relocateAtMarker(current) ;
             }
             delete input_line ;
             delete linewin ;

             file.setStartMarker(startm.line, startm.offset) ;
             file.setEndMarker(endm.line, endm.offset) ;
             _markBlock() ;
             win->Refresh() ;
             _refresh() ;
//        }
}

void
Edit::_FindReplace(Action::Actions act)
{
        if (!read_only) {
             Marker startm = file.getStartMarker() ;
             Marker endm = file.getEndMarker() ;

             SearchFor *input_line ;

              int c =win->Question(QTN_REPLACE_HEBREW_ENGLISH) ;
              while ((c != 'h')&& (c!='H') && (c!= 'e') && (c!='E'))
                     c =win->Question(QTN_REPLACE_HEBREW_ENGLISH) ;
              int sy, sx ;
              win->scr->GetMaxYX(&sy,&sx) ;
              aWindow *linewin=new aWindow(win->scr,1,sx,sy-1,0,0) ;

              if ((c == 'h') || (c == 'H'))
                   input_line = new SearchForHebrew(he, HEBREW_REPLACE_SEARCH_MESSAGE,linewin,this) ;
              else
                   input_line = new SearchFor(he, ENGLISH_REPLACE_SEARCH_MESSAGE,linewin,this) ;

             Marker current = {current_line, curx-1, cury} ;
             input_line->refresh() ;

             while (!input_line->finished())
                 input_line->processAction(act=input_line->getNextAction()) ;
             win->MessageClear(1) ;
             if (act != Action::NewLine) {
                _relocateAtMarker(current) ;
             } else { // begin replacing:
                aString textToReplace = input_line->getText() ;
                SearchFor *input_line2 ;
                if ((c == 'h') || (c == 'H'))
                   input_line2 = new SearchForHebrew(he, HEBREW_REPLACE_WITH_MESSAGE,linewin,0) ;
                else
                   input_line2 = new SearchFor(he, ENGLISH_REPLACE_WITH_MESSAGE,linewin,0) ;
                input_line2->refresh() ;

                while (!input_line2->finished())
                      input_line2->processAction(act=input_line2->getNextAction()) ;
                win->MessageClear(1) ;
                if (act == Action::NewLine) { // the user wants to start replacing
                  int cont = 1 ;
                  int batch_mode = 0 , q = ' ';
                  while (cont) {
                   if (!batch_mode)
                     q = win->Question(QTN_ENGLISH_REPLACE_YES_NO_ALL_CANCEL) ;
                   switch (q) {
                      case 'y':
                      case 'Y': {
                          Marker before = where() ;
                          _deleteDataBlock(before, input_line->getText()) ;
                          _insertDataBlock(before, input_line2->getText()) ;
                          int len = strlen(input_line2->getText()) ;
                          for (int i=0; i<len; i++) _relocate_curx(1) ;
                          Marker after = where() ;
                          undo.record_action(UndoSt::ActReplace, textToReplace, before, after,
                                             startm, endm, input_line2->getText()) ;
                          searchForNext(input_line->getText()) ;
                          if (after.isEqual(where())) cont = 0 ;
                        }
                        break ;
                      case 'n':
                      case 'N': {
                          Marker here = where() ;
                          searchForNext(input_line->getText()) ;
                          if (here.isEqual(where())) cont = 0 ;
			}
                        break ;
                      case 'a':
                      case 'A':
                          q = 'Y' ;
                          batch_mode = 1 ;
                        break ;
                      case 'c':
                      case 'C':
                          cont = 0 ;
                        break ;
                      default:
                        break ;
                   }
                  } // end of while
                  win->MessageClear(1) ;
                  delete input_line2 ;
                }
             } // end else begin replacing
             delete input_line ;
             delete linewin ;
             file.setStartMarker(startm.line, startm.offset) ;
             file.setEndMarker(endm.line, endm.offset) ;
             _markBlock() ;
             win->Refresh() ;
             _refresh() ;
        }
}



void
Edit::_DeleteChar(Action::Actions act)
{
  Marker endm=file.getEndMarker() ;
  Marker startm=file.getStartMarker() ;
  Marker _endm=file.getEndMarker() ;
  Marker _startm=file.getStartMarker() ;
  if (!read_only) {
     Marker before ;
     if (act == Action::DeleteChar) {
        before = where() ;
        if (act != last_action)
           undo.invalidate_current() ;
     } else
        before = work_marker ;

     aString data = ""  ;

    if (curx < (file.line(current_line)).length()) {
      data = ((aString &)(file.line(current_line))).at(curx-1,curx) ;

      (file.line(current_line))._delete_ch(curx, current_offset) ;
      int change = 0 ;
      if ((startm.line == current_line) && (startm.offset > curx-1)) {
        file.setStartMarker(startm.line, startm.offset-1) ;
        change = 1 ;
      }
      if ((endm.line == current_line) && (endm.offset > curx-1)) {
        file.setEndMarker(endm.line, endm.offset-1) ;
        change = 1 ;
      }
      if (change)
        _markBlock() ;
      modified =1  ;
      delay_compilation++ ;
      file.recompile_section(sizex,0) ;
    }
    else if (current_line < file.lines()) {
      undo.invalidate_current() ;
      data += " \n" ;
      int change = 0 ;
      if (startm.line > current_line+1) {
        file.setStartMarker(startm.line-1, startm.offset) ;
        change=1 ;
      } else if (startm.line == current_line+1) {
        file.setStartMarker(startm.line-1, startm.offset + (curx-1)) ;
        change=1 ;
      }
      if (endm.line > current_line+1) {
        file.setEndMarker(endm.line-1, endm.offset) ;
        change=1 ;
      } else if (endm.line == current_line+1) {
        file.setEndMarker(endm.line-1, endm.offset + (curx-1)) ;
        change=1 ;
      }
//      aString tmp = ((aString &)file.line(current_line)).at(0, ((aString&)file.line(current_line)).length()-1) ;
//      tmp+=(const char *)((aString &)file.line(current_line+1)) ;
//      ((aString &)file.line(current_line)) = tmp ;
//      file.delete_line(current_line+1) ; // WATCH FOR TROUBLE HERE
      _deleteDataBlock(where(), (char *)(const char*)data) ;
      if (change)
        _markBlock() ;
      modified = 1 ;
//      file.recompile_section(sizex) ;
    }
    _relocate_curx(0) ;
    _calc_curx() ;
    Marker after = where() ;
    if (act == Action::DeleteChar)
       undo.record_action(UndoSt::ActDelete, data, before, after, _startm, _endm) ;
    else
       undo.record_action(UndoSt::ActBackSpace, data, before, after, _startm, _endm) ;
    _refresh() ;
  }

}

void
Edit::_BackSpace(Action::Actions act)
{
  if (!read_only) {
   if (act != last_action)
     undo.invalidate_current() ;
      work_marker = where() ;
    if (_relocate_curx(-1)) {
      _DeleteChar(act) ;
    } /* end if !read_only */
  }
}

void
Edit::_DeleteLine(Action::Actions act)
{
  undo.invalidate_current() ;
  Marker endm=file.getEndMarker() ;
  Marker startm=file.getStartMarker() ;
  Marker _endm = file.getEndMarker() ;
  Marker _startm = file.getStartMarker() ;
  if (!read_only) {
    // this is done to imitate emacs behavior
    // are we at the end of the line ?
    if (where().offset >= ((aString &)file.line(current_line)).length()-1)
       _Home(Action::Null) ;
    Marker before = where() ;
    aString data = "" ;
    int changed = 0 ;

    // if (file.lines() > 1)  // there is no need for that anymore, since DeleteLine does not
                              // actually delete lines from the file, it let's DeleteChar handle
                              // that.
    {
      if (current_line == file.lines()) { // THE LAST LINE IS BEING DELETED
        // the last line is also the only marked line
        if ((startm.line == endm.line) && (startm.line == current_line)) {
          file.unmarkBlock() ;
          _markBlock() ;
        } else // are we trying to delete a last marked line ?
          if ((endm.line == current_line) && (endm.line > startm.line)) {
         //   endm.line-- ;
            endm.offset = where().offset ; // ((aString &)(file.line(current_line-1))).length() ;
            file.setEndMarker(endm.line, endm.offset) ;
            changed = 1 ;
          }

        data += ((aString &)file.line(current_line)).at(where().offset, ((aString&)file.line(current_line)).length()-1) ;
//        _previous_line() ;
//        _End(Action::Null) ;
        Marker after = where() ;
//        data += '\n' ;
//        data += ((aString &)file.line(current_line+1)).at(0, ((aString&)file.line(current_line+1)).length()-1) ;
//        file.delete_line(current_line+1) ;
        _deleteDataBlock(where(), (char *)(const char*)data) ;
        undo.record_action(UndoSt::ActDelete, data, before, after, _startm, _endm) ;
        // if we are at the beginning of the line, only then perform a backspace
        if (where().offset == 0)
          _BackSpace(Action::BackSpace) ;
      } else { // STILL MORE LINES AHEAD
        if ((startm.line == endm.line) && (startm.line == current_line)) {
          file.unmarkBlock() ;
          changed = 1;
        } else
          if ((endm.line == current_line) && (endm.line > startm.line)) {
            // endm.line-- ;
            endm.offset = where().offset ; // ((aString &)(file.line(current_line-1))).length() ;
            file.setEndMarker(endm.line, endm.offset) ;
            changed = 1 ;
          } else
            if ((startm.line == current_line) && (startm.line < endm.line) && (startm.offset >= where().offset)) {
              startm.offset = 0 ;
              startm.line++ ;
              file.setStartMarker(startm.line, startm.offset) ;
//              endm.line-- ;
              file.setEndMarker(endm.line, endm.offset) ;
              changed = 1 ;
            } /* else {
              if (startm.line > current_line) {
                changed=1 ;
                file.setStartMarker(startm.line-1, startm.offset) ;
              }
              if (endm.line > current_line) {
                changed=1 ;
                file.setEndMarker(endm.line-1, endm.offset) ;
              }
            }    */
        Marker after = before ;
        data += ((aString &)file.line(current_line)).at(where().offset, ((aString&)file.line(current_line)).length()-1) ;
//        data += '\n' ;
//        file.delete_line(current_line) ;
        _deleteDataBlock(where(), (char *)(const char*)data) ;
        undo.record_action(UndoSt::ActDelete, data, before, after, _startm, _endm) ;
        if (where().offset == 0) {
          _BackSpace(Action::BackSpace) ;
          _NextLine(Action::NextLine) ;
          _Home(Action::Home) ;
        }
      }
      if (changed)
        _markBlock() ;
      modified = 1 ;
    } /*
    else { // there is only a single line in the file
      // _Home(Action::Null) ;
      Marker after = before ;
      data += ((aString &)file.line(1)).at(before.offset, ((aString&)file.line(1)).length()-1) ;
      undo.record_action(UndoSt::ActDelete, data, before, after, _startm, _endm) ;
      _deleteDataBlock(before, (char *)(const char *)data) ;
//      (aString &)(file.line(1)) = " " ; // clear the first line
      file.unmarkBlock() ;
      _markBlock() ;
      modified = 1 ;
    }   */
//    file.recompile_section(sizex) ;
    _refresh() ;
  }
  _relocate_curx(0) ;
}

void
Edit::_SaveFile(Action::Actions act)
{
  if (!read_only) {
    if (file.write_file()) {
       win->Message(MSG_FILE_SAVED) ;
       undo.saved_here() ;
       modified = 0 ;
    } else {
       win->Message(MSG_UNABLE_TO_SAVE_FILE) ;
    }
  }
}

void
Edit::_Refresh(Action::Actions act)
{
   win->TemporaryExit(1) ;
   win->GetMaxYX(&sizey,&sizex) ;
//   --sizey ;
   file.recompile_file(sizex) ;
//   win->Erase() ;
//   win->scr->Refresh() ;
   win->Refresh();
   _refresh() ;

}


void
Edit::_SpellWord(Action::Actions act)
{
  // find current word  
   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   while ( (strchr(LETTERS,ch)) && ((current_line > 1) || (curx > 1))) {
        _RealBackwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   if ( (!strchr(LETTERS,ch))){
        _RealForwardChar(act) ;
   }
   aString word = "" ;
   int count = 0 ;
   if ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_HEBREW_WORD) {
     while ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_HEBREW_WORD) {
        word +=  ((aString &)file.line(current_line)).at(curx-1,curx) ;
        count++ ;
       _RealForwardChar(act) ;
     }
     for (;count>0; count--) _RealBackwardChar(act) ;
     suggestWords(he->hebrewDictionary, word) ;
   }
   if ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_ENGLISH_WORD) {
     while ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_ENGLISH_WORD) {
        word +=  ((aString &)file.line(current_line)).at(curx-1,curx) ;
        count++ ;
       _RealForwardChar(act) ;
     }
     for (;count>0; count--) _RealBackwardChar(act) ;
     suggestWords(he->englishDictionary, word) ;
   }
//   if ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_LAXET_COMMAND) {
//     while ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==INVALID_LAXET_COMMAND) {
//        word +=  ((aString &)file.line(current_line)).at(curx-1,curx) ;
//        count++ ;
//       _RealForwardChar(act) ;
//     }
//     for (;count>0; count--) _RealBackwardChar(act) ;
//     suggestWords(he->laxetDictionary, word) ;
//   }
//   exit(1) ;
}

#define MAX_SPELLING_RESULTS 10

char *
Edit::suggestWords(aDictionary *dict, aString &word) {
   if (!read_only) {
     Marker startm = file.getStartMarker() ;
     Marker endm = file.getEndMarker() ;
//     Marker current = {current_line, curx-1, cury} ;

     static char *results[MAX_SPELLING_RESULTS] ;
     int results_count ;
     dict->findMatchingWords(5,(char *)(const char*)word, results, results_count, MAX_SPELLING_RESULTS) ;
        aSelectionBox<char *> sb(he, 0, "Close matches", win->scr) ;
      for (int i=0 ; i<results_count; i++) {
       sb.addMember(results[i], results[i], 0) ;
     }

     char *response = sb.select() ;
     he->currentEditBuffer->refresh() ;
     char msg[1000] ;
     if (response) {
             sprintf(msg,"Replace '%s' with '%s' (Yes/No/All/Cancel) ?  ",
              (char *)(const char*)word, response) ;
             searchFor((char *)(const char *)word) ;
             int cont = 1 ;
             int batch_mode = 0 , q = ' ';
             while (cont) {
                      if (!batch_mode)
                        q = win->Question(msg) ;
                      switch (q) {
                         case 'y':
                         case 'Y': {
                             Marker before = where() ;
                             _deleteDataBlock(before, (char *)(const char *)word) ;
                             _insertDataBlock(before, response) ;
                             int len = strlen(response) ;
                             for (int i=0; i<len; i++) _relocate_curx(1) ;
                             Marker after = where() ;
                             undo.record_action(UndoSt::ActReplace, word,
                                         before, after,
                                         startm, endm, response) ;
                             searchForNext((char *)(const char *)word) ;
                             if (after.isEqual(where())) cont = 0 ;
                           }
                           break ;
                         case 'n':
                         case 'N': {
                             Marker here = where() ;
                             searchForNext((char *)(const char *)word) ;
                             if (here.isEqual(where())) cont = 0 ;
			   } 
		  	   break ;
                         case 'a':
                         case 'A':
                             q = 'Y' ;
                             batch_mode = 1 ;
                           break ;
                         case 'c':
                         case 'C':
                             cont = 0 ;
                           break ;
                         default:
                           break ;
                      }
                     } // end of while
                     win->MessageClear(1) ;
                file.setStartMarker(startm.line, startm.offset) ;
                file.setEndMarker(endm.line, endm.offset) ;
                _markBlock() ;
      } else {
          int resp=win->Question("Would you like to add this word to your local dictionary (Yes/No) ?  ") ;
          win->MessageClear(1) ;
          if (strchr("yY",resp)) {
              dict->recordBadWordsOn() ;
              dict->findMatch((char *)(const char *)word) ;
              dict->recordBadWordsOff() ;
              file.recompile_file(sizex) ;
          }
          refresh() ;
      }
     return response ;
  } // end of if !read_only
  return (char *)NULL ;
}

void
Edit::_LearnAllWords(Action::Actions act)
{
   he->englishDictionary->recordBadWordsOn() ;
   he->hebrewDictionary->recordBadWordsOn() ;
   he->laxetDictionary->recordBadWordsOn() ;
   file.recompile_file(sizex) ;
   he->englishDictionary->recordBadWordsOff() ;
   he->hebrewDictionary->recordBadWordsOff() ;
   he->laxetDictionary->recordBadWordsOff() ;
   win->Refresh();
   _refresh() ;

}


void
Edit::_NewLine(Action::Actions act)
{
  undo.invalidate_current() ;
  Marker endm=file.getEndMarker() ;
  Marker startm=file.getStartMarker() ;
  Marker _endm=file.getEndMarker() ;
  Marker _startm=file.getStartMarker() ;
  if (!read_only) {
    Marker before = where() ;
    aString data = "" ;
    int changed = 0 ;
    if ((startm.line == current_line) && (startm.offset+1 > curx)) {
      startm.line++ ;
      startm.offset -= (curx-1) ;
      changed = 1 ;
    } else if (startm.line > current_line) {
      startm.line++ ;
      changed = 1 ;
    }
    if ((endm.line == current_line) && (endm.offset >= curx)) {
      endm.line++ ;
      endm.offset -= (curx-1) ;
      changed = 1 ;
    } else if (endm.line > current_line) {
      endm.line++ ;
      changed = 1 ;
    }
//    int len = ((aString &)file.line(current_line)).length() ;
//    if (!(((aString &)file.line(current_line)).at(len-1,len) == " "))
      data += _newline() ;
    if (changed) {
      file.setStartMarker(startm.line, startm.offset) ;
      file.setEndMarker(endm.line, endm.offset) ;
      _markBlock() ;
    }
    Marker after = where() ;
    if (act == Action::NewLine)
      undo.record_action(UndoSt::ActInsert, data, before, after, _startm, _endm) ;

     _refresh() ;
    modified = 1 ;
  // take care of autoindent
  }
}

void
Edit::_Exit(Action::Actions act)
{
  if (!(name == SCRATCH_BUFFER_NAME)) {
    if (file.markActive() && (!read_only))
       _markBlock(1) ;
    int c='y' ;
    if (undo.is_modified() && _need_to_save())  {
       c=win->Question(QTN_LOOSE_CHANGES) ;
   }
    while ((c != 'y')&& (c!='Y') && (c!= 'n') && (c!='N'))
        c=win->Question(QTN_LOOSE_CHANGES) ;
    if ((c == 'n') || (c == 'N')) {
          win->MessageClear() ;
          _refresh() ;
    } else {
//        win->Erase() ;
        win->Refresh() ;
        continue_edit = FALSE ;
     }
  }
}

void
Edit::_RealForwardChar(Action::Actions act)
{
  _relocate_curx(1) ;
}

void
Edit::_RealBackwardChar(Action::Actions act)
{
  _relocate_curx(-1) ;
}

void
Edit::_NextLogicalWord(Action::Actions act)
{
   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   while ( (strchr(LETTERS,ch)) && ((current_line < file.lines()) || (curx < ((aString&)file.line(current_line)).length()))) {
        _RealForwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   while ( (!strchr(LETTERS,ch)) && ((current_line < file.lines()) || (curx < ((aString&)file.line(current_line)).length()))) {
        _RealForwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
}

void
Edit::_PreviousLogicalWord(Action::Actions act)
{
   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   while ( (strchr(LETTERS,ch)) && ((current_line > 1) || (curx > 1))) {
        _RealBackwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   while ( (!strchr(LETTERS,ch)) &&((current_line > 1) || (curx > 1))) {
        _RealBackwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
}

void
Edit::_WordRight(Action::Actions act)
{
   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   int cur_line = current_line ;
   int cur_x = curx ;
   int ocur_line ;
   int ocur_x = 0 ;

   while ( (strchr(LETTERS,ch)) && ((cur_line != ocur_line) || (cur_x != ocur_x)) ) {
        ocur_line = cur_line ;
        ocur_x = cur_x ;
         _ForwardChar(act) ;
        cur_line = current_line ;
        cur_x = curx ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   while ( (!strchr(LETTERS,ch)) &&((cur_line != ocur_line) || (cur_x != ocur_x)) ) {
        ocur_line = cur_line ;
        ocur_x = cur_x ;
        _ForwardChar(act) ;
        cur_line = current_line ;
        cur_x = curx ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
}

void
Edit::_WordLeft(Action::Actions act)
{
   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   int cur_line = current_line ;
   int cur_x = curx ;
   int ocur_line = 0 ;
   int  ocur_x = 0 ;

   while ( (strchr(LETTERS,ch)) && ((cur_line != ocur_line) || (cur_x != ocur_x)) ) {
        ocur_line = cur_line ;
        ocur_x = cur_x ;
         _BackwardChar(act) ;
        cur_line = current_line ;
        cur_x = curx ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   while ( (!strchr(LETTERS,ch)) &&((cur_line != ocur_line) || (cur_x != ocur_x)) ) {
        ocur_line = cur_line ;
        ocur_x = cur_x ;
        _BackwardChar(act) ;
        cur_line = current_line ;
        cur_x = curx ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
}


void
Edit::_ForwardChar(Action::Actions act)
{
  _forward() ;
}

void
Edit::_BackwardChar(Action::Actions act)
{
  _backward() ;
}

void
Edit::_NextLine(Action::Actions act)
{
   action.getLastChar() ;
   _next_line() ;
}

void
Edit::_PreviousLine(Action::Actions act)
{
   action.getLastChar() ;
   _previous_line() ;
}

void
Edit::_Home(Action::Actions act)
{
  for (;curx >1; _relocate_curx(-1)) ;
}

void
Edit::_End(Action::Actions act)
{
  int tmp = file.line(current_line).length() ;
  for (;curx<tmp ; _relocate_curx(+1)) ;
}

void
Edit::_BeginningOfFile(Action::Actions act)
{
  for (;current_line>1 ; _previous_page(0)) ;
  for (;curx>1; _relocate_curx(-1)) ;
  win->Refresh() ;
  _refresh() ;
}

void
Edit::_EndOfFile(Action::Actions act)
{
  for (;(current_line < file.lines()) ||
       ((current_line == file.lines()) &&
        (current_offset <
         (file.line(current_line)).line_count(sizex) - 1)) ;
       _next_page(0)) ;
  _End(Action::Null) ;
  win->Refresh() ;
  _refresh() ;
}

void
Edit::_PgUp(Action::Actions act)
{
  _previous_page() ;
  esc = 0 ;
}

void
Edit::_PgDn(Action::Actions act)
{
  _next_page() ;
  esc = 0 ;
}

void
Edit::_Char(Action::Actions act)
{
   int ch = action.getLastChar() ;
   Marker startm = file.getStartMarker() ;
   Marker endm = file.getEndMarker() ;
   Marker _startm = file.getStartMarker() ;
   Marker _endm = file.getEndMarker() ;

   if (act != last_action)
     undo.invalidate_current() ;

   if (!read_only) {
     Marker before = where() ;
     aString data = ""  ;

     int changed = 0 ;
     int add = (file.line(current_line))._insert_ch(curx,current_offset,
                                                    input.translate_char(ch),
                                                    _x_position) ;
     data+= input.translate_char(ch) ;
     if ((startm.line == current_line) && (startm.offset+1 > curx)) {
       startm.offset++ ;
       changed = 1 ;
     }
     if ((endm.line == current_line) && (endm.offset >= curx)) {
       endm.offset++ ;
       changed = 1 ;
     }

     if (changed) {
       file.setStartMarker(startm.line, startm.offset) ;
       file.setEndMarker(endm.line, endm.offset) ;
       _markBlock() ;
     }

     delay_compilation++ ;
//     file.recompile_section(sizex, 0) ; // 0 tells recompile_section to not continue after the first line
     _relocate_curx(add) ;
     win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
     modified = 1 ;
     _calc_curx() ;
     Marker after = where() ;
     undo.record_action(UndoSt::ActInsert, data, before, after, _startm, _endm) ;
     _refresh() ;
   }
}


void
Edit::_Undo(Action::Actions act)
{
   undo.undo_last_action() ;
   _relocate_curx(0) ;
   int last = undo.get_last_saved() ;
   sprintf(buffer, "Undo: %d of %d..+%d modifications since last save", undo.get_current()-last,-last, undo.get_count()-last) ;
   win->Message(buffer) ;
   _refresh() ;
}

void
Edit::_Redo(Action::Actions act)
{
   undo.redo_last_action() ;
   _relocate_curx(0) ;
   int last = undo.get_last_saved() ;
   sprintf(buffer, "Redo: %d of %d..+%d modifications since last save", undo.get_current()-last,-last, undo.get_count()-last) ;
   win->Message(buffer) ;
   _refresh() ;
}

void
Edit::_LaxetCommandHelp(Action::Actions act)
{
  // find current word  
   if ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())!=VALID_LAXET_COMMAND) {
      win->scr->TemporaryExit(0,"latexman asdf",1) ;
      refresh() ;
      return ;
   }

   aString chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
   char ch = *(const char *)(chr) ;
   if (ch == '\\') { 
      _RealForwardChar(act) ;
      chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
      ch = *(const char *)(chr) ;
   }

   while ( (strchr(LETTERS,ch)) && ((current_line > 1) || (curx > 1))) {
        _RealBackwardChar(act) ;
        chr = ((aString &)file.line(current_line)).at(curx-1,curx) ;
        ch = *(const char *)(chr) ;
   }
   if ( (!strchr(LETTERS,ch))){
        _RealForwardChar(act) ;
   }
   aString word = "" ;
   int count = 0 ;
   if ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==VALID_LAXET_COMMAND) {
     while ((file.line(current_line)).getCurrentXcode(current_offset,_x_pos())==VALID_LAXET_COMMAND) {
        word +=  ((aString &)file.line(current_line)).at(curx-1,curx) ;
        count++ ;
       _RealForwardChar(act) ;
     }
     for (;count>0; count--) _RealBackwardChar(act) ;
     char buffer[100] ;
     sprintf(buffer, "latexman \\%s", (char *)(const char *)word) ;
     win->scr->TemporaryExit(0,buffer,1) ;
     refresh() ;
   }
}

