/***************************************************************************
                          HebrewEditor.h  -  HebrewEditor main class
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __HebrewEditor_h__
#define __HebrewEditor_h__

#include "Edit.h"
#include "LineEdit.h"
#include "aWindow.h"
#include "Action.h"
#include "aDictionary.h"
#include "sysdep.h"

struct menuItem {
  char *name ;
  Action::Actions act ;
  const char *comment ;
} ;

/**
  *@author Arie Tal
  */

class HebrewEditor {
public:
  Edit *scratch ;
  Edit *currentEditBuffer ;
  char *programPrefix ;
  Action *globalActionManager ;
  aDictionary *englishDictionary ;
  aDictionary *laxetDictionary ;
  aHebrewDictionary *hebrewDictionary ;
  aString primaryFile ;
  aString lastDviFile;
  Edit **buffers ;
  SCREEN *screen ;
  int bufferCount ;
  int sizey, sizex ;
  int list_buffers(Edit **buffers, int buffer_count, Screen* scr,
                 int current_buffer) ;
  Action::Actions main_menu(Screen *scr,Action &act) ;
  Action::Actions search_menu(Screen *scr,Action &act) ;
  Action::Actions edit_menu(Screen *scr,Action &act) ;
  Action::Actions file_menu(Screen *scr,Action &act) ;
  Action::Actions latex_menu(Screen *scr,Action &act) ;
  Action::Actions MenuSelect(char *title, menuItem *menu,
       int count, Screen *scr, Action &act) ;


public:
	HebrewEditor(int argc, char **argv) ;
	~HebrewEditor() ;
	void appMain() ;
	
	/**
	 * Return a pointer to the scratch Edit buffer
	 */
	 Edit *getScratchBuffer() {
	    return scratch ;
	 }
	
	 /**
	  * Return a pointer to the current Edit buffer
	  */
	 Edit *getCurrentEditBuffer() {
	    return currentEditBuffer ;
	 }
	
	 /**
	  * Return the prefix path to the program (default /usr/local)
	  */
	 char *getProgramPrefix() {
	    return programPrefix ;
	 }
	
	
	 /**
	  * Return a pointer to the global action manager (event engine)
	  */
	 Action *getGlobalActionManager() {
	    return globalActionManager ;
	 }
};

#endif
