/***************************************************************************
                          Input.cxx - Keyboard translation handler
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Input.h"

Input::Input(int startHebrew, InputMode initial_mode) : mode(initial_mode),
               StartHebrew(startHebrew) 
{
   TableO=strdup("@ABCDEFGHIJKLMNOPQRSTUVWXYZ") ;
   TableI=strdup("tcdsvuzjyhlfkonibxg;p.mera,") ;
   TableO2=strdup("/,;.\'") ;
   TableI2=strdup("q\'`/w") ;
}

char
Input::translate_char(int ch)
{
   char *ptr ;

   if (mode == hebrew) {
     if ((ptr=strchr(TableI,ch)) != NULL) 
       return *(TableO+(ptr-TableI))+StartHebrew-'@' ;
     if ((ptr=strchr(TableI2,ch)) != NULL)
       return *(TableO2+(ptr-TableI2)) ;
   }
   return ch ; 
}
void
Input::set_mode(InputMode newMode)
{
   mode = newMode ;
}
