/***************************************************************************
                          LineEdit.cxx - Single line editing based on Edit
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "LineEdit.h"
#include "aSelectionBox.h"
#include "HebrewEditor.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include "sysdep.h"

void
GetFileName::_Tab(Action::Actions act)
{
   char *cwd = "." ;
   char namebuff[1000] = "" ;
   char pattern[1000] = "" ;
   char lastselected[1000] = "" ;
   char *str = getText() ;
   char *strp = strrchr(str, '/') ;
   if (strp) {
     strncpy(namebuff,str, 1+strp-str) ;
     namebuff[2+strp-str] = '\0' ;
     if (*(strp+1))
       strcpy(pattern,1+strp) ;
   } else {
     strcpy(pattern, str) ;
   }


   if (*namebuff)
      cwd = strdup(namebuff) ;
   dirent *dp ;
   struct stat stt ;
   int ret ;
   int count = 0 ;

   DIR *dirp = opendir(cwd);
   if (dirp) {
     aSelectionBox<char *> sb(he, 0, "Select file(s)", win->scr) ;
     while ((dp = readdir(dirp)) != NULL) {
      if (!strncmp(dp->d_name, pattern, strlen(pattern))) {
        sprintf(namebuff, "%s/%s", cwd, dp->d_name) ;
        ret = LSTAT(namebuff, &stt) ;
        strcpy(namebuff, dp->d_name) ;
         if (stt.st_mode & S_IFREG) {
           char *str = strdup(namebuff) ; // memory leak!
           sb.addMember(str, str, 0) ;
           strcpy(lastselected, str) ;
           count++ ;
         } else
         if (stt.st_mode & S_IFDIR) {
           strcat(namebuff,"/") ;
           char *str = strdup(namebuff) ;
           sb.addMember(str,str, 0) ;
           strcpy(lastselected, str) ;
           count++ ;
         }
       }
     }
     closedir(dirp) ;

     char *selection = lastselected ;

     if (count > 1) {
       selection = sb.select() ;
     }

     if (selection) {
       Marker location={1, strlen(str), -1} ;
       _insertDataBlock(location,selection+strlen(pattern)) ;
       _End(Action::End) ;
     }
     win->Refresh() ;
     _refresh() ;
     he->currentEditBuffer->refresh() ;
   }
}
