/***************************************************************************
                          LineEdit.h - Single line editing based on Edit
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __LineEdit_h__
#define __LineEdit_h__

#include "Edit.h"

class LineEdit : public Edit{
protected:
   Edit *slave ;
   aString prefix ;
   aString work ;
protected:
   virtual int _need_to_save() { return 0 ; }
   virtual void _maketitle(int show=0) { Edit::_maketitle(0) ; } ;
   virtual int  getActiveSpelling() { return 0 ; }
// MESSAGE HANDLERS
public:
   virtual void _LaxetCommandHelp(Action::Actions act) { return ; }
   virtual void _SpellWord(Action::Actions act) { return ; }
   virtual void _LearnAllWords(Action::Actions act) { return ; }
   virtual void _Tab(Action::Actions act) { return ; }
   virtual void _MarkBlockBegin(Action::Actions act) { return ; }
   virtual void _MarkBlockEnd(Action::Actions act) { return ; }
   virtual void _UnmarkBlock(Action::Actions act) { return ; }
   virtual void _DeleteBlock(Action::Actions act) { return ; }
   virtual void _CopyBlock(Action::Actions act) { return ;}
   virtual void _MoveBlock(Action::Actions act) { return ; }
   virtual void _Suspend(Action::Actions act) { return ; }
   virtual void _Help(Action::Actions act) {return ; }
   virtual void _Find(Action::Actions act) { return ; }
//   virtual void _DeleteChar(Action::Actions act) ;
   virtual void _BackSpace(Action::Actions act) { if (curx > 1) Edit::_BackSpace(act) ; }
//   virtual void _DeleteLine(Action::Actions act) ;
   virtual void _SaveFile(Action::Actions act) { return ; }
//   virtual void _Refresh(Action::Actions act)
   virtual void _NewLine(Action::Actions act) { _Exit(act) ; }
   virtual void _Exit(Action::Actions act)  { modified = 0 ; Edit::_Exit(act) ; }
//   virtual void _RealForwardChar(Action::Actions act) ;
   virtual void _RealBackwardChar(Action::Actions act) { if (curx > 1) Edit::_RealBackwardChar(act) ; }
   virtual void _ForwardChar(Action::Actions act) {
            if (((file.line(current_line)).getMajorMode() == StrHebrew)  && (curx == 1)) return ;
            Edit::_ForwardChar(act) ;
    }
   virtual void _BackwardChar(Action::Actions act) {
            if (((file.line(current_line)).getMajorMode() == StrEnglish)  && (curx == 1)) return ;
            Edit::_BackwardChar(act) ;
  }
   virtual void _NextLine(Action::Actions act) { return ; }
   virtual void _PreviousLine(Action::Actions act) { return ; }
//   virtual void _Home(Action::Actions act) ;
//   virtual void _End(Action::Actions act) ;
   virtual void _BeginningOfFile(Action::Actions act) { return ; }
   virtual void _EndOfFile(Action::Actions act) { return ; }
   virtual void _PgUp(Action::Actions act) { return ; }
   virtual void _PgDn(Action::Actions act) { return ; }
   virtual void _Char(Action::Actions act) { if (_inputFilter(act)) Edit::_Char(act) ; }
   virtual int    _inputFilter(Action::Actions act) { return 1 ; }
public:
   LineEdit(HebrewEditor *he, const char *_prefix, aWindow *win, Edit *slave) :
      Edit(he, _prefix,win), slave(slave), prefix(_prefix) {
//         sizey = 2 ;
         file.deactivateSpelling() ; // we don't want spelling in lines
         screen_start_line = 0 ; // win->getLastLineNum() ;
         prefix = "     "  ;
         prefix += _prefix ;
         screen_start_column =  prefix.length() ;
         sizex-= screen_start_column ;
         processFile(0) ;
   }
  // SINCE LINEEDITS are leaches on existing windows, line edit is not allowed to delete
  // the window.
  ~LineEdit() { } // turn on the dirty message bit

   virtual void refresh() {
       win->MessageClear() ;
       win->MVAddStr(screen_start_line,0, (char *)(const char *)prefix) ;
       _refresh() ;
   }
   virtual void processAction(Action::Actions act) {
         win->MVAddStr(screen_start_line, 0, (char *)(const char *)prefix) ;
         Edit::processAction(act) ;
         win->MVAddStr(screen_start_line, 0, (char *)(const char *)prefix) ;
         win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
         win->Refresh() ;
   }
   virtual char *getText() {
      aString tmp=(char *)(const char *)((aString &)(file.line(file.lines()))) ;
      if (tmp.length() > 0)
            work=tmp.at(0,tmp.length()-1) ; // remove the last ' '
      return (char *)(const char *)work ;
   }
} ;



#define FILENAMECHARS "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789~./_-+=:"

class GetFileName : public LineEdit {
public:
    virtual void _Tab(Action::Actions act) ; // implement file completion
    GetFileName(HebrewEditor *he, char *prefix, aWindow *win, char *initial_text=0) :
      LineEdit(he, prefix,win,0) {
        if (initial_text) {
          (aString &)(file.line(1)) = initial_text ;
          processFile(0) ;
          Edit::_End(Action::Null) ;
        }
    }
protected:
    virtual int _inputFilter(Action::Actions act) {
       int ch =  input.translate_char(action.getLastChar()) ;
       if (strchr(FILENAMECHARS, ch))
            return 1 ;
       return 0 ;
    }
} ;

#define NUMBERCHARS "0123456789"

class GetNumber : public LineEdit {
public:
    GetNumber(HebrewEditor *he, char *prefix, aWindow *win) : LineEdit(he, prefix,win,0) {}
protected:
    virtual int _inputFilter(Action::Actions act) {
       int ch =  input.translate_char(action.getLastChar()) ;
       if (strchr(NUMBERCHARS, ch))
            return 1 ;
       return 0 ;
    }
} ;

class SearchFor : public LineEdit {
public:
    SearchFor(HebrewEditor *he, char *prefix, aWindow *win, Edit *slave) :
       LineEdit(he, prefix,win,slave) {}
    virtual void processAction(Action::Actions act) {
      LineEdit::processAction(act) ;
      if (act != Action::Exit) {
          if ((act == Action::Find)  || (act == Action::NextLine)) {
             if (slave)
               slave->searchForNext(getText()) ;
         } else if (act == Action::PreviousLine) {
             if (slave)
               slave->searchForPrevious(getText()) ;
         } else if (slave)
               slave->searchFor(getText()) ;
       }
       win->MVAddStr(screen_start_line, 0, (char *)(const char *)prefix) ;
       win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
       win->Refresh() ;
    }
} ;

class SearchForHebrew : public SearchFor {
    aString hebrewPrefix ;
public:
    SearchForHebrew(HebrewEditor *he, char *prefix, aWindow *win, Edit *slave) :
       SearchFor(he, "",win,slave), hebrewPrefix(prefix) {
       sizex -= hebrewPrefix.length()+2 ;
       (aString &)(file.line(1)) = "\\sethebrew " ;
       file.insert_after(1," ") ;
       processFile(0) ;
       Edit::_EndOfFile(Action::Null) ;
    }

    virtual void processAction(Action::Actions act) {
       SearchFor::processAction(act) ;
       win->MVAddStr(screen_start_line, sizex+5, (char *)(const char *)hebrewPrefix) ;
       win->Move(cury-1+screen_start_line,_x_pos()+screen_start_column) ;
       win->Refresh() ;
    }

   virtual void refresh() {
       win->MessageClear(1) ;
       win->MVAddStr(screen_start_line,sizex+5, (char *)(const char *)hebrewPrefix) ;
       _refresh() ;
   }
} ;


#endif
