/***************************************************************************
                          List.h - Linked list template implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __List_h_
#define __List_h_

// Declar a doubly linked list template for general use

template <class T>
class ListItem {
  T *data ;
  ListItem *prev, *next ;
public:
  ListItem(T *dta, ListItem *prv=NULL, ListItem *nxt=NULL) :
	data(dta), prev(prv), next(nxt) {}
  T *get_data() { return data ; }
  void set_data(T *newData) { data = newData ; }
  ListItem *get_next() { return next ; }
  void set_next(ListItem *nxt) { next = nxt ; }
  ListItem *get_prev() { return prev ; }
  void set_prev(ListItem *prv) { prev = prv ; }
  void insert_before(ListItem *current) {
    if (current) {
      ListItem<T> *prv = (*current).get_prev() ;
      next = current ;
      prev = prv ;
      (*current).set_prev( this ) ;
      if (prv) (*prv).set_next( this ) ;
    } 
  }
  void insert_after(ListItem *current) {
    if (current) {
      ListItem<T> *nxt = (*current).get_next() ;
      next = nxt;
      prev = current;
      (*current).set_next( this ) ;
      if (nxt) (*nxt).set_prev( this ) ;
    } 
  }
  void del() {
    if (next) (*next).set_prev( prev ) ;
    if (prev) (*prev).set_next( next ) ;
  }
} ;

enum ListLocation { First, Last , Current, Next, Previous } ;

template <class T>
class List {
  ListItem<T> *first, *last, *current ;
  ListLocation location ;
public:
  List() : first(NULL), last(NULL), current(NULL), location(First) {}
  T *get_item(ListLocation where=Current) {
     move_to(where) ;
     if (current)
	return (*current).get_data() ;
     return (T *)0 ;
  }
  void move_to(ListLocation where) {
    switch(where) {
       case First:
	  current = first ;
	  location = Current ;
	  if (!current) location = where ;
	  break ;
       case Last:
	  current = last ;
	  location = Current ;
	  if (!current) location = where ;
	  break;
       case Next:
	  if (current) {
	     current = (*current).get_next() ;
	     location = Current ;
	     if (!current)  location = Last ;
          }
	  break ;
       case Previous:
	  if (current) {
	     current = (*current).get_prev() ;
	     location = Current ;
	     if (!current)  location = First ;
          }
	  break ;
       default: ;
    }
  }
  void insert(T *dta) { // inserts an object after current
     ListItem<T> *newItem = new ListItem<T>(dta) ;
     if (current) {
       (*newItem).insert_before(current) ;
       if (first == current)
	  first = newItem ;
     } else {
       if (location == First) {
	  (*newItem).insert_before(first) ;
	  first = newItem ;
	  location = Current ;
	  if (!last) last = newItem ;
       }
       if (location == Last) {
	   (*newItem).insert_after(last) ;
	   last = newItem ;
	   location = Current ;
	   if (!first) first = newItem ;
       }
       // else location is Current, and current is null which should not happen
     }
     current = newItem ;
  }
  void del() { // deletes the current item, locating the iterator on the next
		  // item.
     if (current) {
        ListItem<T> *nxt = (*current).get_next() ;
	ListItem<T> *prv = (*current).get_prev() ;
	(*current).del() ;
	if (first == current) first = nxt ;
	if (last == current) last = prv ; /* i.e. NULL */
	delete current ;
	current = nxt ;
	if (!current) location = Last ;
      }
   }
} ;

#endif
