/***************************************************************************
                          Locations.cxx - Handle position specific info
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Locations.h"
#include <string.h>
#include <stdio.h>

Location* Locations::workArea=new Location[MAX_SCREEN_WIDTH] ;

Location Locations::operator[](int n)
{
    result = _locs[n] ;
    if (result<0) result.setOffset(-(int)result) ;

    if (result == SPLIT_VALUE) return result ;

    result = (int)result + _minVal ;

    if (_locs[n] >= 0) return result ;
    result.setOffset(-(int)result) ;
    return result ;
}

void
Locations::clearCodes()
{
    for (int i=0; i<_locs.get_size() ; i++) {
       _locs[i].setCode(0) ;
    }
}


void Locations::addLeft(char *buf, hebStringMode mode, char code) {
    int len = strlen(buf) ;
    for (int i=0 ; i<len; i++) {
       workArea[i] = _last+i+1 ;
       if (mode == StrHebrew) workArea[i] = -workArea[i] ;
       workArea[i].setCode(code) ;
    }
    _last += len ;
    _locs.prepend(workArea, len) ;
}

void Locations::addLeft(aString str, hebStringMode mode, char code) {
   addLeft((char *)(const char *)str, mode), code ;
}

void Locations::addLeft(Locations &l) {
   _locs.prepend(l._locs) ;
   if ((l._last > _last) && (l._last != SPLIT_VALUE))
      _last = l._last ;
}

void Locations::addLeft(Locations *l) {
   if (l)
      addLeft(*l) ;
}


void Locations::addRight(char *buf, hebStringMode mode, char code) {
    int len = strlen(buf) ;
    for (int i=0 ; i<len; i++) {
       workArea[i] = _last+i+1 ;
       if (mode == StrHebrew) workArea[i] = -workArea[i] ;
       workArea[i].setCode(code) ;
    }
    _last += len ;
    _locs.append(workArea, len) ;
}


void Locations::addRight(aString str, hebStringMode mode, char code) {
   addRight((char *)(const char *)str, mode, code) ;
}

void Locations::addRight(Locations &l) {
   _locs.append(l._locs) ;
   if ((l._last > _last) && (l._last != SPLIT_VALUE))
      _last = l._last ;
}

void Locations::addRight(Locations *l) {
   if (l)
      addRight(*l) ;
}


void Locations::addSplitsLeft(int num, hebStringMode mode) {
    for (int i=0 ; i<num; i++) {
       workArea[i] = SPLIT_VALUE ;
       if (mode == StrHebrew) workArea[i] = -workArea[i] ;
    }

    _locs.prepend(workArea, num) ;
}

void Locations::addSplitsRight(int num, hebStringMode mode) {
    for (int i=0 ; i<num; i++) {
       workArea[i] = SPLIT_VALUE ;
       if (mode == StrHebrew) workArea[i] = -workArea[i] ;
    }
    _locs.append(workArea, num) ;
}

//void Locations::print()
//{
//    cout << "[" << _last << "]{" ;
//
//     for (int i=0; i<_locs.get_size() ;i++)
//        cout << _locs[i] << "," ;
//     cout << "}" << endl ;
//}




