/***************************************************************************
                          Locations.h - Handle position specific info
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __Locations_h__
#define __Locations_h__

#include "Array.h"
#include "aString.h"
#include "Screen.h"
#define SPLIT_VALUE    32766

#define MAX_BUFF_LEN 16384

enum hebStringMode { StrHebrew, StrEnglish } ;

#define HEBREW 0x01
#define ENGLISH 0x02
#define INVALID_HEBREW_WORD 0x04
#define INVALID_ENGLISH_WORD 0x08
#define INVALID_LAXET_COMMAND 0x10
#define VALID_LAXET_COMMAND 0x20

class Location {
  int offset ;
  unsigned char code ;
public:
  int operator=(int x) { return offset = x ; }
  Location& operator=(Location& l) { offset = l.offset ; code = l.code ;
                                     return *this ; }
  int operator==(int x) {return offset == x ; }
  int operator==(Location& l) {return (offset == l.offset) &&
                                 (code == l.code) ; }
  operator int() { return offset ; }
  Location() { offset = 0 ; code = 0 ; }
  Location(int x, char c=0) { offset = x ; c=0 ; }
  Location(Location &l) { offset = l.offset ; code = l.code ; }
  void setCode(char x) { code = x ; }
  void setOffset(int x) { offset = x ; }
  char getCode() { return code ; }
} ;

// typedef int Location  ;

class Locations {
private:
    Array<Location> _locs ;
    static Location *workArea ;
    Location result ;
    int _last ;
    int _minVal ;
public:
   Locations() : _last(0), _minVal(0) {}
   Locations(int last) : _last(last), _minVal(0) {}
   Locations(Locations &l) : _locs(l._locs) , _last(l._last), _minVal(l._minVal) {}
   ~Locations() { _locs.clear() ; }

   void addLeft(char *buf, hebStringMode lang=StrEnglish, char code=0) ;
   void addLeft(aString str, hebStringMode lang=StrEnglish, char code=0) ;
   void addLeft(Locations &l) ;
   void addLeft(Locations *l) ;

   void addRight(char *buf, hebStringMode lang=StrEnglish, char code=0) ;
   void addRight(aString str, hebStringMode lang=StrEnglish, char code=0) ;
   void addRight(Locations &l) ;
   void addRight(Locations *l) ;

   void addSplitsLeft(int num, hebStringMode lang=StrHebrew) ;
   void addSplitsRight(int num, hebStringMode lang=StrHebrew) ;
   void init(int last) { _locs.clear() ; _last = last ; }
   int last() { return _last; }
   Location operator[](int n) ;
   int getMinVal() { return _minVal ; }
   int setMinVal(int m) { return _minVal = m ; } // PORT: return
   int getMaxVal() { return _last + _minVal ; }
   void print() ;
   void clearCodes() ;
} ;

#endif
