/***************************************************************************
                          Screen.h - Screen abstraction, alows me to do
                          Vio (OS/2) subclasses, curses (POSIX) subclasses,
                          Win32 Console API (Windows) subclasses, etc.
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __Screen_h__
#define __Screen_h__

#define REVERSE_ATTR 0x80
#define BOLD_ATTR    0x40
#define BOLD2_ATTR    0x20
#define BOLD3_ATTR    0x10
#define NORMAL_ATTR  0x00

#include <string.h>

#define MAX_SCREEN_WIDTH 500
#define MAX_WINDOWS 20000


class Screen { // abstract class, defines a virtual screen
protected:
    char left_end_mark ; // marker for end of hebrew paragraph
    char right_end_mark ; // marker for end of english paragraph
   int message_dirty ;
   virtual void _show_message(char *message, int start_col=1) {
      MVAddStr(getLastLineNum(), start_col, (char *)(const char *)message) ;
      Refresh() ;
   }
public:
   virtual void SetAttr(int attr) { current_attr = attr ; }
   virtual void AttrOn(int attr) {current_attr |= attr ; }
   virtual void AttrOff(int attr) { current_attr &= (0xFFFFFFFF & ~attr) ; }
   virtual void TemporaryExit(int justrefresh=0, char *cmd=0, int background=0) = 0 ;
   virtual void Suspend() = 0 ;
   virtual void GetMaxYX(int *y, int *x, int wh=0) = 0;
   virtual void Erase(int wh=0, int flip_reverse=0) = 0;
   virtual void Refresh(int wh=0) = 0;
   virtual void MVAddStr(int y, int x, char *str, int wh=0) = 0;
   virtual void Move(int y, int x, int wh=0) = 0 ;
   virtual void DeleteLn(int wh=0) = 0 ; /* delete the current line */
   virtual void InsertLn(int wh=0) = 0 ; /* inserts a line at cursor */
   virtual int  GetCh() = 0 ;
           /* get next char from input, interactive */
   virtual int  getLastLineNum() = 0 ;
   virtual int  getWidth() = 0 ;
   virtual char *KeyName(int c) = 0 ; /* returns the name of the key
                                         corresponsding with c */
   Screen(int hebrew_location, int alternate_hebrew_location) :
             message_dirty(1),
             hebrew_location(hebrew_location) ,
             alternate_hebrew_location(alternate_hebrew_location) ,
            current_attr(NORMAL_ATTR) {}
// Keyboard translations special keys:
   int ENTER, REFRESH, F1, HELP, F2, SAVE, LEFT, RIGHT,
       UP, DOWN, SUSPEND, F3, EXIT, F4, F5, F6, GOTO_LINE, F7,F8,F9,F10,F11,F12, BACKSPACE,
       DC/*delete char*/, DL/*delete line*/, NPAGE, PPAGE,
       END, HOME , TAB ;
    char special_separator ; // a character to mark special spaces, set by VioScr and CursesScreen
    int hebrew_location ;
    int alternate_hebrew_location ;
    int current_attr ;
   virtual void Message(char *message, int start_col=1) {
     AttrOff(REVERSE_ATTR) ;
     MessageClear(1) ;
     _show_message(message,start_col) ;
     message_dirty = 1 ;
    }
   virtual int Question(char *message) {
     MessageClear() ;
     message_dirty = 1 ;
       Message(message) ;
       Move(getLastLineNum(), strlen(message)) ;
       return GetCh() ;
    }

   virtual void MessageClear(int force=0) ;
   virtual void MessageTip(int force=0) ;
   virtual char get_left_end_mark() { return left_end_mark ; }
   virtual char get_right_end_mark() { return right_end_mark ; }
   virtual int allocateNewWindow(int nlines, int ncols,
                                 int begin_y, int begin_x, int b) = 0 ;
        // returns a window handle
   virtual void closeAllocatedWindow(int wh) = 0 ;
   virtual void setWindowTopTitle(char *str, int wh) = 0;
} ;

#endif
