/***************************************************************************
                          Undo.cxx - Handle unlimited undo of file
                          modifications
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Edit.h"



UndoSt*
Undo::chunk[CHUNK_SIZE] ;


int
Undo::chunk_init = 0 ;

Undo::Undo(Edit *edit) :
    last_saved(0),
    edit(edit)
{
      if (!chunk_init) 
         for (int i=0 ; i < CHUNK_SIZE ; i++) chunk[i] = 0 ;

      _lastUndo.append(chunk,CHUNK_SIZE) ;
      current = 0 ; limit = current+1 ;
      _lastUndo[current] = new UndoSt() ;
}


void
Undo::invalidate_current()
{
     if (!_lastUndo[current]->recorded()) return ;
 
     current++ ;
     if (current >= _lastUndo.get_size()-1) _lastUndo.append(chunk,CHUNK_SIZE) ;
     if (!_lastUndo[current]) {
          _lastUndo[current] = new UndoSt() ;
     }
     _lastUndo[current]->act_type = UndoSt::ActInvalid ;
     _lastUndo[current]->clear() ;
     if (_lastUndo[current+1])
       _lastUndo[current+1]->clear() ;
}

void
Undo::record_action(UndoSt::ActionType actType, aString &data, 
                    Marker before, Marker after, Marker startm, 
                    Marker endm, char *replace_text)
{
    if ((actType != _lastUndo[current]->act_type) ||
         (!(_lastUndo[current]->after).isEqual(before)) ||
         (actType == UndoSt::ActMove)) {
     if (_lastUndo[current]->act_type != UndoSt::ActInvalid) 
        current++ ;
     if (!_lastUndo[current]) {
          _lastUndo[current] = new UndoSt() ;
     }
     if (current >= _lastUndo.get_size()-1) _lastUndo.append(chunk,CHUNK_SIZE) ;
     _lastUndo[current]->before = before ;
     _lastUndo[current]->act_type = actType ;
     _lastUndo[current]->clear() ;
     _lastUndo[current]->startm = startm ;
     _lastUndo[current]->endm = endm ;
     if (_lastUndo[current+1])
        _lastUndo[current+1]->clear() ;
     limit = current+1 ;
    } 
   _lastUndo[current]->after = after ;
   switch (actType) {
      case UndoSt::ActInsert:
         _lastUndo[current]->append((char *)(const char *)data) ;
         break ;
      case UndoSt::ActDelete:
         _lastUndo[current]->append((char *)(const char *)data) ;
         break ;
      case UndoSt::ActBackSpace:
         _lastUndo[current]->prepend((char *)(const char *)data) ;
         break ;
      case UndoSt::ActMove:
         _lastUndo[current]->set((char *)(const char *)data) ;
         break ;
      case UndoSt::ActReplace:
         _lastUndo[current]->set((char *)(const char *)data) ;
         if (replace_text)
           _lastUndo[current]->set2(replace_text) ;
         break ;
      default:
         break ;
   }
}

void
Undo::undo_last_action()
{
   if (current == 0) return ;

   if (!(_lastUndo[current]->recorded()))
      current-- ;

   if (current == 0) return ;

   if (current == limit-1) {
     save_startm = edit->file.getStartMarker() ;
     save_endm = edit->file.getEndMarker() ;
   }

   switch (_lastUndo[current]->act_type) {
      case UndoSt::ActInsert:
         edit->_deleteDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->before) ;
         break ;
      case UndoSt::ActDelete:
         edit->_insertDataBlock(_lastUndo[current]->after, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->before) ;
         break ;
      case UndoSt::ActBackSpace:
         edit->_insertDataBlock(_lastUndo[current]->after, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->before) ;
         break ;
      case UndoSt::ActMove:
         edit->_deleteDataBlock(_lastUndo[current]->after, _lastUndo[current]->data) ;
         edit->_insertDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->before) ;
         break ;
      case UndoSt::ActReplace:
         edit->_deleteDataBlock(_lastUndo[current]->before, _lastUndo[current]->data2) ;
         edit->_insertDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->before) ;
         break ;
      default:
        break ;
    }
   edit->file.setStartMarker(_lastUndo[current]->startm.line, _lastUndo[current]->startm.offset) ;
   edit->file.setEndMarker(_lastUndo[current]->endm.line, _lastUndo[current]->endm.offset) ;
   edit->_markBlock() ;
   current-- ;
}


void
Undo::redo_last_action()
{
   if (current == limit-1) return ;
   current++ ;

   switch (_lastUndo[current]->act_type) {
      case UndoSt::ActInsert:
         edit->_insertDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->after) ;
         break ;
      case UndoSt::ActDelete:
         edit->_deleteDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->after) ;
         break ;
      case UndoSt::ActBackSpace:
         edit->_deleteDataBlock(_lastUndo[current]->after, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->after) ;
         break ;
      case UndoSt::ActMove:
         edit->_deleteDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_insertDataBlock(_lastUndo[current]->after, _lastUndo[current]->data) ;
         edit->_relocateAtMarker(_lastUndo[current]->after) ;
         break ;
      case UndoSt::ActReplace:
         edit->_deleteDataBlock(_lastUndo[current]->before, _lastUndo[current]->data) ;
         edit->_insertDataBlock(_lastUndo[current]->before, _lastUndo[current]->data2) ;
         edit->_relocateAtMarker(_lastUndo[current]->after) ;
         break ;
      default:
         break ;
    }

   if (current == limit-1) {
     edit->file.setStartMarker(save_startm.line, save_startm.offset) ;
     edit->file.setEndMarker(save_endm.line, save_endm.offset) ;
   } else {
     edit->file.setStartMarker(_lastUndo[current+1]->startm.line, _lastUndo[current+1]->startm.offset) ;
     edit->file.setEndMarker(_lastUndo[current+1]->endm.line, _lastUndo[current+1]->endm.offset) ;
   }
   edit->_markBlock() ;
}

