/***************************************************************************
                          Undo.h - Handle unlimited undo of file
                          modifications
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __Undo_h__
#define __Undo_h__

#include <string.h>

class Edit ;

#define DATA_ALIGNMENT 64

struct UndoSt {
   Marker before, after , startm, endm ;
   enum ActionType { ActInsert, ActDelete, ActMove, ActReplace, ActNull, ActBackSpace, ActInvalid } act_type ;
   char *data ;
   char *data2 ; // for replace
   int size ;
   UndoSt() : act_type(ActNull){ 
         Marker nowhere={0,0,-1} ;
         before=after=startm=endm=nowhere ;
         data=0 ; data2 = 0 ; size=0;} 
   ~UndoSt() { clear() ; }
   int recorded() { return data!=0 ; }
   void set(char *str) {
         if (size > (int)strlen(str)) {
            strcpy(data,str) ;
         } else {
           if (data) {
              delete data ;
           } /* endif */
           data = strdup(str) ;
           size = strlen(str)+1 ;
         }
      }
   void set2(char *str) {
         if (data2) {
            delete data2 ;
         } /* endif */
         data2 = strdup(str) ;
      }
   void clear() { 
         if (data) delete data ;
         data = 0 ; 
         size=0 ;
         if (data2) delete data ;
         data2 = 0 ; 
      }
   void append(char *str) {
         if (data) {
            int len = strlen(data)+strlen(str)+1 ;
            char *tmp = data ;
            if (len > size) {
               size = ((len / DATA_ALIGNMENT) + 1) * DATA_ALIGNMENT + 1 ;
               tmp = new char[size] ;
               strcpy(tmp, data) ;
               delete data ;
               data = tmp ;
            } /* endif */
            strcat(data,str) ;
         } else {
            set(str) ;
         } /* endif */
   }
   void prepend(char *str) {
         if (data) {
            size = strlen(data)+strlen(str)+1 ;
            char *tmp = new char[size] ;
	    strcpy(tmp,str) ;
            strcat(tmp,data) ;
            delete data ;
            data = tmp ;
         } else {
            set(str) ;
         } /* endif */
   }
} ;

#define CHUNK_SIZE 50

class Undo {
   Array<UndoSt*> _lastUndo ;
   static UndoSt* chunk[CHUNK_SIZE] ;
   static int chunk_init ;
   int current , last_saved ;
   int limit ;
   Edit *edit ;
   Marker save_startm, save_endm ;
public:
   Undo(Edit *edit) ; 

   void record_action(UndoSt::ActionType actType, aString& data,
                      Marker before, Marker after, Marker startm, Marker endm, 
                      char *replace_text=0) ;
   void undo_last_action() ;
   void redo_last_action() ;
   void invalidate_current() ; 
   int get_count() { return limit-1 ; }
   int get_current() { return current ; }
   void saved_here() { last_saved = current ; }
   int get_last_saved() { return last_saved ; }
   int is_modified() { return !(((last_saved == current) && (!_lastUndo[current]->recorded())) ||
				 ((last_saved > 0) && (last_saved == current))); }
} ;



#endif
