/***************************************************************************
                          aDictionary.h - Spell checker declaration
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __aDictionary_h__
#define __aDictionary_h__

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "List.h"

#define HASH_SIZE 512
#define MAX_WORD_LENGTH 100

class HebrewEditor ;

class aDictionary {
  int missTyped(char *srcW, char *dicW) ;
  int transposedLetters(char *srcW, char *dicW) ;
  int missedLetters(char *srcW, char *dicW) ;
  HebrewEditor *he ;
  List<char *> _base[HASH_SIZE] ;
  unsigned char         _bean[HASH_SIZE] ;
  List<char *> _supplement ;
  char *_baseFileName ;
  char *_addFileName ;
  int  _hash(char *str) ;
  char buff[MAX_WORD_LENGTH] ;
  FILE *recordBadWords ;
  void loadFromFile(char *fileName) ;
public:
  aDictionary(HebrewEditor *he, char *baseFileName, char *addFileName) ;
  int findMatchingWords(int accuracyLevel, char *word, char **results, int &result_count,
                        int result_count_max=10) ;
  int findMatch(char *word) ;
  int addWord(char *word) ;
  void recordBadWordsOn() ;
  void recordBadWordsOff() ;
} ;

class aHebrewDictionary : public aDictionary {
  char buff[MAX_WORD_LENGTH] ;
public:
  aHebrewDictionary(HebrewEditor *he, char *baseFileName, char *addFileName) :
     aDictionary(he, baseFileName,addFileName) {}
  int findMatchingWords(int accuracyLevel, char *word, char **results, int &result_count,
                        int result_count_max=10) ;
  int findMatch(char *word) ;
} ;

#endif
