/***************************************************************************
                         aSelectionBox.h - an Edit class based menu
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __aSelectionBox_h__
#define __aSelectionBox_h__


class aSelectionEditBox : public Edit {
protected:
   aString prefix ;
   aString work ;
protected:
   virtual int  getActiveSpelling() { return 0 ; }
   virtual int show_line_end_marks() { return 0 ; }
   virtual void _maketitle(int show=0) { Edit::_maketitle(0) ; } ;
// MESSAGE HANDLERS
public:
   virtual void _LaxetCommandHelp(Action::Actions act) { return ; }
   virtual void _SpellWord(Action::Actions act) { return ; }
   virtual void _LearnAllWords(Action::Actions act) { return ; }
   virtual void _MarkBlockBegin(Action::Actions act) { return ; }
   virtual void _MarkBlockEnd(Action::Actions act) { return ; }
   virtual void _UnmarkBlock(Action::Actions act) { return ; }
   virtual void _DeleteBlock(Action::Actions act) { return ; }
   virtual void _CopyBlock(Action::Actions act) { return ;}
   virtual void _MoveBlock(Action::Actions act) { return ; }
   virtual void _Suspend(Action::Actions act) { return ; }
   virtual void _Help(Action::Actions act) {return ; }
   virtual void _Find(Action::Actions act) { return ; }
   virtual void _DeleteChar(Action::Actions act) { return ; }
   virtual void _BackSpace(Action::Actions act) { return ; }
   virtual void _DeleteLine(Action::Actions act) { return ; }
   virtual void _SaveFile(Action::Actions act) { return ; }
   virtual void _Refresh(Action::Actions act) { return ; }
   virtual void _NewLine(Action::Actions act) { _Exit(act) ; }
   virtual void _Exit(Action::Actions act)
     { modified = 0 ; Edit::_Exit(act) ; }
   virtual void _RealForwardChar(Action::Actions act) { return ; }
   virtual void _RealBackwardChar(Action::Actions act) { return ; }
   virtual void _ForwardChar(Action::Actions act) { return ; }
   virtual void _BackwardChar(Action::Actions act) { return ; }
   virtual void _NextLine(Action::Actions act) {
      if (current_line == file.lines())
         _BeginningOfFile(act) ;
      else
         Edit::_NextLine(act) ;
   }
   virtual void _PreviousLine(Action::Actions act) { 
      if (current_line == 1) 
         _EndOfFile(act) ;
      else
         Edit::_PreviousLine(act) ;
   }
   
   virtual void _Home(Action::Actions act) { return ; }
   virtual void _End(Action::Actions act) { return ; }
   virtual void _Char(Action::Actions act) { return ; }
public:
   aSelectionEditBox(HebrewEditor *he, char *title, const char *items,
		 aWindow *win,int startline=1) :
                 Edit(he, title, items,win) {
      file.deactivateSpelling() ;
      file.set_show_line_end_marks(0, sizex) ;
      if (file.lines()) {
	Marker at = {startline,0,-1} ;
	_relocateAtMarker(at) ;
	aSelectionEditBox::refresh() ;
      }
   }
  // SINCE LINEEDITS are leaches on existing windows, line edit is not allowed to delete
  // the window.
  ~aSelectionEditBox() {}

   virtual void processAction(Action::Actions act) {
     Edit::processAction(act) ;
       file.setStartMarker(current_line, 0) ;
       file.setEndMarker(current_line, ((aString&)file.line(current_line)).length()-1) ;
     _refresh() ;
   }
   
   virtual void refresh() {
       win->MessageClear() ;
       file.setStartMarker(current_line, 0) ;
       file.setEndMarker(current_line, ((aString&)file.line(current_line)).length()-1) ;
       _refresh() ;
   }
   virtual char *getText() {
      aString tmp=(char *)(const char *)((aString &)(file.line(current_line))) ;
      if (tmp.length() > 0)
            work=tmp.at(0,tmp.length()-1) ; // remove the last ' '
      return (char *)(const char *)work ;
   }
} ;


template <class T>
class aSelectionBox {
  HebrewEditor *he ;
  aString members ;
  aString title ;
  Screen *parent ;
  int current_member ;
  T noselection_return_value ;
  int maxlen ;
  int member_count ;
  aWindow *mywin ;
  int border ;
  Array<T> return_values ;
  Array<const char *> comments ;
public:
  aSelectionBox(HebrewEditor *he, T noselection_return_value, char *title, Screen *scr,
		int border=1) :
		  he(he),
      members(""), title(title), parent(scr), current_member(0),
      noselection_return_value(noselection_return_value), maxlen(0),
      member_count(0), mywin(0), border(border) {}
  void addMember(aString new_member, T member_return_value,
		 int set_as_current, const char *comment=0) {
    if (new_member.length() > maxlen) maxlen = new_member.length() + 2 ;
    return_values.append(member_return_value) ;
    comments.append(comment) ;

    if (member_count)
      members+='\n' ;
    members += new_member ;
    if (set_as_current) current_member = member_count ;
    member_count++ ;
  }
  T select() {
    if (!member_count) return noselection_return_value ;

    int sizex, sizey ;
    parent->GetMaxYX(&sizey, &sizex) ;
    int lines = member_count ; // 1 is for the frame
    if (lines > sizey-5) lines = sizey-5 ;
    if (lines < 1) lines = 1 ;
    maxlen+=2 ;
    if (maxlen < title.length()+4) 
	maxlen=title.length()+4 ;
    if (maxlen > sizex-10) maxlen = sizex-10 ;      	

    mywin=new aWindow(parent, lines, maxlen,
		      (sizey-lines)/2, (sizex-maxlen)/2 , border) ;
    mywin->SetReverseFlip() ;
    mywin->Erase() ;
    aSelectionEditBox sb(he, (char *)(const char*)title, (const char *)members,
			 mywin, current_member+1) ;
  
    sb.refresh() ;
  
    while (!sb.finished()) {
      if (comments[sb.get_current_line()-1]) {
         sb.refresh() ;
         parent->Message((char *)comments[sb.get_current_line()-1]) ;
         parent->AttrOn(REVERSE_ATTR) ;
      } /* endif */
      Action::Actions act = sb.getNextAction() ;
      sb.processAction(act) ;
      if (act == Action::NewLine) {
	parent->AttrOff(REVERSE_ATTR) ;
        mywin->MessageClear() ;
        delete mywin ;
	mywin = 0 ;
        return return_values[sb.get_current_line()-1] ;
      }
    }
    parent->AttrOff(REVERSE_ATTR) ;
    mywin->MessageClear() ;
    delete mywin ;
    mywin = 0 ;
    return noselection_return_value ;
  }
} ;


#endif
