/***************************************************************************
                          aString - a versatile String implementation
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "aString.h"

char
aString::replicate_buffer[MAX_REPLICATE_COUNT] ;

char * areplicate(char c, int count)  {
            char *replicate_buffer = aString::replicate_buffer ;
            if (count > MAX_REPLICATE_COUNT) {
               count = MAX_REPLICATE_COUNT-1 ;
            } /* endif */
            if (count >= 0) {
               replicate_buffer[count]='\0' ; memset(replicate_buffer,c,count) ;
            } else replicate_buffer[0] = '\0' ;
            return replicate_buffer ;
} ;

void
aString::insert_ch(int at, char ch)
{
      if ((at <0) || (at > len))
         return ;
      if (!data) {
        (*this) += ch ;
        return ;
      }
      if (len+1 >=size) {
         size = ALIGN(len+2) ;
         char *tmp = new char[size] ;
         if (at > 0)
            strncpy(tmp, data, at) ;
         tmp[at] = ch ;
         if (at < len)
            strncpy(tmp+at+1, data+at, len-at) ;
         tmp[len+1] = '\0' ;
         delete[] data ;
         data = tmp ;
      } else {
         if (at < len) {
           for (char *ptr=data+len ; ptr-data > at ; ptr--)
              *ptr=*(ptr-1) ;
//           memmove(data+at+1, data+at, len+1-at) ;
           data[len+1] = '\0' ;
           data[at] = ch ;
         } else {
           data[at] = ch ;
           data[at+1] = '\0' ;
         }
      } /* endif */
      len++ ;
}
void
aString::delete_ch(int at)
{
      if ((at < 0) || (at >= len) || (!data))
         return ;
      for (char *ptr=data+at ; *ptr ; ptr++)
          *ptr = *(ptr+1) ;
      data[len] = '\0' ;
//      memmove(data+at, data+at+1, len) ;
      len -- ;
}

