/***************************************************************************
                          aString - a versatile String declaration
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __aString_h__
#define __aString_h__

#include <string.h>
#include <stdlib.h>

#define aString_ALIGNMENT 16
#define ALIGN(x)   ( (1+((x)/aString_ALIGNMENT))* aString_ALIGNMENT )
#define MAX_REPLICATE_COUNT 2000

class aString {
   char *data ;
   int len ;
   int size ;
   static char replicate_buffer[MAX_REPLICATE_COUNT] ;
public:
   aString() : data(0), len(0), size(0) { }
   aString(char *s) : data(0), len(0) , size(0) {
       if (s) {
          len = strlen(s) ;
          size = ALIGN(len+1) ;
          data=new char[size];
          strcpy(data,s) ;
       }
   }

   aString(const char* s) : data(0), len(0) , size(0) {
      if (s) {
        len=strlen(s);
        size = ALIGN(len+1) ;
        data=new char[size] ;
        strcpy(data,s);
      }
   }
   aString(const aString &as) : data(0), len(0) , size(0) {
      if (as.data) {
         len = as.len;
         size = ALIGN(len+1) ;
         data=new char[size] ;
         strcpy(data,as.data) ;
      }
   }
   ~aString() {
     if (data) delete data ;
     size = 0 ; len = 0 ;
     }

// operators
   operator const char *() { if (data) return data ; else return "" ; }
   aString& operator +=(const aString& as) {
       if (!data) {
          if (as.data) {
             len = as.len ;
             size = ALIGN(len+1) ;
             data = new char [size]  ;
             strcpy(data,as.data) ;
          }
       } else {
          if (as.data) {
             if (len+as.len+1 <= size) {
                strcat(data,as.data) ;
                len+=as.len ;
             } else {
               size = ALIGN(len+as.len+1) ;
               char *tmp = new char[size] ;
               strcpy(tmp, data) ; strcat(tmp, as.data) ;
               len += as.len ;
               delete[] data ;
               data = tmp ;
             } /* endif */
          }
       } /* endif */
       return (*this) ;
   }
   aString& operator +=(const char *s) { aString t=s ; return (*this)+=t ; }
   aString& operator +=(char *s) { aString t=s ; return (*this) += t ; }
   aString& operator +=(char c) { char buf[2]={c,0} ; aString t = buf ;return (*this) += t ; }

   aString& operator =(const aString& as) {
      if (data) {
         delete[] data ;
         data = 0 ;
         len=0 ; size=0 ;
      }
      if (as.data) {
         len = as.len ;
         size = ALIGN(len+1) ;
         data = new char[size] ;
         strcpy(data, as.data) ;
      } /* endif */
     return (*this) ;
   }
   aString& operator =(char *s) { aString t=s ; return (*this) = t ; }
   aString& operator =(char c) { char buf[2]={c,0} ; aString t = buf ;return (*this) = t ; }
// functions
   int length() { return len ; }
friend aString operator+(const aString& a1, const aString& a2) { aString t=a1 ; t+=a2 ; return t ; }
friend aString operator+(char *s, const aString& a2) { aString t=s ; t+=a2 ; return t ; }
friend aString operator+(char c, const aString& a2) { aString t ; t=c ;  t+=a2 ; return t ; }
friend aString operator+(const aString& a1, char *s) { aString t=a1; t+=s ; return t ; }
friend aString operator+(const aString& a1, char c) { aString t=a1; t+=c ; return t ; }

   int operator == (const aString &as) {
      if (!data && !as.data) {
         return 1 ;
      } else {
        if (data && as.data) {
           return !strcmp(data,as.data) ;
        } else {
           return 0 ;
        } /* endif */
      } /* endif */
   }
   int operator == (const char *s) { aString t = s ; return (*this) == t ; }
   int operator == (char *s) { aString t = s ; return (*this) == t ; }
   int operator == (char c) { aString t ; t = c ; return (*this) == t ; }

   char operator[](int at) { if ((data)  && (at >=0) && (at < len)) return data[at] ; return '\0' ; }

   char * replicate(char c, int count) {
            if (count > MAX_REPLICATE_COUNT) {
               count = MAX_REPLICATE_COUNT-1 ;
            } /* endif */
            if (count >= 0) {
               replicate_buffer[count]='\0' ; memset(replicate_buffer,c,count) ;
            } else replicate_buffer[0]='\0' ;
            return replicate_buffer ;
   }
   aString at(int start, int end) {
      aString t ;
      if ((start >=0) && (start < len) && (end >= start)) {
         if (end < len) {
            char *buf = new char[1+end - start] ; buf[end-start] = '\0' ;
            if (end>start) {
               strncpy(buf, data+start, (end-start)) ;
            }
            t = buf ;
         } else { // copy what's left
            t= data + start ;
         } /* endif */
      } /* endif */
      return t ;
   }
   void insert_ch(int at, char ch) ;
   void delete_ch(int at) ;
friend char *areplicate(char c, int count) ;
} ;



#endif
