/***************************************************************************
                          aWindow.cxx - a Window abstraction layer (uses a
                                  subclass of string to provide windowing
                                  functionality on text terminals).
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h> //PORT: moved as first because ofstrlen.
#include "aWindow.h"

int
aWindow::initialized = 0 ;

int
aWindow::nextWindow = 0 ;

aWindow*
aWindow::openWindows[MAX_WINDOWS] ;

//char
//aWindow::buffer[MAX_SCREEN_WIDTH] ;


aWindow::aWindow(Screen* sc) {
  scr = sc ;
  window_handle = 0 ;
  flip_reverse = 0 ;
  if (!initialized)
    initializeWindows() ;

  openWindows[nextWindow++] = this ;
}

aWindow::aWindow(Screen* sc, int nlines, int ncols, int begin_y, int begin_x, int b) {
  scr = sc ;
  flip_reverse = 0 ;
  if (!initialized)
    initializeWindows() ;

  window_handle = scr->allocateNewWindow(nlines, ncols, begin_y, begin_x, b) ;

  openWindows[nextWindow++] = this ;
}

void
aWindow::initializeWindows()
{
  for (int i=0; i< MAX_WINDOWS; i++) {
    openWindows[i] = (aWindow *)0 ;
  }
  initialized = 1 ;
}

aWindow::~aWindow()
{
  if (window_handle) {
    scr->closeAllocatedWindow(window_handle) ;
  }
  scr->AttrOff(REVERSE_ATTR) ;
}



void
aWindow::setWindowTopTitle(char *str)
{
  static char buf[MAX_SCREEN_WIDTH] ;
  buf[0]=' ' ;
  strcpy(buf+1, str) ;
  strcat(buf," ") ;
  scr->setWindowTopTitle(buf, window_handle) ;
}

void
aWindow::MVAddStrAttr(int y, int x, char *str, char *attr)
{
   buffer[0]='\0' ;
   char *ptr = buffer ;

   while (*attr) {
      switch (*attr++) {
      case '1':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOn(REVERSE_ATTR) ;
         break;
      case '!':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOff(REVERSE_ATTR) ;
         break;
      case '2':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOn(BOLD_ATTR) ;
         break;
      case '@':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOff(BOLD_ATTR) ;
         break;
      case '3':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOn(BOLD2_ATTR) ;
         break;
      case '#':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOff(BOLD2_ATTR) ;
         break;
      case '4':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOn(BOLD3_ATTR) ;
         break;
      case '$':
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
         AttrOff(BOLD3_ATTR) ;
         break;
      default:
         if (*str)
            *ptr++ = *str++ ;
         *ptr = '\0' ;
         break;
       }
   } /* endwhile */
         if (*buffer) {
            MVAddStr(y,x,buffer) ;
            x+= ptr-buffer ;
            buffer[0]='\0' ;
            ptr = buffer ;
         } /* endif */
  AttrOff(REVERSE_ATTR) ;
  AttrOff(BOLD_ATTR) ;
  AttrOff(BOLD2_ATTR) ;
  AttrOff(BOLD3_ATTR) ;
  SetAttr(NORMAL_ATTR) ;
}


