/***************************************************************************
                          aWindow.h - a Window abstraction layer (uses a
                                  subclass of string to provide windowing
                                  functionality on text terminals).
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __aWindow_h__
#define __aWindow_h__

#include "Screen.h"

class aWindow  { // a class for handling windows
   char buffer[MAX_SCREEN_WIDTH] ;
protected:
    char left_end_mark ; // marker for end of hebrew paragraph
    char right_end_mark ; // marker for end of english paragraph
   int flip_reverse ;
public:
   int window_handle ;
   Screen* scr ;

   void SetReverseFlip() { scr->AttrOn(REVERSE_ATTR) ;
			   flip_reverse = REVERSE_ATTR ; }
   void SetReverseUnFlip() { flip_reverse = 0 ; scr->AttrOff(REVERSE_ATTR) ;}
   
   void SetAttr(int attr) { scr->SetAttr(attr ^ flip_reverse) ; }
   void AttrOn(int attr) {
     if (!flip_reverse) scr->AttrOn(attr) ;
     else if (attr & REVERSE_ATTR) {
       scr->AttrOn(attr ^ flip_reverse) ;
       scr->AttrOff(REVERSE_ATTR) ;
     } else scr->AttrOn(attr) ;
   }
   void AttrOff(int attr) {
     if (!flip_reverse) scr->AttrOff(attr) ;
     else if (attr & REVERSE_ATTR) {
       scr->AttrOff(attr ^ flip_reverse) ;
       scr->AttrOn(REVERSE_ATTR) ;
     } else scr->AttrOff(attr) ;
   }
  virtual void TemporaryExit(int justrefresh=0) { scr->TemporaryExit(justrefresh) ; }
  virtual void Suspend() { scr->Suspend() ; }
  virtual void GetMaxYX(int *y, int *x) { scr->GetMaxYX(y,x, window_handle) ; }
  virtual void Erase() {scr->Erase(window_handle, flip_reverse) ; }
  virtual void Refresh() { scr->Refresh(window_handle) ; }
  virtual void MVAddStr(int y, int x, char *str) {
    scr->MVAddStr(y,x,str, window_handle) ;
  }
  virtual void Move(int y, int x) {
    scr->Move(y,x, window_handle) ;
  }
   virtual void DeleteLn() { /* delete the current line */
     scr->DeleteLn(window_handle) ;
   }
   virtual void InsertLn() { ; /* inserts a line at cursor */
     scr->InsertLn(window_handle) ;
   }
   virtual int  GetCh() { /* get next char from input, interactive */
     return scr->GetCh() ;
   }
  virtual int  getLastLineNum() {
    return scr->getLastLineNum() ;
  }
   virtual char *KeyName(int c) { /* returns the name of the key 
                                         corresponsding with c */
     return scr->KeyName(c) ;
   }
   aWindow(Screen* scr) ;
   aWindow(Screen* scr, int nlines, int ncols, int begin_y, int begin_x, int b=1) ;

   virtual ~aWindow() ;
   
    void Message(char *message, int start_col=1) {
      if (flip_reverse) {
        SetReverseUnFlip() ;
	scr->Message(message, start_col) ;
        SetReverseFlip() ;
      } else {
	scr->Message(message, start_col) ;
      } /* endif */
    }
    int Question(char *message) {
      return scr->Question(message) ;
    }
    void MessageTip(int force=0) {
      if (flip_reverse) {
        SetReverseUnFlip() ;
	scr->MessageTip(force) ;
        SetReverseFlip() ;
      } else {
	scr->MessageTip(force) ;
      } /* endif */
    }
    void MessageClear(int force=0) {
      if (flip_reverse) {
        SetReverseUnFlip() ;
	scr->MessageClear(force) ;
        SetReverseFlip() ;
      } else {
	scr->MessageClear(force) ;
      } /* endif */
    }
  virtual void MVAddStrAttr(int y, int x, char *str, char *attr) ;
  virtual char get_left_end_mark() { return scr->get_left_end_mark() ; }
  virtual char get_right_end_mark() { return scr->get_right_end_mark() ; }

  static int initialized ;
  static aWindow* openWindows[MAX_WINDOWS] ;
  static int nextWindow ;
  void initializeWindows() ;
  void BottomTitleStr(char *str) {
    int curattr = scr->current_attr ;
    SetAttr(REVERSE_ATTR) ;
    scr->MVAddStr(getLastLineNum()-1,0,str,0) ;
    SetAttr(curattr) ;
//    scr->Refresh() ;
  }
  void setWindowTopTitle(char *str) ;
} ;



#endif
