 The following table summarises the key assignments in Hebrew Editor 
 
 Note that ^A actually means Ctrl+A, and ESC-A means pressing ESC (Escape) then pressing A, this rules apply to all the key assignments shown in the following table. 
 
 Use the Exit(kill-buffer) key sequence to exit this Help screen. 
 
+------------------------+-----------------------+ 
|  Function              | Assigned key sequences| 
+------------------------+-----------------------+ 
|Menus:                  |                       | 
|  main-menu.............| ESC-0                 | 
|                        | F10                   | 
|  file-menu.............| ESC-ESC-f             | 
|  edit-menu.............| ESC-ESC-e             | 
|  search-menu...........| ESC-ESC-s             | 
|  LaTeX-menu............| ESC-ESC-l             | 
+------------------------+-----------------------+ 
|Move to:                |                       | 
|  beginning-of-line.....| ^A                    | 
|                        | HOME                  | 
|  end-of-line...........| ^E                    | 
|                        | END                   | 
|  beginning-of-file.....| ESC-A                 | 
|                        | ESC-HOME              | 
|  end-of-file...........| ESC-E                 | 
|                        | ESC-END               | 
|  next-line.............| ^N                    | 
|                        | UP                    | 
|  previous-line.........| ^P                    | 
|                        | DOWN                  | 
|  next-page.............| ESC-N                 | 
|                        | ESC-DOWN              | 
|                        | F8                    | 
|                        | ESC-8                 | 
|  previous-page.........| ESC-P                 | 
|                        | ESC-UP                | 
|                        | F7                    | 
|  goto-line.............| F6                    | 
|                        | ESC-6                 | 
|                        | ^X^G                  | 
|  visual-left-char......| LEFT                  | 
|  visual-right-char.....| RIGHT                 | 
|  logical-backward-char.| ^B                    | 
|  logical-forward-char..| ^F                    | 
|  logical-word-right....| ESC-^F                | 
|  logical-word-left.....| ESC-^B                | 
|  visual-word-right.....| ESC-RIGHT             | 
|  visurl-word-left......| ESC-LEFT              | 
+------------------------+-----------------------+ 
|Deleting:               |                       | 
|  delete-char...........| ^D                    | 
|                        | Delete                | 
|  back-space............| BkSp                  | 
|                        | ^H                    | 
|  delete-line...........| ^Y                    | 
+------------------------+-----------------------+ 
|Block operations:       |                       | 
|  mark-block-begin......| ^K^B                  | 
|  mark-block-end........| ^K^K                  | 
|                        | ^K^E                  | 
|  copy-block............| ^K^C                  | 
|  delete-block..........| ^K^D                  | 
|  move-block............| ^K^V (on OS/2)        | 
|                        | ^K^M                  | 
|  unmark-block..........| ^K^U                  | 
|                        | ^K^H                  | 
+------------------------+-----------------------+ 
|Search                  |                       | 
|  interactive-search....| ESC-s                 | 
|  interactive-replace...| ESC-r                 | 
+------------------------+-----------------------+ 
|Files and Buffers       |                       | 
|  open-file.............| ^X^F                  | 
|  next-buffer...........| F12                   | 
|                        | ESC-@                 | 
|                        | ^Xb                   | 
|                        | ^X^B                  | 
|  previous-buffer.......| F11                   | 
|                        | ESC-!                 | 
|  save-file.............| F2                    | 
|                        | ESC-2                 | 
|                        | PF2                   | 
|  save-file-as..........| ^X^W                  | 
|  Exit(kill-buffer).....| F3                    | 
|                        | ESC-3                 | 
|                        | PF3                   | 
|                        | ^X^C                  | 
|                        | ^K^X                  | 
|  buffer-list           | ^G                    | 
|                        | ^X^B                  | 
+------------------------+-----------------------+ 
|Other operations        |                       | 
|  toggle-language.......| ^W                    | 
|  change-direction......| ESC-W                 | 
|                        | Note: change-direction| 
|                        | will automatically    | 
|                        | insert a sethebrew    | 
|                        | or an unsethebrew     | 
|                        | command at the end    | 
|                        | of the current line   | 
|                        | and move to the next  | 
|                        | line.                 | 
|Oooops!                 |                       | 
|  undo-previous         | ^U                    | 
|                        | F9                    | 
|                        | ESC-9                 | 
|  redo-next             | ESC-^U                | 
|                        | ESC-F9                | 
|                        | ESC-ESC-9             | 
+------------------------+-----------------------+ 
 
You may now press Exit key to return to your edited file. 
 
NOTE: On Unix systems' Xstations, you may use the keyboard function keys, but when working on a terminal (such as vt320) you can instead use ESC-1 for F1, ESC-2 for F2 , etc. 
 
Installation Notes: 
================== 
In order to fully enjoy this package you need to have LaTeX installed with Hebrew support. 
 
One way of getting Hebrew support for LaTeX is through another project called LyX. 
 
LyX now work on adding Hebrew support to their WYSIWYM word processor, but currently their Hebrew word processing support is not on par with Hebrew Editor. 
 
LyX's site is at http://www.lyx.org 
 
To install Hebrew latex support, download 
http://www.math.tau.ac.il/~dekelts/lyx/heblatex.tar.gz 
to /tmp 
 
As root, change directory to /usr/share/texmf 
# tar xzf /tmp/heblatex.tar.gz 
# mktexlsr 
 
 
How to work with HE (Hebrew Edit): 
================================= 
 
 Editing multiple files: 
 ---------------------- 
  You may issue multiple file names in the command line, for example: 
 
  > he2 myfile1.tex myfile2.tex 
 
  You may also use the open-file key (^X^F by default) to load files into an existing Hebrew Editor session. 
 
  You may then use the next-buffer and previous-buffer keys to switch between buffers (each file is being edited within a buffer). 
 
  When exiting a buffer that has been modified, Hebrew Editor will ask for your confirmation. 
 
 
 
 Editing mixed Hebrew/English texts: 
 ---------------------------------- 
  Note that every logical text line is ended with an end mark, like the mark at the end of this line 
  and the reverse mark for hebrew text. 
  The special marks should look like << and >> (but in a single character), if you see cubes instead, or blanks, then you are probably not using a correct font. Some fonts contain only the alphabet letters, and put blanks or cubes for the rest. The end marks really help with orientation in a bidirectional editor, so you should use a correct font. 
 
  HE is semi-LaXeT sensetive, it recognizes some of the constructs of the LaXeT language, and is able to process them and display some of the visual effects they cause, especially in the area of mixing hebrew and english. 
 
  This help file is also processed by HE like any other tex file, so the following demonstrations will work while editing ``real'' files: 
 
  To switch to hebrew use the command 
  \sethebrew 
        ,          .   -   . 
        
  \unsethebrew 
  Notice, however that the function of ^F and ^B keys is somewhat differently in Hebrew. You may use these keys here in the help text, to notice their behavior. 
 
  This editor was written with mixing Hebrew/English in the same line in mind, so in order to put a Hebrew sentence inside an English text we would use the LaXeT \R{ } command, this command causes everything between the { } to be parsed as Hebrew. HE does the same, so by writein \R{     }, Notice that the lines are broken very much like it would show in a LaXeT output (dvi or PostScript). You may now use ^F and ^B to browse this line and see that ^F and ^B go forward/backward using the LOGICAL order of the text instead of the VISUAL order. 
 
  \sethebrew 
         \L{ }    ,  .         . ,    , \L{Like in this sentence}. 
 
  \unsethebrew 
 
  Due to popular demand, two enhancements were added to the Hebrew mechanism, one of them is a language-toggle (^W by default) switch        without using the \L or \R commands. and the other is a change-direction key which automatically inserts a \sethebrew or \unsethebrew command (depending on context), to switch the direction of the rest of the document (or until another direction change command). , so now instead of writing \sethebrew, just press ESC-w (which is the default key assignment for change-direction) % \unsethebrew works inside comments too 
 
 
 
 Compatability with terminals and operating systems: 
 -------------------------------------------------- 
 
  HE was tested on vt320 and now works fine, vt220, vt100 and even the old Rainbow terminals now work fine, after you manually set the terminals to Hebrew 8bit and communication mode 8N (8-Bit Parity=NONE). 
 
  HE is being developed simultaneously for OS/2 and Unix platforms , and was tested to work properly on OS/2 Warp 3.0 , OS/2 Warp 4.0 (Merlin), Solaris 5.5, and Linux. 
 
 
 Working with block operations: 
 ----------------------------- 
 
  Block operations are now also available. To copy a part of your text, go to the beginning of the text, press mark-block-begin (^K^B by default), go to the end of the text you want to copy and press mark-block-end (^K^K by default), now move to the location in the file where you want to copy the block, and press copy-block (^K^C by default). You may also use delete-block to delete a marked block, move-block to move a marked block from one location to another, and copy-block even works between buffers. 
 
 
 Searching for text: 
 ------------------ 
 
  You may use the interactive-search key to search for text in the current buffer, when pressing interactive-search (ESC-s by default), Hebrew Editor will ask you for the language of the search text (since it has to know the keyboard mode for the search), and when you answer 'h' for Hebrew or 'e' for English, HE will ask you for the search text. 
  While typing the text, HE will show you the location in the file where it found the text (it starts by search forward from the current cursor location), and the found text will be marked (just like a marked block). Pressing ENTER will cause HE to remain in this new location, pressing Exit will cancel the search and return to the location where the search started. 
  When a text is found, you may press ESC-s again to search for the next occurrence of the search text. 
  You may also use the previous-line and next-line keys (UP and DOWN by default) to search for previous and next occurrences of the search text, respectively. You may edit the search text line as any other text while searching. 
 
 
 Replacing text: 
 -------------- 
 
  You may use the interactive-replace key (ESC-r by default) to search for and replace text in your document. The replace mechanism is interactive in the sense that the search for the first occurrence is fully interactive (like interactive-search), and after that the mechanism will ask you for each replacement. 
  At any time, during the replace, you may answer Yes (y) to replace, No (n) to find the next match, All (a) to continue replacing all matches in the rest of the document with no questions, or Cancel (c) to abort the replace process 
  If you want to undo a replacement you can use the undo-previous, but be aware that undo-previous treats each replacement as a single modification, even if you used the All option during the replace. 
 
 
 
 Undo & Redo: 
 ----------- 
 
  Ooops, I have made a mistake of deleting some text, what do I do ? Well you now have the option to press the undo-previous key (F9 or ^U) to undo the last changes (plural) to your file. Hebrew Editor keeps track of your modifications while editing, and is able to undo your modifications up until the time the file was initially loaded into it.  If you have out-done yourself by pressing undo-previous too many times, or you regret undoing your changes, you may press redo-next to redo the next changes, up until the moment you first pressed undo-previous 
 
 
LaTeX Comments: 
-------------- 
   
  One of Hebrew Editor's great visual enhancements is the way it treats comments in LaTex. Comments in LaTeX follow the percent sign, and are normally hard to track. However, with Hebrew Editor's visual enhancements, adding a percent sign will cause the rest of the text that follows to appear in a special comment block. For example, the comment after this % is a comment in LaTeX. However, if comment text gets longer than a single line, the visual enhancements cause the commented text to appear specially indented, and 'virtual' percent signs appear at the beginning of each line (Try to use ^F or ^B to move the cursor to these virtual percent signs and you'll see what I mean). 
 
 
 
You can now press Exit (F3 or ESC-3 by default) to return to your edited file. 
 