/***************************************************************************
                          hebFile.cxx - Hebrew file handler
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "hebFile.h"
#include "HebrewEditor.h"
#include <stdio.h>
#include <string.h>

#ifndef MAX_LINE_LENGTH
#define MAX_LINE_LENGTH 10000
#endif

static
void clean128above(unsigned char*s)
{
   for (int i=0; i<(int)strlen((char *)s); i++)
       if ((((int)s[i] >= 128+32) && ((int)s[i] < 224)) 
             || ((int)s[i] > 224+26)) s[i] -= 128 ;
}

static
void cleanControlCodes(char *s)
{
  for (int i =0 ; i<(int)strlen(s); i++)
      if (((int)s[i] >=0) && ((int)s[i] < ' '))
             s[i] = ' ' ;
}

static
void codepageTranslation(unsigned char *s, int current_hebrew_codepage,
			 int alternate_hebrew_codepage)
{
  for (; *s ; s++)
    if ((*s >= alternate_hebrew_codepage) &&
	(*s < alternate_hebrew_codepage+32))
      *s += current_hebrew_codepage - alternate_hebrew_codepage ;
}

void
hebFile::read_file() 
{
    static char buff[MAX_LINE_LENGTH] ;
    FILE *file = 0;
    if (name && *name)
      file=fopen((const char *)(aString &)name, "r") ;

    if (file) {
      while (fgets(buff,MAX_LINE_LENGTH, file)) { 
       clean128above((unsigned char *)buff) ;
       // take care of \r signs (before removing all control codes), to prevent converting them
       // to spaces.
       if (strlen(buff) > 2)
	 if ((buff[strlen(buff)-2] == '\r') && (buff[strlen(buff)-1]=='\n'))
	   buff[strlen(buff)-2] = '\0' ;
       // if the previous removal did not work, than remove the \n at the end of the lines
       if (strlen(buff))
         if (buff[strlen(buff)-1] == '\n') 
            buff[strlen(buff)-1] = '\0' ; /* remove '\n'*/
        cleanControlCodes(buff) ; // converts control codes to spaces 
       if (!*buff) strcpy(buff," ") ;
       if (buff[strlen(buff)-1] != ' ') strcat(buff," ") ;
       codepageTranslation((unsigned char *)buff, startHebrew, alternateHebrew) ;
       data.insert(new hebString(he, buff, startHebrew, StrEnglish, screen, show_line_end_marks,activeSpelling)) ;
       data.move_to(Next) ;
       line_count++ ;
      }
      fclose(file) ;
    }
    if (!line_count) {
       data.insert(new hebString(he, " ",startHebrew, StrEnglish, screen,show_line_end_marks,activeSpelling)) ;
       line_count++ ;
    }
    data.move_to(First) ;
}

int
hebFile::isFileEmpty()
{
     if (lines() > 1) return 0 ;
     if ( ((aString &)line(1)).length() > 1) return 0 ;
     return 1 ;
}


void
hebFile::eraseContent()
{
      while (lines() > 1)
              delete_line(1) ;
      (aString &)line(1) = " " ;
}


void 
hebFile::recompile_file(int line_width)
{
   int tmp = current_line ;
   modeStack stack ;
   stack.push(StrEnglish,"",0) ;
   
     if ((line_count > 1) || ((line_count == 1) && line(1).length())) {
        line(1).set_show_line_end_marks(show_line_end_marks) ;
        line(1).recompile(line_width, stack) ;
       if (line_count > 1) 
         for (line(2) ; current_line <= line_count ; line(current_line+1) ) {
	   line(current_line).set_show_line_end_marks(show_line_end_marks) ;
           line(current_line).recompile(line_width, stack) ;
         }
     }
     data.move_to(First) ;
     current_line = 1 ;
     line(tmp) ;
}

void 
hebFile::spellingRefresh(int line_width)
{
   int tmp = current_line ;
   modeStack stack ;
   stack.push(StrEnglish,"",0) ;
   
     if ((line_count > 1) || ((line_count == 1) && line(1).length())) {
        line(1).set_show_line_end_marks(show_line_end_marks) ;
        line(1).respell(line_width, stack) ;
       if (line_count > 1) 
         for (line(2) ; current_line <= line_count ; line(current_line+1) ) {
	   line(current_line).set_show_line_end_marks(show_line_end_marks) ;
           line(current_line).respell(line_width, stack) ;
         }
     }
     data.move_to(First) ;
     current_line = 1 ;
     line(tmp) ;
}


void 
hebFile::deactivateSpelling()
{
   activeSpelling = 0 ;
   int tmp = current_line ;
   
     if ((line_count > 1) || ((line_count == 1) && line(1).length())) {
        line(1).deactivateSpelling() ;
       if (line_count > 1) 
         for (line(2) ; current_line <= line_count ; line(current_line+1) ) {
           line(current_line).deactivateSpelling() ;
         }
     }
     data.move_to(First) ;
     current_line = 1 ;
     line(tmp) ;
}


void 
hebFile::recompile_section(int line_width, int continueAfterFirstLine)
{
   int tmp = current_line ;
   modeStack stack ;
   if (current_line > 1) line(current_line-1) ;
   while ((current_line > 1) && !line(current_line).isStackValid())
       current_line-- ; // CHANGED HERE FROM current_line-1, which was obviously a bug
   if (current_line == 1) {
       stack.clear() ;
       stack.push(StrEnglish,"",0) ;
   } else 
       stack.copy(line(current_line).getLastModeStack()) ;
   
     if ((line_count > 1) || ((line_count == 1) && line(1).length())) {
       if (continueAfterFirstLine || (current_line <= tmp)) {
        line(current_line).recompile(line_width, stack) ;
           if (line_count > current_line) {
               line(current_line+1) ;
               line(current_line).recompile(line_width, stack) ;
          }
         if (line_count > current_line) 
           for (line(current_line+1) ; current_line <= line_count ; line(current_line+1) ) {
             if ((!continueAfterFirstLine) && (current_line >= tmp)) break ;
             if (line(current_line).isStackValid())
               if (stack.isEqual(line(current_line).getLastModeStack())) {
                   line(current_line).recompile(line_width,stack) ;
                   break ;
               }
             line(current_line).recompile(line_width, stack) ;
//           if (!line(current_line).needToRecompileNextLine(line_width)) break ;
           }
       }
    }
     data.move_to(First) ;
     current_line = 1 ;
     line(tmp) ;
}

int
hebFile::write_file()
{
     int tmp=current_line ;
     FILE *file=fopen((const char *)(aString &)name, "w") ;

     if (file) {
        if ((line_count > 1) || ((line_count == 1) && line(1).length())) {
           fputs((const char *)(aString &)line(1), file) ; 
           if (line_count > 1) 
              for (line(2) ; current_line <= line_count ; line(current_line+1) ) {
                 fputs("\n", file) ;
                 fputs((const char *)(aString &)line(current_line), file) ; 
              }
        }
        fclose(file) ;
        data.move_to(First) ;
        current_line = 1 ;
        line(tmp) ;
        return 1 ;
     }
     return 0 ;
}

hebString&
hebFile::line(int num)
{
   if (num > current_line) {
     for ( ; data.get_item() && current_line < num ; data.move_to(Next),
						     current_line++) ;
   } else if (num < current_line) 
     for ( ; data.get_item() && current_line > num ; data.move_to(Previous),
						     current_line--) ;
   if (data.get_item())
     return *data.get_item() ;
   else
     return invalid_line ;
}
void
hebFile::insert_after(int num, char *str)
{
    line(num) ; // position iterator
    data.move_to(Next) ;
    if (str)
       data.insert(new hebString(he, str, startHebrew, StrEnglish, screen, show_line_end_marks,activeSpelling)) ;
    else
       data.insert(new hebString(he, " ", startHebrew, StrEnglish, screen, show_line_end_marks,activeSpelling)) ;
    line_count++ ;
    current_line++ ;
}
void
hebFile::delete_line(int num)
{
    if (line_count) {
      line(num) ;
      data.del() ;
      line_count-- ;
      if (num <= line_count)
         current_line = num  ;
      else {
	 data.move_to(Last) ;
	 current_line = line_count ;
      }
    }
}

Marker 
hebFile::search(char *searchfor, Marker starting_point) {
    Marker found = starting_point ;
    if (found.offset > ((aString &)line(found.line)).length()-1) {
           if (found.line == lines()) { found.line=-1; found.offset=-1; found.offset_from_top=-1 ; return found ; }
           found.line++ ;
           found.offset = 0 ;
           found.offset_from_top = -1 ;
    }
    aString tmp ;
    
    while (found.line <= lines()) {
        tmp = ((aString &)line(found.line)).at(found.offset, ((aString &)line(found.line)).length()) ;
        char *str = (char *)(const char *)tmp ;
        char *o = strstr(str, searchfor) ;
        if (o) {
            found.offset = found.offset+o-str ;
            return found ;
        }
        found.offset = 0 ; found.line++ ;
    }
  
    found.line=-1 ; found.offset=-1 ;
    return found ;
}

Marker 
hebFile::searchBackward(char *searchfor, Marker starting_point) {
    Marker found = starting_point ;
    if (found.offset < 0) {
           if (found.line == 1) { found.line=-1; found.offset=-1; found.offset_from_top = -1 ; return found ; }
           found.line-- ;
        if (found.line >= 1)
           found.offset =  ((aString &)(line(found.line))).length() ;
    }
    aString tmp ;
    found.offset_from_top = -1 ;
    while (found.line >= 1) {
        tmp = ((aString &)line(found.line)).at(0,found.offset+1) ;
        char *str = (char *)(const char *)tmp ;
        char *o = strstr(str, searchfor) ; // this finds the first ocurance and I need the last
        if (o) {
            char *o1 = strstr(o+1, searchfor) ;
            while (o1) {
               o=o1 ;
               o1 = strstr(o+1,searchfor) ;
            }
            found.offset = o-str;
            return found ;
        }
        found.line-- ;
        if (found.line >=1)
           found.offset = ((aString &)(line(found.line))).length() ;
    }
  
    found.line=-1 ; found.offset=-1 ; found.offset_from_top = -1 ;
    return found ;
}

