/***************************************************************************
                          hebFile.h - Hebrew file handler
                             -------------------
    begin                : Thu Mar  1 13:15:18 IST 2001
    copyright            : (C) 2001 by Arie Tal
    email                : tal_arie@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __hebFile_h_
#define __hebFile_h_

#include "hebString.h"
#include "List.h"
#include "Screen.h"

struct Marker {
    int line ;
    int offset ;
    int offset_from_top ; // for visual effects
    int isEqual(Marker b) {
     return ((line==b.line)&&(offset==b.offset) 
             && (offset_from_top == b.offset_from_top)) ;
   }
} ;


class HebrewEditor ;

class hebFile {
  HebrewEditor *he ;
protected:
  Marker start_marker, end_marker ;
  List<hebString> data ;
  hebString name ;
  int current_line ;
  int modified ;
  int line_count ;
  int startHebrew , alternateHebrew ;
  int specialSeparator ;
  Screen &screen ;
  int show_line_end_marks ;
  int activeSpelling ;
public:
  hebString invalid_line ;

  void deactivateSpelling() ;

  hebFile(HebrewEditor *he, const char *name, int startHebrew, Screen& scr, int show_line_end_marks=1, int activeSpelling = 0):
     he(he),
     name(he, name,startHebrew,StrEnglish,scr),
     current_line(1),
     modified(0),
     line_count(0),
     startHebrew(startHebrew),
     alternateHebrew(scr.alternate_hebrew_location),
     specialSeparator(scr.special_separator),
     screen(scr),
     show_line_end_marks(show_line_end_marks),
     activeSpelling(activeSpelling),
     invalid_line(he, "Invalid Line!!!",startHebrew,StrEnglish,scr)
  {
     read_file() ;
     unmarkBlock() ;
  }

  virtual ~hebFile() {}

  void read_file() ;
  virtual void recompile_file(int line_width) ; // recompile according to a given line width
  virtual void spellingRefresh(int line_width) ; // recompile according to a given line width
  
  // since recompiling the whole file on every char  insertion or deletion can be bogous
  // and hebString saves a copy of the stack whenever it recompiles, then we need to recompile only
  // from the current line, until we reach a situation where the stack is 'invalid' (too meny }) or the stack
  // is 'clear' (only major mode) and the line we have reached was allready compiled with a 'clear' stack.
  // continueAfterFirstLine flag tells recompile_section to continue until the stack is ballanced, or if 0 
  // tells it to stop after the first line.
  // While typing text, (esp. { and }), some visual 'problems' (i.e. it is logically correct, but not so user friendly)
  // may occur on the next lines, such as text order reversal, and others...
  // this here is to somehow help the user by delaying the compilation of the next lines, until MAX_DELAY or
  // a non Char/Delete/BackSpace event is cought.
  virtual void recompile_section(int line_width, int continueAfterFirstLine = 1) ; 
  
  hebString &line(int num) ;
  virtual int write_file() ;
  virtual void insert_after(int num, char *str) ;
  virtual void delete_line(int num) ; //locate at previous if possible - THIS MAKES TROUBLES!!!!!!
  void eraseContent() ;
  int lines() { return line_count ; }
  void setStartMarker(int line, int offset, int offset_from_top=-1) { //PORT: void instead of int
     start_marker.line = line ; start_marker.offset = offset  ;  start_marker.offset_from_top = offset_from_top ;
     if ((start_marker.line > end_marker.line) ||
         ((start_marker.line == end_marker.line) && 
          (start_marker.offset >= end_marker.offset))) 
            end_marker.line = -1 ;
     }
  void setEndMarker(int line, int offset) { end_marker.line = line ; //PORT: void instead of int
                                 end_marker.offset = offset ; end_marker.offset_from_top = -1 ; }
  void unmarkBlock() { end_marker.line=-1 ; start_marker.line=-1 ; } //PORT: void instead of int
  Marker getStartMarker() { return start_marker ; }
  Marker getEndMarker() { return end_marker ; }
  int markActive() { return (end_marker.line != -1) && (start_marker.line != -1) ; }
  int isFileEmpty() ;
  void setName(char *newname) { (aString &)name = newname ; }
  Marker searchBackward(char *searchfor, Marker starting_point) ;
  Marker search(char *searchfor, Marker starting_point) ;
  void set_show_line_end_marks(int v, int sizex) {
    if (v != show_line_end_marks) {
      show_line_end_marks = v ;
      recompile_file(sizex) ;
    }
  }
} ;

#endif
